/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss;

import com.sun.xml.wss.SecurityEnvironment;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.SecurableSoapMessage;
import com.sun.xml.wss.impl.misc.DefaultSecurityEnvironmentImpl;
import com.sun.xml.wss.impl.policy.SecurityPolicy;
import com.sun.xml.wss.impl.policy.StaticPolicyContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.soap.SOAPMessage;

public class ProcessingContext {
    String messageIdentifier;
    StaticPolicyContext context;
    SecurityPolicy securityPolicy;
    boolean inBoundMessage = false;
    CallbackHandler callbackHandler = null;
    SecurityEnvironment environmentHandler = null;
    protected SecurableSoapMessage secureMessage = null;
    Map properties = new HashMap();
    int configType = MessageConstants.NOT_OPTIMIZED;

    public ProcessingContext() {
    }

    public ProcessingContext(StaticPolicyContext context, SecurityPolicy securityPolicy, SOAPMessage message) throws XWSSecurityException {
        this.generateMessageId();
        this.setPolicyContext(context);
        this.setSecurityPolicy(securityPolicy);
        this.setSOAPMessage(message);
    }

    public void setSecurityPolicy(SecurityPolicy securityPolicy) throws XWSSecurityException {
        this.securityPolicy = securityPolicy;
    }

    public SecurityPolicy getSecurityPolicy() {
        return this.securityPolicy;
    }

    public void setPolicyContext(StaticPolicyContext context) {
        this.context = context;
    }

    public StaticPolicyContext getPolicyContext() {
        return this.context;
    }

    public void setSOAPMessage(SOAPMessage message) throws XWSSecurityException {
        this.secureMessage = new SecurableSoapMessage();
        this.secureMessage.setSOAPMessage(message);
        this.setOptimized();
    }

    public SOAPMessage getSOAPMessage() {
        return this.secureMessage.getSOAPMessage();
    }

    public void setHandler(CallbackHandler handler) {
        this.callbackHandler = handler;
        this.environmentHandler = new DefaultSecurityEnvironmentImpl(handler);
    }

    public void setSecurityEnvironment(SecurityEnvironment handler) {
        this.environmentHandler = handler;
    }

    public CallbackHandler getHandler() {
        return this.callbackHandler;
    }

    public SecurityEnvironment getSecurityEnvironment() {
        return this.environmentHandler;
    }

    public Map getExtraneousProperties() {
        return this.properties;
    }

    public void isInboundMessage(boolean inBound) {
        this.inBoundMessage = inBound;
    }

    public boolean isInboundMessage() {
        return this.inBoundMessage;
    }

    public void setMessageIdentifier(String identifier) {
        this.messageIdentifier = identifier;
    }

    public String getMessageIdentifier() {
        return this.messageIdentifier;
    }

    public void setExtraneousProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public Object getExtraneousProperty(String name) {
        return this.properties.get(name);
    }

    public void removeExtraneousProperty(String name) {
        this.properties.remove(name);
    }

    public static void copy(Map p1, Map p2) {
        p1.putAll(p2);
    }

    public void copy(ProcessingContext ctx1, ProcessingContext ctx2) throws XWSSecurityException {
        if (ctx2 == null) {
            return;
        }
        ctx1.setHandler(ctx2.getHandler());
        ctx1.setSecurityEnvironment(ctx2.getSecurityEnvironment());
        ctx1.setMessageIdentifier(ctx2.getMessageIdentifier());
        ctx1.setSecurityPolicy(ctx2.getSecurityPolicy());
        ctx1.isInboundMessage(ctx2.isInboundMessage());
        ctx1.setSecureMessage(ctx2.getSecureMessage());
        this.properties = ctx2.getExtraneousProperties();
        ctx1.setPolicyContext(ctx2.getPolicyContext());
        ctx1.setConfigType(ctx2.getConfigType());
    }

    private void generateMessageId() {
        Random rnd = new Random();
        long longRandom = rnd.nextLong();
        this.messageIdentifier = String.valueOf(longRandom);
    }

    public void reset() {
    }

    public int getConfigType() {
        return this.configType;
    }

    public void setConfigType(int type) {
        this.configType = type;
        this.setOptimized();
    }

    protected SecurableSoapMessage getSecureMessage() {
        return this.secureMessage;
    }

    protected void setSecureMessage(SecurableSoapMessage msg) {
        this.secureMessage = msg;
    }

    private void setOptimized() {
        if (this.secureMessage != null) {
            if (this.configType == MessageConstants.NOT_OPTIMIZED) {
                this.secureMessage.setOptimized(false);
            } else {
                this.secureMessage.setOptimized(true);
            }
        }
    }
}

