/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.core;

import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.ReferenceElement;
import com.sun.xml.wss.core.SecurityHeaderBlock;
import com.sun.xml.wss.core.reference.DirectReference;
import com.sun.xml.wss.core.reference.KeyIdentifier;
import com.sun.xml.wss.core.reference.SamlKeyIdentifier;
import com.sun.xml.wss.core.reference.X509IssuerSerial;
import com.sun.xml.wss.core.reference.X509SubjectKeyIdentifier;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.SecurableSoapMessage;
import com.sun.xml.wss.impl.XMLUtil;
import com.sun.xml.wss.impl.misc.SecurityHeaderBlockImpl;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SecurityTokenReference
extends SecurityHeaderBlockImpl {
    protected static Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");
    private ReferenceElement refElement;
    private Element samlAuthorityBinding;
    private static final String authorityBinding = "AuthorityBinding".intern();

    public SecurityTokenReference() throws XWSSecurityException {
        try {
            this.setSOAPElement(SecurityTokenReference.getSoapFactory().createElement("SecurityTokenReference", "wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd"));
        }
        catch (SOAPException e) {
            log.log(Level.SEVERE, "WSS0377.error.creating.str", e.getMessage());
            throw new XWSSecurityException(e);
        }
    }

    public SecurityTokenReference(Document doc) throws XWSSecurityException {
        try {
            this.setSOAPElement((SOAPElement)doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:SecurityTokenReference"));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0378.error.creating.str", e.getMessage());
            throw new XWSSecurityException(e);
        }
    }

    public SecurityTokenReference(SOAPElement element, boolean isBSP) throws XWSSecurityException {
        super(element);
        if (!element.getLocalName().equals("SecurityTokenReference") || !XMLUtil.inWsseNS(element)) {
            log.log(Level.SEVERE, "WSS0379.error.creating.str", element.getTagName());
            throw new XWSSecurityException("Invalid tokenRef passed");
        }
        this.isBSP(isBSP);
        Iterator eachChild = this.getChildElements();
        Node node = null;
        int refMechanismFound = 0;
        while (eachChild.hasNext()) {
            if (isBSP && refMechanismFound > 1) {
                throw new XWSSecurityException("Violation of BSP R3061:  A SECURITY_TOKEN_REFERENCE MUST have exactly one child element");
            }
            node = (Node)eachChild.next();
            if (node.getNodeType() != 1) continue;
            if (node == null) {
                log.log(Level.SEVERE, "WSS0379.error.creating.str");
                throw new XWSSecurityException("Passed tokenReference does not contain a refElement");
            }
            if (authorityBinding == node.getLocalName() || authorityBinding.equals(node.getLocalName())) {
                try {
                    this.samlAuthorityBinding = (Element)node;
                    continue;
                }
                catch (Exception e) {
                    throw new XWSSecurityException(e);
                }
            }
            this.refElement = this.getReferenceElementfromSoapElement((SOAPElement)node, isBSP);
            ++refMechanismFound;
        }
    }

    public SecurityTokenReference(SOAPElement element) throws XWSSecurityException {
        this(element, false);
    }

    public ReferenceElement getReference() {
        return this.refElement;
    }

    public void setSamlAuthorityBinding(Element binding, Document doc) throws XWSSecurityException {
        if (this.samlAuthorityBinding != null) {
            throw new XWSSecurityException(" SAML AuthorityBinding element is already present");
        }
        try {
            this.addTextNode("\n");
            Element temp = (Element)doc.getOwnerDocument().importNode(binding, true);
            this.addChildElement((SOAPElement)temp);
            this.addTextNode("\n");
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
        this.samlAuthorityBinding = binding;
    }

    public Element getSamlAuthorityBinding() {
        return this.samlAuthorityBinding;
    }

    public void setReference(ReferenceElement referenceElement) throws XWSSecurityException {
        if (this.refElement != null) {
            log.log(Level.SEVERE, "WSS0380.error.setting.reference");
            throw new XWSSecurityException("Reference element is already present");
        }
        try {
            this.addTextNode("\n");
            this.addChildElement(referenceElement.getAsSoapElement());
            this.addTextNode("\n");
        }
        catch (SOAPException e) {
            log.log(Level.SEVERE, "WSS0381.error.setting.reference");
            throw new XWSSecurityException(e);
        }
        this.refElement = referenceElement;
    }

    public void setWsuId(String wsuId) {
        this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        this.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", wsuId);
    }

    public static SecurityHeaderBlock fromSoapElement(SOAPElement element) throws XWSSecurityException {
        return SecurityHeaderBlockImpl.fromSoapElement(element, SecurityTokenReference.class);
    }

    private ReferenceElement getReferenceElementfromSoapElement(SOAPElement element, boolean isBSP) throws XWSSecurityException {
        String name = element.getLocalName();
        if (name.equals("KeyIdentifier")) {
            return this.getKeyIdentifier(element, isBSP);
        }
        if (name.equals("Reference")) {
            return new DirectReference(element, isBSP);
        }
        if (name.equals("X509Data")) {
            return new X509IssuerSerial(element);
        }
        if (isBSP && name.equals("KeyName")) {
            throw new XWSSecurityException("Violation of BSP R3027: A SECURITY_TOKEN_REFERENCE MUST NOT use a Key Name to reference a SECURITY_TOKEN. KeyName is not supported");
        }
        log.log(Level.SEVERE, "WSS0335.unsupported.referencetype");
        XWSSecurityException xwsse = new XWSSecurityException(element.getTagName() + " key reference type is not supported");
        throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_UNSUPPORTED_SECURITY_TOKEN, xwsse.getMessage(), xwsse);
    }

    private KeyIdentifier getKeyIdentifier(SOAPElement element, boolean isBSP) throws XWSSecurityException {
        String keyIdValueType = element.getAttribute("ValueType");
        if (isBSP && keyIdValueType.length() < 1) {
            throw new XWSSecurityException("Voilation of BSP R3054 : A wsse:KeyIdentifier element in a SECURITY_TOKEN_REFERENCE MUST specify a ValueType attribute");
        }
        String keyIdEncodingType = element.getAttribute("EncodingType");
        if (isBSP && keyIdEncodingType.length() < 1) {
            throw new XWSSecurityException("Voilation of BSP R3070 : A wsse:KeyIdentifier element in a SECURITY_TOKEN_REFERENCE MUST specify an EncodingType attribute. ");
        }
        if (isBSP && !keyIdEncodingType.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary")) {
            throw new XWSSecurityException("Voilation of BSP R3071 : An EncodingType attribute on a wsse:KeyIdentifier element in a SECURITY_TOKEN_REFERENCE MUST have a value of http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
        }
        if (keyIdValueType.equals("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID")) {
            return new SamlKeyIdentifier(element);
        }
        if (keyIdValueType.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier") || keyIdValueType.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3SubjectKeyIdentifier")) {
            return new X509SubjectKeyIdentifier(element);
        }
        log.log(Level.SEVERE, "WSS0334.unsupported.keyidentifier");
        throw new XWSSecurityException("Unsupported KeyIdentifier Reference Type encountered");
    }
}

