/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.callback;

import com.sun.xml.wss.impl.callback.XWSSCallback;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.security.auth.callback.Callback;

public class SignatureVerificationKeyCallback
extends XWSSCallback
implements Callback {
    private Request request;

    public SignatureVerificationKeyCallback(Request request) {
        this.request = request;
    }

    public Request getRequest() {
        return this.request;
    }

    public static class PublicKeyBasedRequest
    extends X509CertificateRequest {
        PublicKey pubKey = null;

        public PublicKeyBasedRequest(PublicKey pk) {
            this.pubKey = pk;
        }

        public PublicKey getPublicKey() {
            return this.pubKey;
        }
    }

    public static class X509IssuerSerialBasedRequest
    extends X509CertificateRequest {
        private String issuerName;
        private BigInteger serialNumber;

        public X509IssuerSerialBasedRequest(String issuerName, BigInteger serialNumber) {
            this.issuerName = issuerName;
            this.serialNumber = serialNumber;
        }

        public String getIssuerName() {
            return this.issuerName;
        }

        public BigInteger getSerialNumber() {
            return this.serialNumber;
        }
    }

    public static class X509SubjectKeyIdentifierBasedRequest
    extends X509CertificateRequest {
        private byte[] x509SubjectKeyIdentifier;

        public X509SubjectKeyIdentifierBasedRequest(byte[] x509SubjectKeyIdentifier) {
            this.x509SubjectKeyIdentifier = x509SubjectKeyIdentifier;
        }

        public byte[] getSubjectKeyIdentifier() {
            return this.x509SubjectKeyIdentifier;
        }
    }

    public static abstract class X509CertificateRequest
    implements Request {
        X509Certificate certificate;

        public void setX509Certificate(X509Certificate certificate) {
            this.certificate = certificate;
        }

        public X509Certificate getX509Certificate() {
            return this.certificate;
        }
    }

    public static interface Request {
    }
}

