/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.filter;

import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.FilterProcessingContext;
import com.sun.xml.wss.impl.HarnessUtil;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.apachecrypto.DecryptionProcessor;
import com.sun.xml.wss.impl.apachecrypto.EncryptionProcessor;
import com.sun.xml.wss.impl.callback.DynamicPolicyCallback;
import com.sun.xml.wss.impl.configuration.DynamicApplicationContext;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.EncryptionPolicy;
import com.sun.xml.wss.impl.policy.mls.SymmetricKeyBinding;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;

public class EncryptionFilter {
    protected static Logger log = Logger.getLogger("com.sun.xml.wss.logging.impl.filter", "com.sun.xml.wss.logging.impl.filter.LogStrings");

    public static void process(FilterProcessingContext context) throws XWSSecurityException {
        if (!context.isInboundMessage()) {
            EncryptionPolicy policy;
            EncryptionPolicy resolvedPolicy = policy = (EncryptionPolicy)context.getSecurityPolicy();
            if (!context.makeDynamicPolicyCallback()) {
                WSSPolicy keyBinding = (WSSPolicy)policy.getKeyBinding();
                if (PolicyTypeUtil.x509CertificateBinding(keyBinding)) {
                    try {
                        AuthenticationTokenPolicy.X509CertificateBinding binding = (AuthenticationTokenPolicy.X509CertificateBinding)keyBinding.clone();
                        String certIdentifier = binding.getCertificateIdentifier();
                        X509Certificate cert = context.getSecurityEnvironment().getCertificate(context.getExtraneousProperties(), certIdentifier, false);
                        binding.setX509Certificate(cert);
                        context.setX509CertificateBinding(binding);
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, "WSS1413.error.extracting.certificate", e);
                        throw new XWSSecurityException(e);
                    }
                } else if (PolicyTypeUtil.symmetricKeyBinding(keyBinding)) {
                    try {
                        SymmetricKeyBinding binding = (SymmetricKeyBinding)keyBinding.clone();
                        String keyIdentifier = binding.getKeyIdentifier();
                        SecretKey sKey = context.getSecurityEnvironment().getSecretKey(context.getExtraneousProperties(), keyIdentifier, true);
                        binding.setSecretKey(sKey);
                        context.setSymmetricKeyBinding(binding);
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, "WSS1414.error.extracting.symmetrickey", new Object[]{e.getMessage()});
                        throw new XWSSecurityException(e);
                    }
                } else if (PolicyTypeUtil.samlTokenPolicy(keyBinding)) {
                    keyBinding = (WSSPolicy)policy.getKeyBinding();
                    DynamicApplicationContext dynamicContext = new DynamicApplicationContext(context.getPolicyContext());
                    dynamicContext.setMessageIdentifier(context.getMessageIdentifier());
                    dynamicContext.inBoundMessage(false);
                    AuthenticationTokenPolicy.SAMLAssertionBinding binding = (AuthenticationTokenPolicy.SAMLAssertionBinding)keyBinding;
                    binding.isReadOnly(true);
                    AuthenticationTokenPolicy.SAMLAssertionBinding samlBinding = context.getSecurityEnvironment().populateSAMLPolicy(context.getExtraneousProperties(), binding, dynamicContext);
                    if (samlBinding.getAssertion() == null) {
                        log.log(Level.SEVERE, "WSS1415.saml.assertion.notset");
                        throw new XWSSecurityException("SAML Assertion not set by CallbackHandler  for Encryption Processing");
                    }
                    policy.setKeyBinding(samlBinding);
                    resolvedPolicy = policy;
                }
            } else {
                try {
                    policy.isReadOnly(true);
                    DynamicApplicationContext dynamicContext = new DynamicApplicationContext(context.getPolicyContext());
                    dynamicContext.setMessageIdentifier(context.getMessageIdentifier());
                    dynamicContext.inBoundMessage(false);
                    DynamicPolicyCallback dynamicCallback = new DynamicPolicyCallback(policy, dynamicContext);
                    ProcessingContext.copy(dynamicContext.getRuntimeProperties(), context.getExtraneousProperties());
                    HarnessUtil.makeDynamicPolicyCallback(dynamicCallback, context.getSecurityEnvironment().getCallbackHandler());
                    resolvedPolicy = (EncryptionPolicy)dynamicCallback.getSecurityPolicy();
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "WSS1412.error.processing.dynamicpolicy", new Object[]{e.getMessage()});
                    throw new XWSSecurityException(e);
                }
            }
            context.setSecurityPolicy(resolvedPolicy);
            EncryptionProcessor.encrypt(context);
        } else {
            if (context.makeDynamicPolicyCallback()) {
                WSSPolicy policy = (WSSPolicy)context.getSecurityPolicy();
                EncryptionPolicy resolvedPolicy = null;
                try {
                    ((EncryptionPolicy)policy).isReadOnly(true);
                    DynamicApplicationContext dynamicContext = new DynamicApplicationContext(context.getPolicyContext());
                    dynamicContext.setMessageIdentifier(context.getMessageIdentifier());
                    dynamicContext.inBoundMessage(true);
                    DynamicPolicyCallback dynamicCallback = new DynamicPolicyCallback(policy, dynamicContext);
                    ProcessingContext.copy(dynamicContext.getRuntimeProperties(), context.getExtraneousProperties());
                    HarnessUtil.makeDynamicPolicyCallback(dynamicCallback, context.getSecurityEnvironment().getCallbackHandler());
                    resolvedPolicy = (EncryptionPolicy)dynamicCallback.getSecurityPolicy();
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "WSS1420.dynamic.policy.signature", new Object[]{e.getMessage()});
                    throw new XWSSecurityException(e);
                }
                context.setSecurityPolicy(resolvedPolicy);
            }
            DecryptionProcessor.decrypt(context);
        }
    }
}

