/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.security.Key;
import java.security.KeyStore;
import java.util.Enumeration;

public class KeyExport {
    private static String keyStoreAlias;
    private static File keyStoreFile;
    private static char[] keyStorePassword;
    private static char[] keyPassword;
    private static String keyStoreType;
    private static String outForm;
    private static File keyFile;
    private static final String KEY_FILE_OPTION = "-keyfile";
    private static final String OUTPUT_FORMAT_OPTION = "-outform";
    private static final String KEYSTORE_FILE_OPTION = "-keystore";
    private static final String KEYSTORE_PASSWORD_OPTION = "-storepass";
    private static final String KEY_PASSWORD_OPTION = "-keypass";
    private static final String KEYSTORE_TYPE_OPTION = "-storetype";
    private static final String ALIAS_OPTION = "-alias";
    private static final char[] BASE64_CHARS;

    private static void printUsage() {
        System.out.println("Options:\n        -keyfile <key-file>           # location of key file\n      [ -alias <alias> ]              # not required if there's a single\n                                      # key in the keystore      [ -help ]\n      [ -keypass <key-password> ]     # user is prompted if omitted and may\n                                      # hit return to use store-password\n      [ -keystore <keystore-file> ]   # defaults to {user-home}/.keystore\n      [ -outform <output-format> ]    # PEM|DER - defaults to PEM\n      [ -storepass <store-password> ] # user is prompted if omitted\n      [ -storetype <store-type> ]     # defaults to default keystore type\n");
    }

    private static void adoptOptionInfo(String option, String value) {
        if (KEY_FILE_OPTION.equals(option)) {
            keyFile = new File(value);
        } else if (OUTPUT_FORMAT_OPTION.equals(option)) {
            if (!value.equalsIgnoreCase("PEM") && !value.equalsIgnoreCase("DER")) {
                System.out.println("Valid values for '-outform' option are PEM | DER");
                System.exit(0);
            }
            outForm = value;
        } else if (KEYSTORE_FILE_OPTION.equals(option)) {
            keyStoreFile = new File(value);
            if (!keyStoreFile.exists()) {
                System.out.println("Keystore file at location " + value + " does not exist");
                System.exit(0);
            }
        } else if (KEYSTORE_PASSWORD_OPTION.equals(option)) {
            keyStorePassword = value.toCharArray();
        } else if (KEYSTORE_TYPE_OPTION.equals(option)) {
            keyStoreType = value;
        } else if (KEY_PASSWORD_OPTION.equals(option)) {
            keyPassword = value.toCharArray();
        } else if (ALIAS_OPTION.equals(option)) {
            keyStoreAlias = value;
        } else {
            System.out.println("Invalid option: " + option);
            KeyExport.printUsage();
            System.exit(0);
        }
    }

    private static void understand(String[] args) {
        if (args.length % 2 != 0) {
            KeyExport.printUsage();
            System.exit(0);
        }
        for (int i = 0; i < args.length; i += 2) {
            KeyExport.adoptOptionInfo(args[i], args[i + 1]);
        }
    }

    private static char[] base64Encode(byte[] in) {
        char[] out = new char[(in.length + 2) / 3 * 4];
        int accum = -1;
        int outPtr = 0;
        block5: for (int i = 0; i < in.length; ++i) {
            int b = in[i] < 0 ? 256 + in[i] : in[i];
            switch (i % 3) {
                case 0: {
                    out[outPtr++] = BASE64_CHARS[b / 4];
                    accum = b % 4 * 16;
                    continue block5;
                }
                case 1: {
                    out[outPtr++] = BASE64_CHARS[accum + b / 16];
                    accum = b % 16 * 4;
                    continue block5;
                }
                case 2: {
                    out[outPtr++] = BASE64_CHARS[accum + b / 64];
                    out[outPtr++] = BASE64_CHARS[b % 64];
                    accum = -1;
                }
            }
        }
        if (accum >= 0) {
            out[outPtr++] = BASE64_CHARS[accum];
        }
        while (outPtr % 4 != 0) {
            out[outPtr++] = 61;
        }
        return out;
    }

    private static void keyExport() {
        try {
            String defaultLocation;
            if (keyFile == null) {
                System.out.println("Location of key-file is mandatory");
                KeyExport.printUsage();
                System.exit(0);
            }
            if (outForm == null) {
                outForm = "PEM";
            }
            if (keyStoreFile == null && !(keyStoreFile = new File(defaultLocation = System.getProperty("user.home") + File.separator + ".keystore")).exists()) {
                System.out.println("Default keystore ({user-home}/.keystore) does not exist.\nPlease specify the keystore location using '-keystore' option");
                System.exit(0);
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            if (keyStorePassword == null) {
                System.out.print("keystore-password: ");
                keyStorePassword = reader.readLine().toCharArray();
            }
            if (keyStoreType == null) {
                keyStoreType = KeyStore.getDefaultType();
            }
            KeyStore store = KeyStore.getInstance(keyStoreType);
            store.load(new FileInputStream(keyStoreFile), keyStorePassword);
            if (keyStoreAlias == null) {
                int numAliases = 0;
                Enumeration<String> enum1 = store.aliases();
                while (enum1.hasMoreElements()) {
                    keyStoreAlias = enum1.nextElement();
                    if (!store.isKeyEntry(keyStoreAlias) || store.getCertificate(keyStoreAlias) == null) continue;
                    ++numAliases;
                }
                if (numAliases == 0) {
                    System.out.println("There are no private keys in the keystore");
                    System.exit(0);
                }
                if (numAliases > 1) {
                    System.out.println("There are more than one private keys in the keystore!");
                    System.out.println("Please use the -alias option to specify the key alias");
                    System.exit(0);
                }
            }
            if (keyPassword == null) {
                System.out.print("key-password: ");
                keyPassword = reader.readLine().toCharArray();
                if (keyPassword.length == 0) {
                    keyPassword = keyStorePassword;
                }
            }
            Key key = store.getKey(keyStoreAlias, keyPassword);
            FileOutputStream fos = new FileOutputStream(keyFile);
            PrintStream ps = new PrintStream(fos, true);
            if ("DER".equalsIgnoreCase(outForm)) {
                ps.write(key.getEncoded());
            } else {
                ps.println("-----BEGIN PRIVATE KEY-----");
                String s = new String(KeyExport.base64Encode(key.getEncoded()));
                for (int j = 0; j < s.length(); j += 64) {
                    ps.println(s.substring(j, Math.min(j + 64, s.length())));
                }
                ps.println("-----END PRIVATE KEY-----");
            }
            ps.close();
            reader.close();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        KeyExport.understand(args);
        KeyExport.keyExport();
    }

    static {
        BASE64_CHARS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    }
}

