/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import com.sun.org.apache.commons.digester.Digester;
import com.sun.org.apache.commons.logging.Log;
import com.sun.org.apache.commons.logging.LogFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.servlet.ServletException;
import org.apache.catalina.Context;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.startup.DigesterFactory;
import org.apache.catalina.startup.JarPathElement;
import org.apache.catalina.startup.TldRuleSet;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.StringManager;
import org.xml.sax.InputSource;

public final class TldConfig {
    private static HashSet noTldJars;
    private static HashSet systemJars;
    private static Log log;
    private static final String FILE_URL_PREFIX = "file:";
    private static final int FILE_URL_PREFIX_LEN;
    private static HashSet<String> systemTldUris;
    private Context context = null;
    private static final StringManager sm;
    private Digester tldDigester = null;
    private boolean isCurrentTldLocal = false;
    private String currentTldUri;
    private boolean tldValidation = false;
    private boolean tldNamespaceAware = false;
    private boolean rescan = true;
    private static boolean scanParent;
    private ArrayList listeners = new ArrayList();

    public static void setNoTldListeners(String jarNames) {
        if (jarNames != null) {
            noTldJars.clear();
            StringTokenizer tokenizer = new StringTokenizer(jarNames, ",");
            while (tokenizer.hasMoreElements()) {
                noTldJars.add(tokenizer.nextToken());
            }
        }
    }

    public static void setScanParentTldListener(boolean scan) {
        scanParent = scan;
    }

    public static boolean getScanParentTldListener() {
        return scanParent;
    }

    public void setTldValidation(boolean tldValidation) {
        this.tldValidation = tldValidation;
    }

    public boolean getTldValidation() {
        return this.tldValidation;
    }

    public boolean getTldNamespaceAware() {
        return this.tldNamespaceAware;
    }

    public void setTldNamespaceAware(boolean tldNamespaceAware) {
        this.tldNamespaceAware = tldNamespaceAware;
    }

    public boolean isRescan() {
        return this.rescan;
    }

    public void setRescan(boolean rescan) {
        this.rescan = rescan;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public void addApplicationListener(String s) {
        log.debug("Add tld listener " + s);
        if (!this.isCurrentTldLocal || !systemTldUris.contains(this.currentTldUri)) {
            this.listeners.add(s);
        }
    }

    public void setTldUri(String uri) {
        this.currentTldUri = uri;
    }

    public String[] getTldListeners() {
        String[] result = new String[this.listeners.size()];
        this.listeners.toArray(result);
        return result;
    }

    public void execute() throws Exception {
        long lastModified;
        long t1 = System.currentTimeMillis();
        File tldCache = null;
        if (this.context instanceof StandardContext) {
            File workDir = (File)((StandardContext)this.context).getServletContext().getAttribute("javax.servlet.context.tempdir");
            tldCache = new File(workDir, "tldCache.ser");
        }
        if (!this.rescan && tldCache != null && tldCache.exists()) {
            this.processCache(tldCache);
            return;
        }
        Set resourcePaths = this.tldScanResourcePaths();
        Map jarPaths = this.getJarPaths();
        if (tldCache != null && tldCache.exists() && (lastModified = this.getLastModified(resourcePaths, jarPaths)) < tldCache.lastModified()) {
            this.processCache(tldCache);
            return;
        }
        for (String path : resourcePaths) {
            if (path.endsWith(".jar")) {
                this.tldScanJar(path);
                continue;
            }
            this.tldScanTld(path);
        }
        if (jarPaths != null) {
            for (JarPathElement elem : jarPaths.values()) {
                this.tldScanJar(elem.getJarFile(), elem.getIsLocal());
            }
        }
        String[] list = this.getTldListeners();
        if (tldCache != null) {
            log.debug("Saving tld cache: " + tldCache + " " + list.length);
            try {
                FileOutputStream out = new FileOutputStream(tldCache);
                ObjectOutputStream oos = new ObjectOutputStream(out);
                oos.writeObject(list);
                oos.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Adding tld listeners:" + list.length);
        }
        for (int i = 0; list != null && i < list.length; ++i) {
            this.context.addApplicationListener(list[i]);
        }
        long t2 = System.currentTimeMillis();
        if (this.context instanceof StandardContext) {
            ((StandardContext)this.context).setTldScanTime(t2 - t1);
        }
    }

    private long getLastModified(Set resourcePaths, Map jarPaths) throws Exception {
        long lastModified = 0L;
        for (String path : resourcePaths) {
            URL url = this.context.getServletContext().getResource(path);
            if (url == null) {
                log.debug("Null url " + path);
                break;
            }
            long lastM = url.openConnection().getLastModified();
            if (lastM > lastModified) {
                lastModified = lastM;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("Last modified " + path + " " + lastM);
        }
        if (jarPaths != null) {
            for (JarPathElement elem : jarPaths.values()) {
                File jarFile = elem.getJarFile();
                long lastM = jarFile.lastModified();
                if (lastM > lastModified) {
                    lastModified = lastM;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("Last modified " + jarFile.getAbsolutePath() + " " + lastM);
            }
        }
        return lastModified;
    }

    private void processCache(File tldCache) throws IOException {
        try {
            FileInputStream in = new FileInputStream(tldCache);
            ObjectInputStream ois = new ObjectInputStream(in);
            String[] list = (String[])ois.readObject();
            if (log.isDebugEnabled()) {
                log.debug("Reusing tldCache " + tldCache + " " + list.length);
            }
            for (int i = 0; list != null && i < list.length; ++i) {
                this.context.addApplicationListener(list[i]);
            }
            ois.close();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
    }

    private Digester createTldDigester() {
        return DigesterFactory.newDigester(false, this.tldNamespaceAware, new TldRuleSet());
    }

    private void tldScanJar(String resourcePath) throws Exception {
        URL url;
        if (log.isDebugEnabled()) {
            log.debug(" Scanning JAR at resource path '" + resourcePath + "'");
        }
        if ((url = this.context.getServletContext().getResource(resourcePath)) == null) {
            throw new IllegalArgumentException(sm.getString("contextConfig.tldResourcePath", resourcePath));
        }
        File file = new File(url.getFile());
        file = file.getCanonicalFile();
        this.tldScanJar(file);
    }

    private void tldScanJar(File file) throws Exception {
        this.tldScanJar(file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tldScanJar(File file, boolean isLocal) throws Exception {
        JarFile jarFile = null;
        String name = null;
        String jarPath = file.getAbsolutePath();
        try {
            jarFile = new JarFile(file);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                name = entry.getName();
                if (!name.startsWith("META-INF/") || !name.endsWith(".tld")) continue;
                if (log.isTraceEnabled()) {
                    log.trace("  Processing TLD at '" + name + "'");
                }
                try {
                    this.tldScanStream(new InputSource(jarFile.getInputStream(entry)), isLocal);
                }
                catch (Exception e) {
                    log.error(sm.getString("contextConfig.tldEntryException", (Object)name, (Object)jarPath, this.context.getPath()), e);
                }
            }
        }
        catch (Exception e) {
            log.error(sm.getString("contextConfig.tldJarException", (Object)jarPath, this.context.getPath()), e);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    private void tldScanStream(InputSource resourceStream) throws Exception {
        this.tldScanStream(resourceStream, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tldScanStream(InputSource resourceStream, boolean isLocal) throws Exception {
        if (this.tldDigester == null) {
            this.tldDigester = this.createTldDigester();
        }
        Digester digester = this.tldDigester;
        synchronized (digester) {
            try {
                this.tldDigester.push(this);
                this.isCurrentTldLocal = isLocal;
                this.tldDigester.parse(resourceStream);
            }
            finally {
                this.isCurrentTldLocal = false;
                this.currentTldUri = null;
                this.tldDigester.push(null);
                this.tldDigester.clear();
            }
        }
    }

    private void tldScanTld(String resourcePath) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(" Scanning TLD at resource path '" + resourcePath + "'");
        }
        InputSource inputSource = null;
        try {
            inputSource = new InputSource(this.context.getServletContext().getResourceAsStream(resourcePath));
            if (inputSource == null) {
                throw new IllegalArgumentException(sm.getString("contextConfig.tldResourcePath", resourcePath));
            }
            this.tldScanStream(inputSource);
        }
        catch (Exception e) {
            throw new ServletException(sm.getString("contextConfig.tldFileException", (Object)resourcePath, this.context.getPath()), (Throwable)e);
        }
    }

    private Set tldScanResourcePaths() throws IOException {
        if (log.isTraceEnabled()) {
            log.trace(" Accumulating TLD resource paths");
        }
        HashSet<String> resourcePaths = new HashSet<String>();
        if (log.isTraceEnabled()) {
            log.trace("  Scanning <taglib> elements in web.xml");
        }
        String[] taglibs = this.context.findTaglibs();
        for (int i = 0; i < taglibs.length; ++i) {
            String resourcePath = this.context.findTaglib(taglibs[i]);
            if (!resourcePath.startsWith("/")) {
                resourcePath = "/WEB-INF/" + resourcePath;
            }
            if (log.isTraceEnabled()) {
                log.trace("   Adding path '" + resourcePath + "' for URI '" + taglibs[i] + "'");
            }
            resourcePaths.add(resourcePath);
        }
        DirContext resources = this.context.getResources();
        if (resources != null) {
            this.tldScanResourcePathsWebInf(resources, "/WEB-INF", resourcePaths);
        }
        return resourcePaths;
    }

    private void tldScanResourcePathsWebInf(DirContext resources, String rootPath, Set tldPaths) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace("  Scanning TLDs in " + rootPath + " subdirectory");
        }
        try {
            NamingEnumeration<NameClassPair> items = resources.list(rootPath);
            while (items.hasMoreElements()) {
                NameClassPair item = (NameClassPair)items.nextElement();
                String resourcePath = rootPath + "/" + item.getName();
                if (!resourcePath.endsWith(".tld") && (resourcePath.startsWith("/WEB-INF/classes") || resourcePath.startsWith("/WEB-INF/lib"))) continue;
                if (resourcePath.endsWith(".tld")) {
                    if (log.isTraceEnabled()) {
                        log.trace("   Adding path '" + resourcePath + "'");
                    }
                    tldPaths.add(resourcePath);
                    continue;
                }
                this.tldScanResourcePathsWebInf(resources, resourcePath, tldPaths);
            }
        }
        catch (NamingException e) {
            // empty catch block
        }
    }

    private Map getJarPaths() {
        ClassLoader webappLoader;
        HashMap<String, JarPathElement> jarPathMap = null;
        ClassLoader loader = webappLoader = Thread.currentThread().getContextClassLoader();
        while (loader != null) {
            if (loader instanceof URLClassLoader) {
                URL[] urls = ((URLClassLoader)loader).getURLs();
                for (int i = 0; i < urls.length; ++i) {
                    String path;
                    File file = new File(RequestUtil.URLDecode(urls[i].getFile()));
                    try {
                        file = file.getCanonicalFile();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    if (!file.exists() || !(path = file.getAbsolutePath()).endsWith(".jar") || loader == webappLoader && systemJars.contains(file.getName()) || loader != webappLoader && noTldJars != null && noTldJars.contains(file.getName())) continue;
                    JarPathElement elem = new JarPathElement(file, loader == webappLoader);
                    if (jarPathMap == null) {
                        jarPathMap = new HashMap<String, JarPathElement>();
                        jarPathMap.put(path, elem);
                        continue;
                    }
                    if (jarPathMap.containsKey(path)) continue;
                    jarPathMap.put(path, elem);
                }
            }
            if (scanParent || this.context.isJsfApplication()) {
                loader = loader.getParent();
                continue;
            }
            loader = null;
        }
        return jarPathMap;
    }

    static {
        log = LogFactory.getLog(TldConfig.class);
        FILE_URL_PREFIX_LEN = FILE_URL_PREFIX.length();
        systemTldUris = new HashSet();
        systemTldUris.add("http://java.sun.com/jsf/core");
        systemTldUris.add("http://java.sun.com/jsf/html");
        systemTldUris.add("http://java.sun.com/jsp/jstl/core");
        noTldJars = new HashSet();
        noTldJars.add("ant.jar");
        noTldJars.add("catalina.jar");
        noTldJars.add("catalina-ant.jar");
        noTldJars.add("catalina-cluster.jar");
        noTldJars.add("catalina-optional.jar");
        noTldJars.add("catalina-i18n-fr.jar");
        noTldJars.add("catalina-i18n-ja.jar");
        noTldJars.add("catalina-i18n-es.jar");
        noTldJars.add("commons-dbcp.jar");
        noTldJars.add("commons-modeler.jar");
        noTldJars.add("commons-logging-api.jar");
        noTldJars.add("commons-beanutils.jar");
        noTldJars.add("commons-fileupload-1.0.jar");
        noTldJars.add("commons-pool.jar");
        noTldJars.add("commons-digester.jar");
        noTldJars.add("commons-logging.jar");
        noTldJars.add("commons-collections.jar");
        noTldJars.add("commons-el.jar");
        noTldJars.add("jakarta-regexp-1.2.jar");
        noTldJars.add("jasper-compiler.jar");
        noTldJars.add("jasper-runtime.jar");
        noTldJars.add("jmx.jar");
        noTldJars.add("jmx-tools.jar");
        noTldJars.add("jsp-api.jar");
        noTldJars.add("jkshm.jar");
        noTldJars.add("jkconfig.jar");
        noTldJars.add("naming-common.jar");
        noTldJars.add("naming-resources.jar");
        noTldJars.add("naming-factory.jar");
        noTldJars.add("naming-java.jar");
        noTldJars.add("servlet-api.jar");
        noTldJars.add("servlets-default.jar");
        noTldJars.add("servlets-invoker.jar");
        noTldJars.add("servlets-common.jar");
        noTldJars.add("servlets-webdav.jar");
        noTldJars.add("tomcat-util.jar");
        noTldJars.add("tomcat-http11.jar");
        noTldJars.add("tomcat-jni.jar");
        noTldJars.add("tomcat-jk.jar");
        noTldJars.add("tomcat-jk2.jar");
        noTldJars.add("tomcat-coyote.jar");
        noTldJars.add("xercesImpl.jar");
        noTldJars.add("xmlParserAPIs.jar");
        noTldJars.add("sunjce_provider.jar");
        noTldJars.add("ldapsec.jar");
        noTldJars.add("localedata.jar");
        noTldJars.add("dnsns.jar");
        systemJars = new HashSet();
        systemJars.add("standard.jar");
        systemJars.add("appserv-jstl.jar");
        systemJars.add("jsf-impl.jar");
        sm = StringManager.getManager("org.apache.catalina.startup");
        scanParent = false;
    }
}

