/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.tomcat5;

import com.sun.appserv.ProxyHandler;
import com.sun.org.apache.commons.logging.Log;
import com.sun.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.catalina.Context;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.util.StringManager;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Adapter;
import org.apache.coyote.Request;
import org.apache.coyote.Response;
import org.apache.coyote.tomcat5.CoyoteConnector;
import org.apache.coyote.tomcat5.CoyotePrincipal;
import org.apache.coyote.tomcat5.CoyoteRequest;
import org.apache.coyote.tomcat5.CoyoteResponse;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.buf.UEncoder;

public class CoyoteAdapter
implements Adapter {
    private static Log log = LogFactory.getLog(CoyoteAdapter.class);
    public static final int ADAPTER_NOTES = 1;
    private CoyoteConnector connector = null;
    private int debug = 0;
    private UEncoder urlEncoder = new UEncoder();
    protected StringManager sm = StringManager.getManager("org.apache.coyote.tomcat5");

    public CoyoteAdapter(CoyoteConnector connector) {
        this.connector = connector;
        this.debug = connector.getDebug();
        this.urlEncoder.addSafeCharacter('/');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(Request req, Response res) throws Exception {
        CoyoteRequest request = (CoyoteRequest)req.getNote(1);
        CoyoteResponse response = (CoyoteResponse)res.getNote(1);
        if (request == null) {
            request = (CoyoteRequest)this.connector.createRequest();
            request.setCoyoteRequest(req);
            response = (CoyoteResponse)this.connector.createResponse();
            response.setCoyoteResponse(res);
            request.setResponse(response);
            response.setRequest(request);
            req.setNote(1, request);
            res.setNote(1, response);
            req.getParameters().setQueryStringEncoding(this.connector.getURIEncoding());
        }
        if (!this.connector.isEnabled()) {
            String msg = this.sm.getString("coyoteAdapter.listenerOff", String.valueOf(this.connector.getPort()));
            if (log.isDebugEnabled()) {
                log.debug(msg);
            }
            response.sendError(404, msg);
            return;
        }
        if (this.connector.isXpoweredBy()) {
            response.addHeader("X-Powered-By", "Servlet/2.5");
        }
        try {
            if (this.postParseRequest(req, request, res, response)) {
                boolean authPassthroughEnabled = this.connector.getAuthPassthroughEnabled();
                ProxyHandler proxyHandler = this.connector.getProxyHandler();
                if (authPassthroughEnabled && proxyHandler != null) {
                    if (proxyHandler.getSSLKeysize(request.getRequest()) > 0) {
                        request.setSecure(true);
                    }
                    X509Certificate[] certs = null;
                    try {
                        certs = proxyHandler.getSSLClientCertificateChain(request.getRequest());
                    }
                    catch (CertificateException ce) {
                        log.error(this.sm.getString("coyoteAdapter.proxyAuthCertError"), ce);
                    }
                    if (certs != null) {
                        request.setAttribute("javax.servlet.request.X509Certificate", certs);
                    }
                }
                this.connector.getContainer().invoke(request, response);
            }
            response.finishResponse();
            req.action(ActionCode.ACTION_POST_REQUEST, null);
        }
        catch (IOException e) {
        }
        catch (Throwable t) {
            log.error(this.sm.getString("coyoteAdapter.service"), t);
        }
        finally {
            request.recycle();
            response.recycle();
        }
    }

    protected boolean postParseRequest(Request req, CoyoteRequest request, Response res, CoyoteResponse response) throws Exception {
        String authtype;
        if (!req.scheme().isNull()) {
            request.setSecure(req.scheme().equals("https"));
        } else {
            req.scheme().setString(this.connector.getScheme());
            request.setSecure(this.connector.getSecure());
        }
        String proxyName = this.connector.getProxyName();
        int proxyPort = this.connector.getProxyPort();
        if (proxyPort != 0) {
            req.setServerPort(proxyPort);
        }
        if (proxyName != null) {
            req.serverName().setString(proxyName);
        }
        MessageBytes decodedURI = req.decodedURI();
        decodedURI.duplicate(req.requestURI());
        try {
            req.getURLDecoder().convert(decodedURI, false);
        }
        catch (IOException ioe) {
            res.setStatus(400);
            res.setMessage("Invalid URI");
            throw ioe;
        }
        if (!CoyoteAdapter.normalize(req.decodedURI())) {
            res.setStatus(400);
            res.setMessage("Invalid URI");
            return false;
        }
        String principal = req.getRemoteUser().toString();
        if (principal != null) {
            request.setUserPrincipal(new CoyotePrincipal(principal));
        }
        if ((authtype = req.getAuthType().toString()) != null) {
            request.setAuthType(authtype);
        }
        request.convertURI(decodedURI);
        request.parseSessionId();
        CharChunk uriCC = decodedURI.getCharChunk();
        int semicolon = uriCC.indexOf(';');
        if (semicolon > 0) {
            decodedURI.setChars(uriCC.getBuffer(), uriCC.getStart(), semicolon);
        }
        this.connector.getMapper().map(req.serverName(), decodedURI, request.getMappingData());
        Context ctx = (Context)request.getMappingData().context;
        request.setContext(ctx);
        request.setWrapper((Wrapper)request.getMappingData().wrapper);
        if (!this.connector.getAllowTrace() && req.method().equalsIgnoreCase("TRACE")) {
            String[] methods;
            Wrapper wrapper = request.getWrapper();
            String header = null;
            if (wrapper != null && (methods = wrapper.getServletMethods()) != null) {
                for (int i = 0; i < methods.length; ++i) {
                    if ("TRACE".equals(methods[i])) continue;
                    header = header == null ? methods[i] : header + ", " + methods[i];
                }
            }
            res.setStatus(405);
            res.addHeader("Allow", header);
            res.setMessage("TRACE method is not allowed");
            return false;
        }
        MessageBytes redirectPathMB = request.getMappingData().redirectPath;
        if (!(redirectPathMB.isNull() || ctx.hasAdHocPaths() && ctx.getAdHocServletName(request.getRequest().getServletPath()) != null)) {
            String redirectPath = redirectPathMB.toString();
            String query = request.getQueryString();
            if (request.isRequestedSessionIdFromURL()) {
                redirectPath = redirectPath + ";jsessionid=" + request.getRequestedSessionId();
            }
            if (query != null) {
                redirectPath = redirectPath + "?" + query;
            }
            redirectPath = this.urlEncoder.encodeURL(redirectPath);
            response.sendRedirect(redirectPath);
            return false;
        }
        request.parseSessionCookiesId();
        request.parseJrouteCookie();
        return true;
    }

    public static boolean normalize(MessageBytes uriMB) {
        ByteChunk uriBC = uriMB.getByteChunk();
        byte[] b = uriBC.getBytes();
        int start = uriBC.getStart();
        int end = uriBC.getEnd();
        if (end - start == 1 && b[start] == 42) {
            return true;
        }
        int pos = 0;
        int index = 0;
        for (pos = start; pos < end; ++pos) {
            if (b[pos] == 92) {
                b[pos] = 47;
            }
            if (b[pos] != 0) continue;
            return false;
        }
        if (b[start] != 47) {
            return false;
        }
        for (pos = start; pos < end - 1; ++pos) {
            if (b[pos] != 47) continue;
            while (pos + 1 < end && b[pos + 1] == 47) {
                CoyoteAdapter.copyBytes(b, pos, pos + 1, end - pos - 1);
                --end;
            }
        }
        if (end - start > 2 && b[end - 1] == 46 && (b[end - 2] == 47 || b[end - 2] == 46 && b[end - 3] == 47)) {
            b[end] = 47;
            ++end;
        }
        uriBC.setEnd(end);
        index = 0;
        while ((index = uriBC.indexOf("/./", 0, 3, index)) >= 0) {
            CoyoteAdapter.copyBytes(b, start + index, start + index + 2, end - start - index - 2);
            uriBC.setEnd(end -= 2);
        }
        index = 0;
        while ((index = uriBC.indexOf("/../", 0, 4, index)) >= 0) {
            if (index == 0) {
                return false;
            }
            int index2 = -1;
            for (pos = start + index - 1; pos >= 0 && index2 < 0; --pos) {
                if (b[pos] != 47) continue;
                index2 = pos;
            }
            CoyoteAdapter.copyBytes(b, start + index2, start + index + 3, end - start - index - 3);
            end = end + index2 - index - 3;
            uriBC.setEnd(end);
            index = index2;
        }
        uriBC.setBytes(b, start, end);
        return true;
    }

    protected static void copyBytes(byte[] b, int dest, int src, int len) {
        for (int pos = 0; pos < len; ++pos) {
            b[pos + dest] = b[pos + src];
        }
    }

    protected void log(String message) {
        log.info(message);
    }

    protected void log(String message, Throwable throwable) {
        log.error(message, throwable);
    }

    public void fireAdapterEvent(String type, Object data) {
        if (this.connector != null && this.connector.getContainer() != null) {
            try {
                ((ContainerBase)this.connector.getContainer()).fireContainerEvent(type, data);
            }
            catch (Throwable t) {
                log.error(this.sm.getString("coyoteAdapter.service"), t);
            }
        }
    }
}

