/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.security.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import org.jcp.xml.dsig.internal.dom.DOMKeyName;
import org.jcp.xml.dsig.internal.dom.DOMKeyValue;
import org.jcp.xml.dsig.internal.dom.DOMRetrievalMethod;
import org.jcp.xml.dsig.internal.dom.DOMStructure;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.jcp.xml.dsig.internal.dom.DOMX509Data;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DOMKeyInfo
extends DOMStructure
implements KeyInfo {
    private final String id;
    private final List keyInfoTypes;

    public DOMKeyInfo(List content, String id) {
        if (content == null) {
            throw new NullPointerException("content cannot be null");
        }
        ArrayList typesCopy = new ArrayList(content);
        if (typesCopy.isEmpty()) {
            throw new IllegalArgumentException("content cannot be empty");
        }
        int size = typesCopy.size();
        for (int i = 0; i < size; ++i) {
            if (typesCopy.get(i) instanceof XMLStructure) continue;
            throw new ClassCastException("content[" + i + "] is not a valid KeyInfo type");
        }
        this.keyInfoTypes = Collections.unmodifiableList(typesCopy);
        this.id = id;
    }

    public DOMKeyInfo(Element kiElem, XMLCryptoContext context, Provider provider) throws MarshalException {
        this.id = DOMUtils.getAttributeValue(kiElem, "Id");
        NodeList nl = kiElem.getChildNodes();
        int length = nl.getLength();
        if (length < 1) {
            throw new MarshalException("KeyInfo must contain at least one type");
        }
        ArrayList<XMLStructure> content = new ArrayList<XMLStructure>(length);
        for (int i = 0; i < length; ++i) {
            Node child = nl.item(i);
            if (child.getNodeType() != 1) continue;
            Element childElem = (Element)child;
            String localName = childElem.getLocalName();
            if (localName.equals("X509Data")) {
                content.add(new DOMX509Data(childElem));
                continue;
            }
            if (localName.equals("KeyName")) {
                content.add(new DOMKeyName(childElem));
                continue;
            }
            if (localName.equals("KeyValue")) {
                content.add(new DOMKeyValue(childElem));
                continue;
            }
            if (localName.equals("RetrievalMethod")) {
                content.add(new DOMRetrievalMethod(childElem, context, provider));
                continue;
            }
            content.add(new javax.xml.crypto.dom.DOMStructure(childElem));
        }
        this.keyInfoTypes = Collections.unmodifiableList(content);
    }

    public String getId() {
        return this.id;
    }

    public List getContent() {
        return this.keyInfoTypes;
    }

    public void marshal(XMLStructure parent, XMLCryptoContext context) throws MarshalException {
        if (parent == null) {
            throw new NullPointerException("parent is null");
        }
        Node pNode = ((javax.xml.crypto.dom.DOMStructure)parent).getNode();
        String dsPrefix = DOMUtils.getSignaturePrefix(context);
        Element kiElem = DOMUtils.createElement(DOMUtils.getOwnerDocument(pNode), "KeyInfo", "http://www.w3.org/2000/09/xmldsig#", dsPrefix);
        if (dsPrefix == null) {
            kiElem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2000/09/xmldsig#");
        } else {
            kiElem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + dsPrefix, "http://www.w3.org/2000/09/xmldsig#");
        }
        this.marshal(pNode, kiElem, null, dsPrefix, (DOMCryptoContext)context);
    }

    public void marshal(Node parent, String dsPrefix, DOMCryptoContext context) throws MarshalException {
        this.marshal(parent, null, dsPrefix, context);
    }

    public void marshal(Node parent, Node nextSibling, String dsPrefix, DOMCryptoContext context) throws MarshalException {
        Document ownerDoc = DOMUtils.getOwnerDocument(parent);
        Element kiElem = DOMUtils.createElement(ownerDoc, "KeyInfo", "http://www.w3.org/2000/09/xmldsig#", dsPrefix);
        this.marshal(parent, kiElem, nextSibling, dsPrefix, context);
    }

    private void marshal(Node parent, Element kiElem, Node nextSibling, String dsPrefix, DOMCryptoContext context) throws MarshalException {
        int size = this.keyInfoTypes.size();
        for (int i = 0; i < size; ++i) {
            XMLStructure kiType = (XMLStructure)this.keyInfoTypes.get(i);
            if (kiType instanceof DOMStructure) {
                ((DOMStructure)kiType).marshal(kiElem, dsPrefix, context);
                continue;
            }
            DOMUtils.appendChild(kiElem, ((javax.xml.crypto.dom.DOMStructure)kiType).getNode());
        }
        DOMUtils.setAttributeID(kiElem, "Id", this.id);
        parent.insertBefore(kiElem, nextSibling);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeyInfo)) {
            return false;
        }
        KeyInfo oki = (KeyInfo)o;
        boolean idsEqual = this.id == null ? oki.getId() == null : this.id.equals(oki.getId());
        return ((Object)this.keyInfoTypes).equals(oki.getContent()) && idsEqual;
    }
}

