/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.io;

import com.sun.messaging.jmq.util.DiagDictionaryEntry;
import com.sun.messaging.jmq.util.DiagManager;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ByteBufferPool
implements DiagManager.Data {
    public static boolean DEBUG = false;
    public static final int DEFAULT_CAPACITY = 0x100000;
    public static final int DEFAULT_BLOCKSIZE = 128;
    public static final int DEFAULT_BIGBUFSIZE = 65536;
    public static final float DEFAULT_BIGRATIO = 0.5f;
    protected HashMap table = null;
    protected boolean useDirect = true;
    protected int blockSize = 128;
    protected int poolCapacity = 0x100000;
    protected int bigBufSize = 65536;
    protected float bigRatio = 0.5f;
    protected int bigPoolSize = 0;
    protected int poolSize = 0;
    protected int nBufs = 0;
    protected int directBytesAllocated = 0;
    protected int heapBytesAllocated = 0;
    protected int directBufsAllocated = 0;
    protected int heapBufsAllocated = 0;
    protected int hits = 0;
    protected int misses = 0;
    protected int adds = 0;
    protected int drops = 0;
    protected int heapDrops = 0;
    protected String poolContents = null;
    protected double utilization = 0.0;
    ArrayList diagDictionary = null;

    public ByteBufferPool() {
        this(0x100000, true);
    }

    public ByteBufferPool(int n, boolean bl) {
        this.poolCapacity = n;
        this.useDirect = bl;
        this.table = new HashMap();
        DiagManager.register(this);
    }

    public void setBigBufSize(int n) {
        this.bigBufSize = n;
    }

    public int getBigBufSize() {
        return this.bigBufSize;
    }

    public void setBigRatio(float f) {
        this.bigRatio = f;
    }

    public float getBigRatio() {
        return this.bigRatio;
    }

    public void setCapacity(int n) {
        this.poolCapacity = n;
    }

    public int getCapacity() {
        return this.poolCapacity;
    }

    public void setBlockSize(int n) {
        this.blockSize = n;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public double getUtilization() {
        return (double)this.hits / (double)(this.hits + this.misses);
    }

    public synchronized ByteBuffer get(int n) {
        int n2 = 0;
        ArrayList arrayList = null;
        ByteBuffer byteBuffer = null;
        n2 = n / this.blockSize * this.blockSize;
        if (n % this.blockSize > 0) {
            n2 += this.blockSize;
        }
        if ((arrayList = (ArrayList)this.table.get(new Integer(n2))) == null || arrayList.isEmpty()) {
            ++this.misses;
            if (this.directBytesAllocated >= this.poolCapacity) {
                byteBuffer = ByteBuffer.allocate(n);
                this.heapBytesAllocated += n;
                ++this.heapBufsAllocated;
            } else if (this.useDirect) {
                byteBuffer = ByteBuffer.allocateDirect(n2);
                this.directBytesAllocated += n2;
                ++this.directBufsAllocated;
            } else {
                byteBuffer = ByteBuffer.allocate(n2);
            }
            if (DEBUG) {
                System.out.println(super.toString() + " get(): miss: allocating new buffer. Requested " + n + " bytes, allocating " + n2);
            }
        } else {
            byteBuffer = (ByteBuffer)arrayList.remove(arrayList.size() - 1);
            this.poolSize -= byteBuffer.capacity();
            if (byteBuffer.capacity() >= this.bigBufSize) {
                this.bigPoolSize -= byteBuffer.capacity();
            }
            --this.nBufs;
            ++this.hits;
            if (DEBUG) {
                System.out.println(super.toString() + " get(): hit: Requested " + n + " bytes, returning " + byteBuffer.capacity());
            }
        }
        byteBuffer.limit(n);
        byteBuffer.rewind();
        return byteBuffer;
    }

    public synchronized void put(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return;
        }
        if (this.useDirect && !byteBuffer.isDirect()) {
            if (DEBUG) {
                System.out.println(super.toString() + " put(): drop: buffer is not direct. " + "Dropping " + byteBuffer.capacity() + " bytes onto floor ");
            }
            ++this.drops;
            return;
        }
        ArrayList<ByteBuffer> arrayList = null;
        boolean bl = false;
        if (byteBuffer.capacity() >= this.bigBufSize) {
            bl = true;
        }
        if (bl && (float)this.bigPoolSize > (float)this.poolCapacity * this.bigRatio) {
            ++this.drops;
            if (DEBUG) {
                System.out.println(super.toString() + " put(): drop: big pool capacity of " + (float)this.poolCapacity * this.bigRatio + "exceeded. dropping " + byteBuffer.capacity() + " bytes onto floor ");
            }
        } else if (this.poolSize < this.poolCapacity) {
            Integer n = new Integer(byteBuffer.capacity());
            arrayList = (ArrayList<ByteBuffer>)this.table.get(n);
            if (arrayList == null) {
                arrayList = new ArrayList<ByteBuffer>(64);
                this.table.put(n, arrayList);
            }
            arrayList.add(byteBuffer);
            this.poolSize += byteBuffer.capacity();
            ++this.nBufs;
            ++this.adds;
            if (bl) {
                this.bigPoolSize += byteBuffer.capacity();
            }
            if (DEBUG) {
                System.out.println(super.toString() + "put(): add: putting " + byteBuffer.capacity() + " bytes back into pool");
            }
        } else {
            ++this.drops;
            if (DEBUG) {
                System.out.println(super.toString() + " put(): drop: dropping " + byteBuffer.capacity() + " bytes onto floor ");
            }
        }
    }

    public synchronized void clear() {
        this.table.clear();
        this.poolSize = 0;
        this.bigPoolSize = 0;
        this.nBufs = 0;
    }

    public String toString() {
        return super.toString() + ": capacity=" + this.poolCapacity + ", size=" + this.poolSize + ", nBufs=" + this.nBufs + ", bigBufSize=" + this.bigBufSize + ", bigPoolSize=" + this.bigPoolSize + ", bigRatio=" + this.bigRatio + ", utilization=" + this.getUtilization() + ", directBytes=" + this.directBytesAllocated + ", directBuffers=" + this.directBufsAllocated + ", heapBytes=" + this.heapBytesAllocated + ", heapBuffers=" + this.heapBufsAllocated;
    }

    public String toDiagString() {
        return this.toString() + ", hits=" + this.hits + ", misses=" + this.misses + ", adds=" + this.adds + ", drops=" + this.drops;
    }

    public String poolContents() {
        int n = this.table.size();
        int[] nArray = new int[n];
        StringBuffer stringBuffer = new StringBuffer();
        Set set = this.table.entrySet();
        Iterator iterator = set.iterator();
        boolean bl = false;
        int n2 = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            int n3 = (Integer)entry.getKey();
            ArrayList arrayList = (ArrayList)entry.getValue();
            stringBuffer.append(n3 + ":" + arrayList.size() + " ");
            n2 += n3 * arrayList.size();
        }
        stringBuffer.append(" Total Bytes: " + n2);
        return stringBuffer.toString();
    }

    public void resetDiagCounters() {
        this.hits = 0;
        this.misses = 0;
        this.adds = 0;
        this.drops = 0;
    }

    public synchronized List getDictionary() {
        if (this.diagDictionary == null) {
            this.diagDictionary = new ArrayList();
            this.diagDictionary.add(new DiagDictionaryEntry("poolCapacity", 1));
            this.diagDictionary.add(new DiagDictionaryEntry("poolSize", 1));
            this.diagDictionary.add(new DiagDictionaryEntry("blockSize", 1));
            this.diagDictionary.add(new DiagDictionaryEntry("nBufs", 1));
            this.diagDictionary.add(new DiagDictionaryEntry("bigBufSize", 1));
            this.diagDictionary.add(new DiagDictionaryEntry("bigPoolSize", 1));
            this.diagDictionary.add(new DiagDictionaryEntry("directBytesAllocated", 3));
            this.diagDictionary.add(new DiagDictionaryEntry("directBufsAllocated", 3));
            this.diagDictionary.add(new DiagDictionaryEntry("heapBytesAllocated", 3));
            this.diagDictionary.add(new DiagDictionaryEntry("heapBufsAllocated", 3));
            this.diagDictionary.add(new DiagDictionaryEntry("hits", 3));
            this.diagDictionary.add(new DiagDictionaryEntry("misses", 3));
            this.diagDictionary.add(new DiagDictionaryEntry("adds", 3));
            this.diagDictionary.add(new DiagDictionaryEntry("drops", 3));
            this.diagDictionary.add(new DiagDictionaryEntry("utilization", 1));
            this.diagDictionary.add(new DiagDictionaryEntry("poolContents", 1));
        }
        return this.diagDictionary;
    }

    public void update() {
        this.poolContents = "[" + this.poolContents() + "]";
        this.utilization = this.getUtilization();
    }

    public String getPrefix() {
        return "bbpool";
    }

    public String getTitle() {
        return "ByteBufferPool";
    }
}

