/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.Destination;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.FlowControl;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.TemporaryDestination;
import com.sun.messaging.jms.IllegalStateException;
import java.io.PrintStream;
import java.util.Hashtable;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;

abstract class Consumer {
    protected String messageSelector = null;
    protected ConnectionImpl connection = null;
    protected Long interestId = null;
    protected Integer destType = null;
    protected boolean durable = false;
    protected boolean noLocal = false;
    protected javax.jms.Destination destination = null;
    protected String durableName = null;
    protected boolean debug = Debug.debug;
    private boolean isRegistered = false;
    protected boolean isClosed = false;
    protected int prefetchMaxMsgCount = 100;
    protected int prefetchThresholdPercent = 50;
    protected int acknowledgeMode = -1;

    public Consumer(ConnectionImpl connectionImpl, javax.jms.Destination destination, String string, boolean bl) throws JMSException {
        if (destination == null) {
            String string2 = AdministeredObject.cr.getKString("C4050", "null");
            InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string2, "C4050");
            ExceptionHandler.throwJMSException((JMSException)invalidDestinationException);
        }
        this.messageSelector = string;
        this.connection = connectionImpl;
        this.destination = destination;
        this.noLocal = bl;
        this.checkConsumerCreation();
        this.prefetchMaxMsgCount = connectionImpl.prefetchMaxMsgCount;
        this.prefetchThresholdPercent = connectionImpl.prefetchThresholdPercent;
    }

    public Consumer(ConnectionImpl connectionImpl, javax.jms.Destination destination, String string) throws JMSException {
        this(connectionImpl, destination, string, false);
    }

    public Consumer(ConnectionImpl connectionImpl, javax.jms.Destination destination) throws JMSException {
        this(connectionImpl, destination, null, false);
    }

    protected void registerInterest() throws JMSException {
        this.connection.addInterest(this);
        this.isRegistered = true;
    }

    protected void deregisterInterest() throws JMSException {
        this.connection.removeInterest(this);
        FlowControl flowControl = this.connection.getReadChannel().flowControl;
        flowControl.removeConsumerFlowControl(this);
        this.isRegistered = false;
    }

    protected void checkConsumerCreation() throws JMSException {
        TemporaryDestination.checkTemporaryDestinationConsumerAllowed(this.connection, this.destination);
    }

    protected abstract void onMessage(MessageImpl var1) throws JMSException;

    protected abstract Long getReadQueueId();

    protected Long getInterestId() {
        return this.interestId;
    }

    protected void setInterestId(Long l) {
        this.interestId = l;
    }

    protected Integer getDestType() {
        return this.destType;
    }

    protected void setDestType(Integer n) {
        this.destType = n;
    }

    protected boolean getIsRegistered() {
        return this.isRegistered;
    }

    protected void setDurable(boolean bl) {
        this.durable = bl;
    }

    protected boolean getDurable() {
        return this.durable;
    }

    protected void setNoLocal(boolean bl) {
        this.noLocal = bl;
    }

    protected boolean getNoLocal() throws JMSException {
        return this.noLocal;
    }

    protected void setMessageSelector(String string) throws JMSException {
        this.messageSelector = string;
    }

    protected javax.jms.Destination getDestination() {
        return this.destination;
    }

    protected void setDurableName(String string) {
        this.durableName = string;
    }

    protected String getDurableName() {
        return this.durableName;
    }

    protected ConnectionImpl getConnection() {
        return this.connection;
    }

    public String getMessageSelector() throws JMSException {
        this.checkState();
        return this.messageSelector;
    }

    protected void checkState() throws JMSException {
        if (this.isClosed) {
            String string = AdministeredObject.cr.getKString("C4063");
            IllegalStateException illegalStateException = new IllegalStateException(string, "C4063");
            ExceptionHandler.throwJMSException((JMSException)((Object)illegalStateException));
        }
    }

    public void setPrefetchMaxMsgCount(int n) {
        this.prefetchMaxMsgCount = n;
    }

    public int getPrefetchMaxMsgCount() {
        return this.prefetchMaxMsgCount;
    }

    public void setPrefetchThresholdPercent(int n) {
        this.prefetchThresholdPercent = n;
    }

    public int getPrefetchThresholdPercent() {
        return this.prefetchThresholdPercent;
    }

    protected void dump(PrintStream printStream) {
        printStream.println("Interest ID: " + this.interestId);
        printStream.println("is durable: " + this.durable);
        if (this.durable) {
            printStream.println("durableName: " + this.durableName);
        }
        printStream.println("is registered: " + this.isRegistered);
        printStream.println("destination: " + this.destination);
    }

    protected Hashtable getDebugState(boolean bl) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("consumerID", String.valueOf(this.interestId));
        hashtable.put("noLocal", String.valueOf(this.noLocal));
        hashtable.put("Destination Class", this.destination.getClass().getName());
        if (this.destination instanceof Destination) {
            hashtable.put("Destination", ((Destination)this.destination).getName());
        }
        if (this.messageSelector != null) {
            hashtable.put("selector", String.valueOf(this.messageSelector));
        }
        hashtable.put("durable", String.valueOf(this.durable));
        if (this.durable) {
            hashtable.put("durableName", String.valueOf(this.durableName));
        }
        hashtable.put("isRegistered", String.valueOf(this.isRegistered));
        hashtable.put("isClosed", String.valueOf(this.isClosed));
        hashtable.put("FlowControl", this.connection.getReadChannel().flowControl.getDebugState(this));
        return hashtable;
    }

    public String toString() {
        return "ConsumerID: " + this.interestId + ", ConnectionID=" + this.connection.getConnectionID();
    }
}

