/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.selector.Selector;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FaultInjection {
    static FaultInjection fault = null;
    Logger logger = Globals.getLogger();
    Set injections = Collections.synchronizedSet(new HashSet());
    Map injectionSelectors = Collections.synchronizedMap(new HashMap());
    Map injectionProps = Collections.synchronizedMap(new HashMap());
    public static boolean FAULT_INJECTION = false;
    public static String STAGE_1 = "1";
    public static String STAGE_2 = "2";
    public static String STAGE_3 = "3";
    public static String FAULT_TXN_START_1 = "txn.start.1";
    public static String FAULT_TXN_END_1 = "txn.end.1";
    public static String FAULT_TXN_PREPARE_1 = "txn.prepare.1";
    public static String FAULT_TXN_COMMIT_1 = "txn.commit.1";
    public static String FAULT_TXN_ROLLBACK_1 = "txn.rollback.1";
    public static String FAULT_TXN_START_2 = "txn.start.2";
    public static String FAULT_TXN_END_2 = "txn.end.2";
    public static String FAULT_TXN_PREPARE_2 = "txn.prepare.2";
    public static String FAULT_TXN_COMMIT_2 = "txn.commit.2";
    public static String FAULT_TXN_ROLLBACK_2 = "txn.rollback.2";
    public static String FAULT_TXN_START_3 = "txn.start.3";
    public static String FAULT_TXN_END_3 = "txn.end.3";
    public static String FAULT_TXN_PREPARE_3 = "txn.prepare.3";
    public static String FAULT_TXN_COMMIT_3 = "txn.commit.3";
    public static String FAULT_TXN_ROLLBACK_3 = "txn.rollback.3";
    public static String FAULT_TXN_COMMIT_4 = "txn.commit.4";
    public static String FAULT_TXN_ROLLBACK_4 = "txn.rollback.4";
    public static String MSG_ACKCOUNT_PROP = "mqAckCount";
    public static String FAULT_ACK_MSG_1 = "msg.ack.1";
    public static String FAULT_ACK_MSG_2 = "msg.ack.2";
    public static String FAULT_ACK_MSG_3 = "msg.ack.3";
    public static String FAULT_SEND_MSG_1 = "msg.send.1";
    public static String FAULT_SEND_MSG_2 = "msg.send.2";
    public static String FAULT_SEND_MSG_3 = "msg.send.3";
    public static String MSG_REMOTE_ACK_TXNACK = "txnack.";
    public static String MSG_REMOTE_ACK_TXNPREPARE = "txnprepare.";
    public static String MSG_REMOTE_ACK_TXNROLLBACK = "txnrollback.";
    public static String MSG_REMOTE_ACK_TXNCOMMIT = "txncommit.";
    public static String MSG_REMOTE_ACK_P = "msg.remote_ack.p.";
    public static String MSG_REMOTE_ACK_HOME_P = "msg.remote_ack.home.p.";
    public static String FAULT_MSG_REMOTE_ACK_P_TXNACK_1 = MSG_REMOTE_ACK_P + MSG_REMOTE_ACK_TXNACK + "1";
    public static String FAULT_MSG_REMOTE_ACK_P_TXNACK_2 = MSG_REMOTE_ACK_P + MSG_REMOTE_ACK_TXNACK + "2";
    public static String FAULT_MSG_REMOTE_ACK_P_TXNACK_3 = MSG_REMOTE_ACK_P + MSG_REMOTE_ACK_TXNACK + "3";
    public static String FAULT_MSG_REMOTE_ACK_HOME_P_TXNACK_1 = MSG_REMOTE_ACK_HOME_P + MSG_REMOTE_ACK_TXNACK + "1";
    public static String FAULT_MSG_REMOTE_ACK_HOME_P_TXNACK_2 = MSG_REMOTE_ACK_HOME_P + MSG_REMOTE_ACK_TXNACK + "2";
    public static String FAULT_MSG_REMOTE_ACK_HOME_P_TXNACK_3 = MSG_REMOTE_ACK_HOME_P + MSG_REMOTE_ACK_TXNACK + "3";
    public static String FAULT_MSG_REMOTE_ACK_P_TXNPREPARE_1 = MSG_REMOTE_ACK_P + MSG_REMOTE_ACK_TXNPREPARE + "1";
    public static String FAULT_MSG_REMOTE_ACK_P_TXNPREPARE_2 = MSG_REMOTE_ACK_P + MSG_REMOTE_ACK_TXNPREPARE + "2";
    public static String FAULT_MSG_REMOTE_ACK_P_TXNPREPARE_3 = MSG_REMOTE_ACK_P + MSG_REMOTE_ACK_TXNPREPARE + "3";
    public static String FAULT_MSG_REMOTE_ACK_HOME_P_TXNPREPARE_1 = MSG_REMOTE_ACK_HOME_P + MSG_REMOTE_ACK_TXNPREPARE + "1";
    public static String FAULT_MSG_REMOTE_ACK_HOME_P_TXNPREPARE_2 = MSG_REMOTE_ACK_HOME_P + MSG_REMOTE_ACK_TXNPREPARE + "2";
    public static String FAULT_MSG_REMOTE_ACK_HOME_P_TXNPREPARE_3 = MSG_REMOTE_ACK_HOME_P + MSG_REMOTE_ACK_TXNPREPARE + "3";
    public static String FAULT_MSG_REMOTE_ACK_P_TXNROLLBACK_1 = MSG_REMOTE_ACK_P + MSG_REMOTE_ACK_TXNROLLBACK + "1";
    public static String FAULT_MSG_REMOTE_ACK_P_TXNROLLBACK_2 = MSG_REMOTE_ACK_P + MSG_REMOTE_ACK_TXNROLLBACK + "2";
    public static String FAULT_MSG_REMOTE_ACK_P_TXNROLLBACK_3 = MSG_REMOTE_ACK_P + MSG_REMOTE_ACK_TXNROLLBACK + "3";
    public static String FAULT_MSG_REMOTE_ACK_HOME_P_TXNROLLBACK_1 = MSG_REMOTE_ACK_HOME_P + MSG_REMOTE_ACK_TXNROLLBACK + "1";
    public static String FAULT_MSG_REMOTE_ACK_HOME_P_TXNROLLBACK_2 = MSG_REMOTE_ACK_HOME_P + MSG_REMOTE_ACK_TXNROLLBACK + "2";
    public static String FAULT_MSG_REMOTE_ACK_HOME_P_TXNROLLBACK_3 = MSG_REMOTE_ACK_HOME_P + MSG_REMOTE_ACK_TXNROLLBACK + "3";
    public static String FAULT_MSG_REMOTE_ACK_P_TXNCOMMIT_P_1 = MSG_REMOTE_ACK_P + MSG_REMOTE_ACK_TXNCOMMIT + "1";
    public static String FAULT_MSG_REMOTE_ACK_P_TXNCOMMIT_P_2 = MSG_REMOTE_ACK_P + MSG_REMOTE_ACK_TXNCOMMIT + "2";
    public static String FAULT_MSG_REMOTE_ACK_P_TXNCOMMIT_P_3 = MSG_REMOTE_ACK_P + MSG_REMOTE_ACK_TXNCOMMIT + "3";
    public static String FAULT_MSG_REMOTE_ACK_HOME_P_TXNCOMMIT_1 = MSG_REMOTE_ACK_HOME_P + MSG_REMOTE_ACK_TXNCOMMIT + "1";
    public static String FAULT_MSG_REMOTE_ACK_HOME_P_TXNCOMMIT_2 = MSG_REMOTE_ACK_HOME_P + MSG_REMOTE_ACK_TXNCOMMIT + "2";
    public static String FAULT_MSG_REMOTE_ACK_HOME_P_TXNCOMMIT_3 = MSG_REMOTE_ACK_HOME_P + MSG_REMOTE_ACK_TXNCOMMIT + "3";
    public static String FAULT_MSG_REMOTE_ACK_P_1 = MSG_REMOTE_ACK_P + "1";
    public static String FAULT_MSG_REMOTE_ACK_P_2 = MSG_REMOTE_ACK_P + "2";
    public static String FAULT_MSG_REMOTE_ACK_P_3 = MSG_REMOTE_ACK_P + "3";
    public static String FAULT_MSG_REMOTE_ACK_HOME_P_1 = MSG_REMOTE_ACK_HOME_P + "1";
    public static String FAULT_MSG_REMOTE_ACK_HOME_P_2 = MSG_REMOTE_ACK_HOME_P + "2";
    public static String FAULT_MSG_REMOTE_ACK_HOME_P_3 = MSG_REMOTE_ACK_HOME_P + "3";

    public static FaultInjection getInjection() {
        if (fault == null) {
            fault = new FaultInjection();
        }
        return fault;
    }

    public void setFault(String string, String string2) throws SelectorFormatException {
        this.setFault(string, string2, null);
    }

    public void setFault(String string, String string2, Map map) throws SelectorFormatException {
        this.logger.log(8, "Setting Fault " + string + "[ selector=" + string2 + "]");
        this.injections.add(string);
        if (string2 != null && string2.length() != 0) {
            Selector selector = Selector.compile(string2);
            this.injectionSelectors.put(string, selector);
        }
        if (map != null) {
            this.injectionProps.put(string, map);
        }
    }

    public void unsetFault(String string) {
        this.logger.log(8, "Removing Fault " + string);
        this.injections.remove(string);
        this.injectionSelectors.remove(string);
        this.injectionProps.remove(string);
    }

    public void setFaultInjection(boolean bl) {
        if (FAULT_INJECTION != bl) {
            if (bl) {
                this.logger.log(8, "Turning on Fault Injection");
            } else {
                this.logger.log(8, "Turning off Fault Injection");
            }
            FAULT_INJECTION = bl;
        }
    }

    public void logInjection(String string, Selector selector) {
        String string2 = "Fault Injection: triggered " + string;
        if (selector != null) {
            string2 = string2 + " selector [ " + selector.toString() + "]";
        }
        FaultInjectionException faultInjectionException = new FaultInjectionException();
        faultInjectionException.fillInStackTrace();
        this.logger.logStack(8, string2, faultInjectionException);
    }

    public Map checkFaultGetProps(String string, Map map) {
        if (!FAULT_INJECTION) {
            return null;
        }
        boolean bl = this.checkFault(string, map);
        if (!bl) {
            return null;
        }
        HashMap hashMap = (HashMap)this.injectionProps.get(string);
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        return hashMap;
    }

    public boolean checkFault(String string, Map map) {
        if (!FAULT_INJECTION) {
            return false;
        }
        if (this.injections.contains(string)) {
            Selector selector = (Selector)this.injectionSelectors.get(string);
            if (selector == null) {
                this.logInjection(string, null);
                return true;
            }
            try {
                boolean bl = selector.match(map, null);
                if (bl) {
                    this.logInjection(string, selector);
                    return true;
                }
                return false;
            }
            catch (Exception exception) {
                this.logger.logStack(16, "Unable to apply fault ", exception);
                return false;
            }
        }
        return false;
    }

    public void checkFaultAndThrowIOException(String string, Map map) throws IOException {
        if (!FAULT_INJECTION) {
            return;
        }
        if (this.checkFault(string, map)) {
            IOException iOException = new IOException("Fault Insertion: " + string);
        }
    }

    public void checkFaultAndThrowBrokerException(String string, Map map) throws BrokerException {
        if (!FAULT_INJECTION) {
            return;
        }
        if (this.checkFault(string, map)) {
            BrokerException brokerException = new BrokerException("Fault Insertion: " + string);
        }
    }

    public void checkFaultAndThrowException(String string, Map map, String string2) throws Exception {
        if (!FAULT_INJECTION) {
            return;
        }
        if (this.checkFault(string, map)) {
            Exception exception = new Exception("Fault Insertion: " + string);
        }
    }

    public void checkFaultAndThrowError(String string, Map map, String string2) throws Error {
        if (!FAULT_INJECTION) {
            return;
        }
        if (this.checkFault(string, map)) {
            Error error = new Error("Fault Insertion: " + string);
        }
    }

    public void checkFaultAndExit(String string, Map map, int n, boolean bl) {
        if (!FAULT_INJECTION) {
            return;
        }
        if (this.checkFault(string, map)) {
            if (bl) {
                this.logger.log(8, "SHUTING DOWN BROKER BECAUSE OF FAULT " + string);
                System.exit(n);
            } else {
                this.logger.log(8, "HALTING BROKER BECAUSE OF FAULT " + string);
                Runtime.getRuntime().halt(n);
            }
        }
    }

    class FaultInjectionException
    extends Exception {
        FaultInjectionException() {
        }

        public String toString() {
            return "FaultInjectionTrace";
        }
    }
}

