/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.component;

import com.sun.web.ui.component.DropDownBase;
import com.sun.web.ui.el.DropDownMethodBinding;
import com.sun.web.ui.util.RenderingUtilities;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.ActionSource;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.PhaseId;

public class DropDown
extends DropDownBase
implements ActionSource {
    public static final String SUBMIT = "_submitter";
    private boolean fireAction = false;
    private static final boolean DEBUG = false;

    public MethodBinding getAction() {
        if (super.getAction() == null && this.isNavigateToValue()) {
            this.setAction(new DropDownMethodBinding());
        }
        return super.getAction();
    }

    public int getRows() {
        return 1;
    }

    public void setRows(int DisplayRows) {
        super.setRows(1);
    }

    public boolean getMultiple() {
        return false;
    }

    public void setMultiple(boolean multiple) {
        super.setMultiple(false);
    }

    public void addActionListener(ActionListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public ActionListener[] getActionListeners() {
        ActionListener[] listeners = (ActionListener[])this.getFacesListeners(ActionListener.class);
        return listeners;
    }

    public void removeActionListener(ActionListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }

    public void processDecodes(FacesContext context) {
        MethodBinding mb;
        if (!this.isRendered()) {
            return;
        }
        Iterator childComponents = this.getFacetsAndChildren();
        while (childComponents.hasNext()) {
            UIComponent comp = (UIComponent)childComponents.next();
            comp.processDecodes(context);
        }
        try {
            this.decode(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        boolean isSubmitter = this.isSubmitter(context);
        if (isSubmitter) {
            RenderingUtilities.setLastClientID(context, this.getPrimaryElementID(context));
        }
        boolean bl = this.fireAction = isSubmitter && this.isSubmitForm() && this.getSubmittedValue() != null;
        if (this.fireAction && this.isNavigateToValue() && (mb = this.getAction()) instanceof DropDownMethodBinding) {
            String[] stringValues;
            String outcome = null;
            Object values = this.getSubmittedValue();
            if (values instanceof String[] && (stringValues = (String[])values).length > 0) {
                outcome = stringValues[0];
            }
            ((DropDownMethodBinding)mb).setValue(outcome);
        }
        if (this.isImmediate()) {
            try {
                this.validate(context);
            }
            catch (RuntimeException e) {
                context.renderResponse();
                throw e;
            }
            if (!this.isValid()) {
                context.renderResponse();
            }
        }
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        if (this.isSubmitForm() && event instanceof ActionEvent) {
            ActionListener listener;
            FacesContext context = this.getFacesContext();
            MethodBinding mb = this.getActionListener();
            if (mb != null) {
                mb.invoke(context, new Object[]{event});
            }
            if ((listener = context.getApplication().getActionListener()) != null) {
                listener.processAction((ActionEvent)event);
            }
        }
    }

    public void queueEvent(FacesEvent e) {
        if (this.isSubmitForm() && e instanceof ActionEvent) {
            if (this.isImmediate()) {
                e.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else {
                e.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
        }
        super.queueEvent(e);
    }

    private boolean isSubmitter(FacesContext context) {
        String compID = this.getClientId(context).concat(SUBMIT);
        Map requestParameters = context.getExternalContext().getRequestParameterMap();
        String submitter = (String)requestParameters.get(compID);
        return submitter != null ? submitter.equals("true") : false;
    }

    public void validate(FacesContext context) {
        Object submittedValue = this.getSubmittedValue();
        if (submittedValue == null) {
            return;
        }
        super.validate(context);
        if (this.isValid() && this.fireAction) {
            this.queueEvent((FacesEvent)new ActionEvent((UIComponent)this));
        }
    }
}

