/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.component;

import com.sun.web.ui.component.AddListener;
import com.sun.web.ui.component.Button;
import com.sun.web.ui.component.EditableListBase;
import com.sun.web.ui.component.Label;
import com.sun.web.ui.component.ListManager;
import com.sun.web.ui.component.RemoveListener;
import com.sun.web.ui.component.StaticText;
import com.sun.web.ui.component.TextField;
import com.sun.web.ui.model.list.ListItem;
import com.sun.web.ui.theme.Theme;
import com.sun.web.ui.util.ComponentUtilities;
import com.sun.web.ui.util.ConversionUtilities;
import com.sun.web.ui.util.MessageUtil;
import com.sun.web.ui.util.ThemeUtilities;
import com.sun.web.ui.validator.StringLengthValidator;
import java.lang.reflect.Array;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeMap;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.el.MethodBinding;
import javax.faces.event.ActionListener;
import javax.faces.validator.Validator;

public class EditableList
extends EditableListBase
implements ListManager,
NamingContainer {
    public static final String ADD_BUTTON_ID = "_addButton";
    public static final String ADD_BUTTON_FACET = "addButton";
    public static final String ADD_BUTTON_TEXT_KEY = "EditableList.add";
    public static final String REMOVE_BUTTON_ID = "_removeButton";
    public static final String REMOVE_BUTTON_FACET = "removeButton";
    public static final String REMOVE_BUTTON_TEXT_KEY = "EditableList.remove";
    public static final String FIELD_ID = "_field";
    public static final String FIELD_FACET = "field";
    public static final String SLV_TOOLONG_KEY = "EditableList.itemTooLong";
    public static final String SLV_TOOSHORT_KEY = "EditableList.fieldEmpty";
    public static final String LIST_LABEL_ID = "_listLabel";
    public static final String LIST_LABEL_FACET = "listLabel";
    public static final String LIST_LABEL_TEXT_KEY = "EditableList.defaultListLabel";
    public static final String FIELD_LABEL_ID = "_fieldLabel";
    public static final String FIELD_LABEL_FACET = "fieldLabel";
    public static final String FIELD_LABEL_TEXT_KEY = "EditableList.defaultFieldLabel";
    public static final String READ_ONLY_ID = "_readOnly";
    public static final String READ_ONLY_FACET = "readOnly";
    public static final String HEADER_FACET = "header";
    public static final String FOOTER_FACET = "footer";
    public static final String JSOBJECT = "com.sun.web.ui.EditabelListJS";
    public static final String ADD_FUNCTION = ".add(); ";
    public static final String ENABLE_ADD_FUNCTION = ".enableAdd(); ";
    public static final String SET_ADD_DISABLED_FUNCTION = ".setAddDisabled(false);";
    public static final String ENABLE_REMOVE_FUNCTION = ".enableRemove(); ";
    public static final String UPDATE_BUTTONS_FUNCTION = ".updateButtons(); ";
    private static final String READ_ONLY_SEPARATOR = ", ";
    public static final String SEARCH_FACET = "search";
    public static final String SPACER_STRING = "_";
    private static final String KEY_STRING = "a";
    private static final String DUP_STRING = "\t";
    private static final int MIN_LENGTH = 20;
    private static final boolean DEBUG = false;
    private TreeMap listItems = null;
    private Collator collator = null;
    private transient Theme theme = null;
    private String selectedValue = null;
    private String[] valuesToRemove = null;

    public int getMaxlLength() {
        int length = super.getMaxLength();
        if (length < 1) {
            length = 25;
        }
        return length;
    }

    public UIComponent getAddButtonComponent() {
        return this.getButtonFacet(ADD_BUTTON_FACET, true, this.getTheme().getMessage(ADD_BUTTON_TEXT_KEY), new AddListener());
    }

    public UIComponent getRemoveButtonComponent() {
        return this.getButtonFacet(REMOVE_BUTTON_FACET, false, this.getTheme().getMessage(REMOVE_BUTTON_TEXT_KEY), new RemoveListener());
    }

    private UIComponent getButtonFacet(String facetName, boolean primary, String text, ActionListener actionListener) {
        UIComponent buttonComponent = this.getFacet(facetName);
        if (buttonComponent != null) {
            return buttonComponent;
        }
        Button button = (Button)ComponentUtilities.getPrivateFacet((UIComponent)this, facetName, true);
        if (button == null) {
            button = new Button();
            button.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, facetName));
            button.addActionListener(actionListener);
            ComponentUtilities.putPrivateFacet((UIComponent)this, facetName, (UIComponent)button);
        }
        this.initButtonFacet(button, primary, text);
        return button;
    }

    private void initButtonFacet(Button button, boolean primary, String text) {
        button.setText(text);
        int tindex = this.getTabIndex();
        if (tindex > 0) {
            button.setTabIndex(tindex);
        }
        button.setImmediate(true);
        button.setPrimary(primary);
        button.setDisabled(this.isDisabled());
    }

    public UIComponent getListLabelComponent() {
        String labelString = this.getListLabel();
        if (labelString == null || labelString.length() == 0) {
            labelString = this.getTheme().getMessage(LIST_LABEL_TEXT_KEY);
        }
        return this.getLabelFacet(LIST_LABEL_FACET, labelString, (UIComponent)this);
    }

    public UIComponent getFieldLabelComponent() {
        String labelString = this.getFieldLabel();
        if (labelString == null || labelString.length() == 0) {
            labelString = this.getTheme().getMessage(FIELD_LABEL_TEXT_KEY);
        }
        return this.getLabelFacet(FIELD_LABEL_FACET, labelString, this.getFieldComponent());
    }

    private UIComponent getLabelFacet(String facetName, String text, UIComponent forComponent) {
        UIComponent labelComponent = this.getFacet(facetName);
        if (labelComponent != null) {
            return labelComponent;
        }
        Label label = (Label)ComponentUtilities.getPrivateFacet((UIComponent)this, facetName, true);
        if (label == null) {
            label = new Label();
            label.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, facetName));
            ComponentUtilities.putPrivateFacet((UIComponent)this, facetName, (UIComponent)label);
        }
        this.initLabelFacet(label, text, forComponent);
        return label;
    }

    private void initLabelFacet(Label label, String labelString, UIComponent forComponent) {
        if (labelString == null || labelString.length() < 1) {
            labelString = new String();
        }
        label.setText(labelString);
        label.setLabelLevel(this.getLabelLevel());
        label.setLabeledComponent(forComponent);
    }

    private UIComponent getRenderedFieldComponent() {
        UIComponent fieldComponent = this.getFacet(FIELD_FACET);
        if (fieldComponent != null) {
            return fieldComponent;
        }
        fieldComponent = ComponentUtilities.getPrivateFacet((UIComponent)this, FIELD_FACET, false);
        return fieldComponent == null ? this.getFieldComponent() : fieldComponent;
    }

    public UIComponent getFieldComponent() {
        UIComponent fieldComponent = this.getFacet(FIELD_FACET);
        if (fieldComponent != null) {
            return fieldComponent;
        }
        TextField field = (TextField)ComponentUtilities.getPrivateFacet((UIComponent)this, FIELD_FACET, true);
        if (field == null) {
            field = new TextField();
            field.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, FIELD_FACET));
            field.setTrim(true);
            ComponentUtilities.putPrivateFacet((UIComponent)this, FIELD_FACET, (UIComponent)field);
        }
        this.initFieldFacet(field);
        return field;
    }

    private void initFieldFacet(TextField field) {
        Validator[] slvalidators;
        MethodBinding validator;
        String jsObjectName = this.getJavaScriptObjectName();
        StringBuffer onkeypressBuffer = new StringBuffer(128);
        onkeypressBuffer.append("if(event.keyCode == 13) { ");
        onkeypressBuffer.append(jsObjectName);
        onkeypressBuffer.append(ADD_FUNCTION);
        onkeypressBuffer.append("return false; } ");
        field.setOnKeyPress(onkeypressBuffer.toString());
        StringBuffer onfocusBuffer = new StringBuffer(128);
        onfocusBuffer.append(jsObjectName);
        onfocusBuffer.append(SET_ADD_DISABLED_FUNCTION);
        onfocusBuffer.append("return false;");
        field.setOnFocus(onfocusBuffer.toString());
        StringBuffer onfocuslostBuffer = new StringBuffer(128);
        onfocuslostBuffer.append(jsObjectName);
        onfocuslostBuffer.append(ENABLE_ADD_FUNCTION);
        onfocuslostBuffer.append("return false;");
        field.setOnBlur(onfocuslostBuffer.toString());
        int columns = this.getMaxLength();
        if (columns < 20) {
            columns = 20;
        }
        field.setColumns(columns);
        int tindex = this.getTabIndex();
        if (tindex > 0) {
            field.setTabIndex(tindex);
        }
        if ((validator = this.getFieldValidator()) != null) {
            field.setValidator(validator);
        }
        if ((slvalidators = this.getValidators()) != null) {
            for (int i = 0; i < slvalidators.length; ++i) {
                this.removeValidator(slvalidators[i]);
            }
        }
        StringLengthValidator strl = new StringLengthValidator(this.getMaxLength(), 1);
        Theme theme = this.getTheme();
        strl.setTooLongMessage(theme.getMessage(SLV_TOOLONG_KEY));
        strl.setTooShortMessage(theme.getMessage(SLV_TOOSHORT_KEY));
        field.addValidator(strl);
        field.setDisabled(this.isDisabled());
    }

    public UIComponent getReadOnlyValueComponent() {
        UIComponent textComponent = this.getFacet(READ_ONLY_FACET);
        if (textComponent != null) {
            return textComponent;
        }
        StaticText text = new StaticText();
        text.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, READ_ONLY_FACET));
        text.setParent((UIComponent)this);
        FacesContext context = FacesContext.getCurrentInstance();
        String readOnlyString = this.getValueAsReadOnly(context);
        if (readOnlyString == null || readOnlyString.length() < 1) {
            readOnlyString = new String();
        }
        text.setText(readOnlyString);
        return text;
    }

    protected String getValueAsReadOnly(FacesContext context) throws FacesException {
        StringBuffer valueBuffer = new StringBuffer(200);
        Iterator iterator = this.getListItems(context, false);
        while (iterator.hasNext()) {
            String string = ((ListItem)iterator.next()).getLabel();
            if (string.indexOf("nbsp") > -1) continue;
            valueBuffer.append(string);
            if (!iterator.hasNext()) continue;
            valueBuffer.append(READ_ONLY_SEPARATOR);
        }
        return valueBuffer.toString();
    }

    public void setConverter(Converter converter) {
        String msg = this.getTheme().getMessage("EditableList.noConversion");
        throw new RuntimeException(msg);
    }

    public String getJavaScriptObjectName() {
        Object o = this.getAttributes().get(JSOBJECT);
        String name = null;
        if (o != null && o instanceof String) {
            name = (String)o;
        } else {
            FacesContext context = FacesContext.getCurrentInstance();
            name = this.getClientId(context).replace(':', '_');
            name = "EditableList_".concat(name);
            this.getAttributes().put(JSOBJECT, name);
        }
        return name;
    }

    private Theme getTheme() {
        return ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
    }

    public String getOnChange() {
        StringBuffer onchangeBuffer = new StringBuffer(128);
        onchangeBuffer.append(this.getJavaScriptObjectName());
        onchangeBuffer.append(ENABLE_REMOVE_FUNCTION);
        return onchangeBuffer.toString();
    }

    public String getPrimaryElementID(FacesContext context) {
        return this.getClientId(context).concat("_list");
    }

    public String[] getValuesToRemove() {
        if (this.valuesToRemove == null) {
            return new String[0];
        }
        return this.valuesToRemove;
    }

    public void setValuesToRemove(String[] valuesToRemove) {
        this.valuesToRemove = valuesToRemove;
    }

    public Iterator getListItems(FacesContext context, boolean rulerAtEnd) throws FacesException {
        Locale locale = context.getViewRoot().getLocale();
        this.collator = Collator.getInstance(locale);
        this.listItems = new TreeMap(this.collator);
        boolean sorted = this.isSorted();
        HashMap<String, String> keysSeen = sorted ? new HashMap<String, String>() : null;
        String lastKey = "";
        String[] currentValues = this.getCurrentValueAsStringArray();
        String currentString = null;
        ListItem listItem = null;
        ListItem selectedItem = null;
        StringBuffer unsortedKeyBuffer = sorted ? null : new StringBuffer(KEY_STRING);
        for (int counter = 0; counter < currentValues.length; ++counter) {
            currentString = currentValues[counter];
            if (currentString == null) {
                String msg = MessageUtil.getMessage("com.sun.web.ui.resources.LogMessages", "EditableList.badValue", new Object[]{this.getClientId(context)});
                throw new FacesException(msg);
            }
            listItem = new ListItem(currentString);
            listItem.setValue(currentString);
            if (currentString.equals(this.selectedValue)) {
                selectedItem = listItem;
            }
            if (sorted) {
                String key = currentString;
                if (keysSeen.containsKey(key)) {
                    String dup_string = (String)keysSeen.get(key);
                    dup_string = dup_string.concat(DUP_STRING);
                    key = key.concat(dup_string);
                    keysSeen.put(currentString, dup_string);
                } else {
                    keysSeen.put(key, DUP_STRING);
                }
                if (this.collator.compare(key, lastKey) > 0) {
                    lastKey = key;
                }
                this.listItems.put(key, listItem);
                continue;
            }
            this.listItems.put(unsortedKeyBuffer.toString(), listItem);
            unsortedKeyBuffer.append(KEY_STRING);
        }
        if (selectedItem != null) {
            selectedItem.setSelected(true);
        }
        if (!sorted) {
            lastKey = unsortedKeyBuffer.toString();
        }
        if (rulerAtEnd) {
            int length = this.getMaxlLength();
            if (length < 20) {
                length = 20;
            }
            StringBuffer labelBuffer = new StringBuffer(length);
            for (int counter = 0; counter < length; ++counter) {
                labelBuffer.append(SPACER_STRING);
            }
            ListItem item = new ListItem(labelBuffer.toString());
            item.setDisabled(true);
            this.listItems.put(lastKey.concat(KEY_STRING), item);
        }
        return this.listItems.values().iterator();
    }

    private String[] getCurrentValueAsStringArray() {
        Object value = this.getSubmittedValue();
        if (value == null) {
            value = this.getValue();
        }
        if (value == null) {
            return new String[0];
        }
        if (value instanceof String[]) {
            return (String[])value;
        }
        String msg = MessageUtil.getMessage("com.sun.web.ui.resources.LogMessages", "EditableList.badValue", new Object[]{this.getClientId(FacesContext.getCurrentInstance())});
        throw new FacesException(msg);
    }

    private void log(String s) {
        System.out.println(this.getClass().getName() + "::" + s);
    }

    public Object getConvertedValue(FacesContext context, Object submittedValue) throws ConverterException {
        if (!(submittedValue instanceof String[])) {
            throw new ConverterException("Submitted value must be a String array");
        }
        String[] rawValues = (String[])submittedValue;
        if (rawValues.length == 0 && ConversionUtilities.renderedNull((UIComponent)this)) {
            return null;
        }
        return submittedValue;
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        UIComponent field = this.getRenderedFieldComponent();
        String fieldId = field.getId();
        Iterator kids = this.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            if (fieldId != null && fieldId.equals(kid.getId())) continue;
            kid.processValidators(context);
        }
        this.checkValid(context);
    }

    public void processAddAction() {
        if (FacesContext.getCurrentInstance().getRenderResponse()) {
            return;
        }
        this.selectedValue = null;
        String[] values = this.getCurrentValueAsStringArray();
        Object value = this.getAddedObject();
        if (value == null) {
            return;
        }
        this.selectedValue = value.toString();
        int numValues = values.length;
        String[] newValues = new String[numValues + 1];
        for (int counter = 0; counter < numValues; ++counter) {
            newValues[counter] = values[counter];
        }
        newValues[counter] = this.selectedValue;
        this.setSubmittedValue(newValues);
    }

    public void processRemoveAction() {
        int counter;
        if (FacesContext.getCurrentInstance().getRenderResponse()) {
            return;
        }
        this.selectedValue = null;
        ArrayList<String> items = new ArrayList<String>();
        if (this.getValue() != null) {
            String[] strings = this.getCurrentValueAsStringArray();
            int length = strings.length;
            for (counter = 0; counter < length; ++counter) {
                items.add(strings[counter]);
            }
        }
        String[] valuesToRemove = this.getValuesToRemove();
        for (counter = 0; counter < valuesToRemove.length; ++counter) {
            items.remove(valuesToRemove[counter]);
        }
        String[] newValues = new String[items.size()];
        for (counter = 0; counter < items.size(); ++counter) {
            newValues[counter] = (String)items.get(counter);
        }
        this.setValuesToRemove(null);
        this.setSubmittedValue(newValues);
    }

    private void checkValid(FacesContext context) {
        try {
            this.validate(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        if (!this.isValid()) {
            context.renderResponse();
        }
    }

    private Object getAddedObject() {
        FacesContext context = FacesContext.getCurrentInstance();
        EditableValueHolder field = (EditableValueHolder)this.getRenderedFieldComponent();
        ((UIComponent)field).processValidators(context);
        if (!field.isValid()) {
            return null;
        }
        Object value = field.getValue();
        if (value == null || value instanceof String && value.toString().length() == 0) {
            field.setValid(false);
            context.renderResponse();
            String message = ThemeUtilities.getTheme(context).getMessage(SLV_TOOSHORT_KEY);
            context.addMessage(this.getClientId(context), new FacesMessage(message));
            return null;
        }
        field.setValue(null);
        return value;
    }

    public boolean isImmediate() {
        return false;
    }

    protected boolean compareValues(Object previous, Object value) {
        if (previous == null || value == null) {
            return super.compareValues(previous, value);
        }
        if (value instanceof Object[]) {
            int length = Array.getLength(value);
            if (Array.getLength(previous) != length) {
                return true;
            }
            for (int i = 0; i < length; ++i) {
                Object newValue = Array.get(value, i);
                Object prevValue = Array.get(previous, i);
                if (newValue == null) {
                    if (prevValue == null) continue;
                    return true;
                }
                if (prevValue == null) {
                    return true;
                }
                if (prevValue.equals(newValue)) continue;
                return true;
            }
            return false;
        }
        return super.compareValues(previous, value);
    }

    public String[] getValueAsStringArray(FacesContext context) {
        Iterator iterator = this.getListItems(context, false);
        int numItems = this.listItems.size();
        String[] values = new String[numItems];
        for (int counter = 0; counter < numItems; ++counter) {
            values[counter] = ((ListItem)iterator.next()).getValue();
        }
        return values;
    }

    public boolean mainListSubmits() {
        return true;
    }
}

