/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.component.util.descriptors;

import com.sun.web.ui.util.ResourceFactory;
import java.io.Serializable;

public class Resource
implements Serializable {
    private String _id = null;
    private String _extraInfo = null;
    private String _factoryClass = null;
    private transient ResourceFactory _factory = null;

    public Resource(String id, String extraInfo, String factoryClass) {
        if (id == null) {
            throw new NullPointerException("'id' cannot be null!");
        }
        if (factoryClass == null) {
            throw new NullPointerException("'factoryClass' cannot be null!");
        }
        this._id = id;
        this._extraInfo = extraInfo;
        this._factoryClass = factoryClass;
        this._factory = this.createFactory();
    }

    public String getId() {
        return this._id;
    }

    public String getExtraInfo() {
        return this._extraInfo;
    }

    public ResourceFactory getFactory() {
        if (this._factory == null) {
            this._factory = this.createFactory();
        }
        return this._factory;
    }

    protected ResourceFactory createFactory() {
        try {
            Class<?> cls = Class.forName(this._factoryClass);
            return (ResourceFactory)cls.newInstance();
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }
}

