/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.faces;

import com.sun.web.ui.util.LogUtil;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.el.PropertyNotFoundException;
import javax.faces.el.PropertyResolver;

public class UIComponentPropertyResolver
extends PropertyResolver {
    private PropertyResolver original = null;

    public UIComponentPropertyResolver() {
        LogUtil.warning(UIComponentPropertyResolver.class, "UIComponentPropertyResolver(NONE)");
    }

    public UIComponentPropertyResolver(PropertyResolver original) {
        this.original = original;
        if (LogUtil.fineEnabled(UIComponentPropertyResolver.class)) {
            LogUtil.fine(UIComponentPropertyResolver.class, "UIComponentPropertyResolver(" + original + ")");
        }
    }

    public Object getValue(Object base, Object property) {
        if (LogUtil.finestEnabled(UIComponentPropertyResolver.class)) {
            LogUtil.finest(UIComponentPropertyResolver.class, "getValue(" + base + "," + property + ")");
        }
        if (base == null || !(base instanceof UIComponent) || property == null) {
            if (LogUtil.finestEnabled(UIComponentPropertyResolver.class)) {
                LogUtil.finest(UIComponentPropertyResolver.class, "  Delegated to decorated PropertyResolver");
            }
            return this.original.getValue(base, property);
        }
        UIComponent component = (UIComponent)base;
        String id = property.toString();
        UIComponent kid = (UIComponent)component.getFacets().get(id);
        if (kid != null) {
            return kid;
        }
        if (component.getChildCount() < 1) {
            return this.original.getValue(base, property);
        }
        List kids = component.getChildren();
        for (int i = 0; i < kids.size(); ++i) {
            kid = (UIComponent)kids.get(i);
            if (!id.equals(kid.getId())) continue;
            if (LogUtil.finestEnabled(UIComponentPropertyResolver.class)) {
                LogUtil.finest(UIComponentPropertyResolver.class, "  Returning child " + kid);
            }
            return kid;
        }
        return this.original.getValue(base, property);
    }

    public Object getValue(Object base, int index) {
        if (base == null || !(base instanceof UIComponent)) {
            return this.original.getValue(base, index);
        }
        UIComponent component = (UIComponent)base;
        if (component.getChildCount() < 1) {
            throw new PropertyNotFoundException("" + index);
        }
        try {
            return component.getChildren().get(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new PropertyNotFoundException("" + index);
        }
    }

    public void setValue(Object base, Object property, Object value) {
        if (base == null || !(base instanceof UIComponent) || property == null || value == null || !(value instanceof UIComponent)) {
            this.original.setValue(base, property, value);
            return;
        }
        UIComponent component = (UIComponent)base;
        String id = property.toString();
        if (component.getFacets().get(id) != null) {
            component.getFacets().put(id, value);
            return;
        }
        if (component.getChildCount() < 1) {
            this.original.setValue(base, property, value);
            return;
        }
        List kids = component.getChildren();
        for (int i = 0; i < kids.size(); ++i) {
            UIComponent kid = (UIComponent)kids.get(i);
            if (!id.equals(kid.getId())) continue;
            kids.set(i, value);
            return;
        }
        this.original.setValue(base, property, value);
    }

    public void setValue(Object base, int index, Object value) {
        if (base == null || !(base instanceof UIComponent) || value == null || !(value instanceof UIComponent)) {
            this.original.setValue(base, index, value);
            return;
        }
        UIComponent component = (UIComponent)base;
        if (component.getChildCount() < 1) {
            throw new PropertyNotFoundException("" + index);
        }
        try {
            component.getChildren().set(index, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw new PropertyNotFoundException("" + index);
        }
    }

    public boolean isReadOnly(Object base, Object property) {
        if (base == null || !(base instanceof UIComponent) || property == null) {
            return this.original.isReadOnly(base, property);
        }
        UIComponent component = (UIComponent)base;
        String id = property.toString();
        if (component.getFacets().get(id) != null) {
            return false;
        }
        if (component.getChildCount() < 1) {
            return this.original.isReadOnly(base, property);
        }
        List kids = component.getChildren();
        for (int i = 0; i < kids.size(); ++i) {
            UIComponent kid = (UIComponent)kids.get(i);
            if (!id.equals(kid.getId())) continue;
            return false;
        }
        return this.original.isReadOnly(base, property);
    }

    public boolean isReadOnly(Object base, int index) {
        if (base == null || !(base instanceof UIComponent)) {
            return this.original.isReadOnly(base, index);
        }
        UIComponent component = (UIComponent)base;
        if (component.getChildCount() < 1) {
            throw new PropertyNotFoundException("" + index);
        }
        try {
            component.getChildren().get(index);
            return false;
        }
        catch (IndexOutOfBoundsException e) {
            throw new PropertyNotFoundException("" + index);
        }
    }

    public Class getType(Object base, Object property) {
        if (base == null || !(base instanceof UIComponent) || property == null) {
            return this.original.getType(base, property);
        }
        UIComponent component = (UIComponent)base;
        String id = property.toString();
        if (component.getFacets().get(id) != null) {
            return UIComponent.class;
        }
        if (component.getChildCount() < 1) {
            return this.original.getType(base, property);
        }
        List kids = component.getChildren();
        for (int i = 0; i < kids.size(); ++i) {
            UIComponent kid = (UIComponent)kids.get(i);
            if (!id.equals(kid.getId())) continue;
            return UIComponent.class;
        }
        return this.original.getType(base, property);
    }

    public Class getType(Object base, int index) {
        if (base == null || !(base instanceof UIComponent)) {
            return this.original.getType(base, index);
        }
        UIComponent component = (UIComponent)base;
        if (component.getChildCount() < 1) {
            throw new PropertyNotFoundException("" + index);
        }
        try {
            component.getChildren().get(index);
            return UIComponent.class;
        }
        catch (IndexOutOfBoundsException e) {
            throw new PropertyNotFoundException("" + index);
        }
    }
}

