/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.renderer;

import com.sun.web.ui.component.Tab;
import com.sun.web.ui.component.TabSet;
import com.sun.web.ui.renderer.AbstractRenderer;
import com.sun.web.ui.theme.Theme;
import com.sun.web.ui.util.LogUtil;
import com.sun.web.ui.util.RenderingUtilities;
import com.sun.web.ui.util.ThemeUtilities;
import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.MethodBinding;

public class TabSetRenderer
extends AbstractRenderer {
    private static final String SKIP_ANCHOR_NAME = "tabSetSkipAnchor";

    public boolean getRendersChildren() {
        return true;
    }

    public void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        TabSet tabSet = (TabSet)component;
        String selectedTabId = tabSet.getSelected();
        Theme theme = ThemeUtilities.getTheme(context);
        String lite = theme.getStyleClass("TABGROUPBOX");
        if (selectedTabId == null) {
            if (tabSet.isMini() && tabSet.isLite()) {
                writer.startElement("div", (UIComponent)tabSet);
                writer.writeAttribute("class", (Object)lite, null);
                writer.endElement("div");
            }
            writer.endElement("div");
            return;
        }
        Tab selectedTab = tabSet.findChildTab(selectedTabId);
        if (selectedTab == null) {
            if (tabSet.isMini() && tabSet.isLite()) {
                writer.startElement("div", (UIComponent)tabSet);
                writer.writeAttribute("class", (Object)lite, null);
                writer.endElement("div");
            }
            writer.endElement("div");
            return;
        }
        if (tabSet.isMini() && tabSet.isLite()) {
            writer.startElement("div", (UIComponent)tabSet);
            writer.writeAttribute("class", (Object)lite, null);
        }
        while (selectedTab.hasTabChildren()) {
            selectedTabId = selectedTab.getSelectedChildId();
            if (selectedTabId == null) {
                selectedTabId = ((Tab)selectedTab.getChildren().get(0)).getId();
            }
            selectedTab = (Tab)selectedTab.findComponent(selectedTabId);
        }
        int numKids = selectedTab.getChildCount();
        if (numKids > 0) {
            UIComponent facet = tabSet.getFacet("contentHeader");
            if (facet != null) {
                RenderingUtilities.renderComponent(facet, context);
            }
            List kids = selectedTab.getChildren();
            for (int i = 0; i < numKids; ++i) {
                UIComponent kid = (UIComponent)kids.get(i);
                RenderingUtilities.renderComponent(kid, context);
            }
            facet = tabSet.getFacet("contentFooter");
            if (facet != null) {
                RenderingUtilities.renderComponent(facet, context);
            }
        }
        if (tabSet.isMini() && tabSet.isLite()) {
            writer.endElement("div");
        }
        writer.endElement("div");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        List level3Tabs;
        TabSet tabSet = (TabSet)component;
        ResponseWriter writer = context.getResponseWriter();
        Theme theme = ThemeUtilities.getTheme(context);
        List level1 = tabSet.getChildren();
        if (level1.size() < 1) {
            if (LogUtil.infoEnabled()) {
                LogUtil.info((Object)TabSetRenderer.class, "WEBUI0005", new String[]{tabSet.getId()});
            }
            return;
        }
        this.startTabSetDiv(writer, tabSet, theme);
        this.renderSkipLink(context, tabSet, theme);
        List level2Tabs = this.renderLevel(context, tabSet, writer, 1, tabSet.getChildren());
        if (level2Tabs != null && (level3Tabs = this.renderLevel(context, tabSet, writer, 2, level2Tabs)) != null) {
            this.renderLevel(context, tabSet, writer, 3, level3Tabs);
        }
        RenderingUtilities.renderAnchor(SKIP_ANCHOR_NAME, (UIComponent)tabSet, context);
    }

    private void startTabSetDiv(ResponseWriter writer, TabSet tabSet, Theme theme) throws IOException {
        String style = tabSet.getStyle();
        String styleClass = tabSet.getStyleClass();
        String lite = theme.getStyleClass("TABGROUP");
        if (tabSet.isMini() && tabSet.isLite()) {
            styleClass = styleClass != null ? styleClass + " " + lite : lite;
        }
        writer.startElement("div", (UIComponent)tabSet);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
    }

    private String[] getStyles(TabSet tabSet, Theme theme, int level) {
        String divStyle = "";
        String tableStyle = "";
        String linkStyle = "";
        String selectedTdStyle = "";
        String selectedTextStyle = "";
        switch (level) {
            case 1: {
                if (tabSet.isMini()) {
                    divStyle = theme.getStyleClass("MINI_TAB_DIV");
                    tableStyle = theme.getStyleClass("MINI_TAB_TABLE");
                    linkStyle = theme.getStyleClass("MINI_TAB_LINK");
                    selectedTdStyle = theme.getStyleClass("MINI_TAB_TABLE_SELECTED_TD");
                    selectedTextStyle = theme.getStyleClass("MINI_TAB_SELECTED_TEXT");
                    break;
                }
                divStyle = theme.getStyleClass("TAB1_DIV");
                tableStyle = theme.getStyleClass("TAB1_TABLE_NEW");
                linkStyle = theme.getStyleClass("TAB1_LINK");
                selectedTdStyle = theme.getStyleClass("TAB1_TABLE_SELECTED_TD");
                selectedTextStyle = theme.getStyleClass("TAB1_SELECTED_TEXT_NEW");
                break;
            }
            case 2: {
                divStyle = theme.getStyleClass("TAB2_DIV");
                tableStyle = theme.getStyleClass("TAB2_TABLE_NEW");
                linkStyle = theme.getStyleClass("TAB2_LINK");
                selectedTdStyle = theme.getStyleClass("TAB2_TABLE_SELECTED_TD");
                selectedTextStyle = theme.getStyleClass("TAB2_SELECTED_TEXT");
                break;
            }
            case 3: {
                divStyle = theme.getStyleClass("TAB3_DIV");
                tableStyle = theme.getStyleClass("TAB3_TABLE_NEW");
                linkStyle = theme.getStyleClass("TAB3_LINK");
                selectedTdStyle = theme.getStyleClass("TAB3_TABLE_SELECTED_TD");
                selectedTextStyle = theme.getStyleClass("TAB3_SELECTED_TEXT");
            }
        }
        String[] styles = new String[]{divStyle, tableStyle, linkStyle, selectedTdStyle, selectedTextStyle};
        return styles;
    }

    private void renderSkipLink(FacesContext context, TabSet tabSet, Theme theme) throws IOException {
        Tab selectedTab = tabSet.findChildTab(tabSet.getSelected());
        Object[] args = new String[]{selectedTab != null ? selectedTab.getText() : ""};
        String toolTip = theme.getMessage("tab.skipTagAltText", args);
        String styleClass = theme.getStyleClass("SKIP_MEDIUM_GREY1");
        RenderingUtilities.renderSkipLink(SKIP_ANCHOR_NAME, styleClass, null, toolTip, null, (UIComponent)tabSet, context);
    }

    private void layoutLevel(ResponseWriter writer, TabSet tabSet, String[] styles) throws IOException {
        writer.startElement("div", (UIComponent)tabSet);
        writer.writeAttribute("class", (Object)styles[0], null);
        writer.startElement("table", (UIComponent)tabSet);
        writer.writeAttribute("border", (Object)"0", null);
        writer.writeAttribute("cellspacing", (Object)"0", null);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.writeAttribute("class", (Object)styles[1], null);
        writer.writeAttribute("title", (Object)"", null);
        writer.startElement("tr", (UIComponent)tabSet);
    }

    protected List renderLevel(FacesContext context, TabSet tabSet, ResponseWriter writer, int level, List currentLevelTabs) throws IOException {
        int numTabs = currentLevelTabs.size();
        if (numTabs == 0) {
            return null;
        }
        Theme theme = ThemeUtilities.getTheme(context);
        String[] styles = this.getStyles(tabSet, theme, level);
        String hidden = theme.getStyleClass("HIDDEN");
        String selectedTabId = tabSet.getSelected();
        Tab currentLevelSelection = null;
        boolean levelHasSelection = false;
        for (int i = 0; i < numTabs; ++i) {
            try {
                currentLevelSelection = (Tab)currentLevelTabs.get(i);
            }
            catch (ClassCastException cce) {
                continue;
            }
            if (!this.isSelected(currentLevelSelection, selectedTabId)) continue;
            levelHasSelection = true;
            break;
        }
        if (!levelHasSelection) {
            try {
                selectedTabId = ((Tab)currentLevelTabs.get(0)).getId();
                tabSet.setSelected(selectedTabId);
            }
            catch (ClassCastException cce) {
                // empty catch block
            }
        }
        if (currentLevelSelection != null && currentLevelSelection.hasTabChildren()) {
            switch (level) {
                case 1: {
                    styles[1] = theme.getStyleClass("TAB1_TABLE2_NEW");
                    break;
                }
                case 2: {
                    styles[1] = theme.getStyleClass("TAB2_TABLE3_NEW");
                    break;
                }
            }
        }
        this.layoutLevel(writer, tabSet, styles);
        MethodBinding binding = tabSet.getActionListener();
        List nextLevelToRender = null;
        for (int i = 0; i < numTabs; ++i) {
            Tab tab = null;
            try {
                tab = (Tab)currentLevelTabs.get(i);
            }
            catch (ClassCastException cce) {
                continue;
            }
            if (!tab.isRendered()) continue;
            if (binding != null && tab.getActionListener() == null) {
                tab.setActionListener(binding);
            }
            writer.startElement("td", (UIComponent)tabSet);
            String newSelectedClass = styles[3];
            String newNonSelectedClass = null;
            if (!tab.isVisible()) {
                newSelectedClass = newSelectedClass.concat(" ").concat(hidden);
                newNonSelectedClass = hidden;
            }
            if (selectedTabId != null && this.isSelected(tab, selectedTabId)) {
                nextLevelToRender = this.renderSelectedTab(context, writer, theme, tabSet, tab, styles, newSelectedClass);
            } else {
                tab.setStyleClass(styles[2]);
                RenderingUtilities.renderComponent((UIComponent)tab, context);
            }
            writer.endElement("td");
            if (selectedTabId == null || level != 3 || i >= numTabs - 1) continue;
            this.handleLevel3Tab(writer, theme, tabSet, selectedTabId, currentLevelTabs, tab, i);
        }
        writer.endElement("tr");
        writer.endElement("table");
        writer.endElement("div");
        return nextLevelToRender;
    }

    private void handleLevel3Tab(ResponseWriter writer, Theme theme, TabSet tabSet, String selectedTabId, List currentLevelTabs, Tab currentTab, int currentTabIndex) throws IOException {
        Tab nextTab = (Tab)currentLevelTabs.get(currentTabIndex + 1);
        if (!nextTab.isRendered()) {
            try {
                nextTab = (Tab)currentLevelTabs.get(currentTabIndex + 2);
            }
            catch (IndexOutOfBoundsException e) {
                nextTab = null;
            }
        }
        if (nextTab != null && !currentTab.getId().equals(selectedTabId) && !nextTab.getId().equals(selectedTabId)) {
            String dividerSrc = theme.getIcon("TAB_DIVIDER").getUrl();
            this.writeDivider(tabSet, writer, dividerSrc);
        }
    }

    private List renderSelectedTab(FacesContext context, ResponseWriter writer, Theme theme, TabSet tabSet, Tab tab, String[] styles, String selectedClass) throws IOException {
        String label;
        UIComponent parent = tab.getParent();
        if (parent != null && parent instanceof Tab) {
            if (tabSet.isLastSelectedChildSaved()) {
                ((Tab)parent).setSelectedChildId(tab.getId());
            } else {
                ((Tab)parent).setSelectedChildId(null);
            }
        }
        if ((label = tab.getText()) == null) {
            label = "";
        }
        String selectionDivClass = styles[4];
        if (label.length() < 6) {
            String padClass = theme.getStyleClass("TAB_PADDING");
            selectionDivClass = selectionDivClass.concat(" ").concat(padClass);
        }
        writer.writeAttribute("class", (Object)selectedClass, null);
        writer.startElement("div", (UIComponent)tabSet);
        writer.writeAttribute("class", (Object)selectionDivClass, null);
        String titleString = theme.getMessage("tabSet.selectedTab", new Object[]{label});
        writer.writeAttribute("title", (Object)titleString, null);
        writer.write(label);
        writer.endElement("div");
        return tab.getChildren();
    }

    protected void writeDivider(TabSet tabSet, ResponseWriter writer, String src) throws IOException {
        writer.startElement("td", (UIComponent)tabSet);
        writer.startElement("img", (UIComponent)tabSet);
        writer.writeAttribute("src", (Object)src, null);
        writer.writeAttribute("alt", (Object)"", null);
        writer.writeAttribute("border", (Object)"0", null);
        writer.writeAttribute("height", (Object)"20", null);
        writer.writeAttribute("width", (Object)"5", null);
        writer.endElement("img");
        writer.endElement("td");
    }

    protected boolean isSelected(Tab tab, String selectedTabId) {
        if (tab.getId().equals(selectedTabId)) {
            return true;
        }
        List subTabs = tab.getChildren();
        boolean descendantSelected = false;
        for (int i = 0; i < subTabs.size(); ++i) {
            Tab subTab = null;
            try {
                subTab = (Tab)subTabs.get(i);
            }
            catch (ClassCastException cce) {
                continue;
            }
            descendantSelected = this.isSelected(subTab, selectedTabId);
            if (descendantSelected) break;
        }
        return descendantSelected;
    }
}

