/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.model;

import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.ModelControlException;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.model.CCBreadCrumbsModelInterface;
import com.sun.web.ui.model.CCDocumentBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.servlet.ServletContext;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CCBreadCrumbsModel
extends DefaultModel
implements CCBreadCrumbsModelInterface {
    private static final long serialVersionUID = -4753069606370138839L;
    protected String useGrayBg = null;
    protected String currentPageLabel;
    public static final String LINK_TAG_NAME = "link";
    public static final String PAGE_TAG_NAME = "page";
    public static final String ONCLICK_ATTR = "onClick";
    public static final String TARGET_ATTR = "target";
    public static final String COMMANDFIELD_ATTR = "href";
    public static final String MOUSEOVER_ATTR = "mouseOver";
    public static final String VALUE_ATTR = "hrefValue";
    protected transient Document xmlDocument;
    protected transient InputStream xmlStream;
    private String xmlAsString = null;

    public CCBreadCrumbsModel() {
    }

    public CCBreadCrumbsModel(String pageLabel) {
        this.currentPageLabel = pageLabel;
    }

    public CCBreadCrumbsModel(ServletContext sc, String value) {
        this(sc.getResourceAsStream(value));
    }

    public CCBreadCrumbsModel(InputStream xmlStream) {
        this.xmlStream = xmlStream;
        try {
            this.parseXML();
            this.buildPathFromDOM();
            this.xmlAsString = CCDocumentBuilder.getXMLString(xmlStream);
        }
        catch (Exception e) {
            System.out.println("err in bc constructor");
            e.printStackTrace();
            CCDebug.trace1("Error building breadcrumb model from given XML", e);
        }
    }

    public String getCurrentPageLabel() {
        return this.currentPageLabel;
    }

    public void setCurrentPageLabel(String pageLabel) {
        this.currentPageLabel = pageLabel;
    }

    protected void parseXML() {
        this.xmlDocument = CCDocumentBuilder.createDocument(this.xmlStream);
    }

    protected void buildPathFromDOM() {
        Node node;
        NodeList links = this.xmlDocument.getElementsByTagName(LINK_TAG_NAME);
        for (int i = 0; i < links.getLength(); ++i) {
            this.appendRow();
            node = links.item(i);
            NamedNodeMap attrs = node.getAttributes();
            this.setValue("label", node.getFirstChild().getNodeValue());
            for (int j = 0; j < attrs.getLength(); ++j) {
                String nodeName = attrs.item(j).getNodeName();
                String nodeValue = attrs.item(j).getNodeValue();
                if (nodeName.equals(COMMANDFIELD_ATTR)) {
                    this.setValue("commandField", nodeValue);
                    continue;
                }
                if (nodeName.equals(MOUSEOVER_ATTR)) {
                    this.setValue("status", nodeValue);
                    continue;
                }
                if (nodeName.equals(ONCLICK_ATTR)) {
                    this.setValue(ONCLICK_ATTR, nodeValue);
                    continue;
                }
                if (nodeName.equals(TARGET_ATTR)) {
                    this.setValue(TARGET_ATTR, nodeValue);
                    continue;
                }
                if (!nodeName.equals(VALUE_ATTR)) continue;
                this.setValue("value", nodeValue);
            }
        }
        links = this.xmlDocument.getElementsByTagName(PAGE_TAG_NAME);
        node = links.item(0);
        this.currentPageLabel = node.getFirstChild().getNodeValue();
    }

    public String getUseGrayBg() {
        return this.isUseGrayBgSet() ? this.useGrayBg : "false";
    }

    public void setUseGrayBg(String useGrayBg) {
        if (useGrayBg != null && !useGrayBg.toLowerCase().equals("true") && !useGrayBg.toLowerCase().equals("false")) {
            CCDebug.trace1("Invalid parameter: " + useGrayBg);
            return;
        }
        this.useGrayBg = useGrayBg;
    }

    public boolean isUseGrayBgSet() {
        return this.useGrayBg != null;
    }

    public boolean next() throws ModelControlException {
        boolean hasNext = super.next();
        if (hasNext && this.getRowIndex() == 0) {
            hasNext = this.getValue("commandField") != null;
        }
        return hasNext;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        CCDocumentBuilder.createDocument(new ByteArrayInputStream(this.xmlAsString.getBytes()));
    }
}

