/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.model;

import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.model.CCManageChildrenModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCDropDownMenu;
import com.sun.web.ui.view.html.CCStaticTextField;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.ServletContext;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CCPageTitleModel
extends CCManageChildrenModel
implements CCPageTitleModelInterface {
    private static final long serialVersionUID = -6180314027414608987L;
    private String pageTitleText = null;
    private String alertIconType = null;
    private String pageTitleHelpMessage = null;
    private Boolean showPageTitleSeparator = null;
    private Boolean showPageButtonsTop = null;
    private Boolean showPageButtonsBottom = null;
    private Boolean showPageBottomSpacer = null;
    private HashMap childMap = new HashMap();

    public CCPageTitleModel() {
        CCDebug.initTrace();
    }

    public CCPageTitleModel(String value) {
        this();
        this.setDocument(value);
    }

    public CCPageTitleModel(ServletContext sc, String file) {
        this();
        String value = this.getXMLFileAsString(sc.getResourceAsStream(file));
        this.setDocument(value);
    }

    public CCPageTitleModel(InputStream is) {
        this();
        this.setDocument(is);
    }

    public void setDocument(InputStream is) {
        super.setDocument(is);
        this.createChildMaps();
    }

    protected void createDocument(InputStream is) throws IllegalArgumentException {
        if (is == null) {
            throw new IllegalArgumentException("Invalid parameter: The InputStream is null in CCPageTitleModel.");
        }
        super.createDocument(is);
    }

    private void createChildMaps() {
        Document document = this.getDocument();
        if (document == null) {
            return;
        }
        this.parseNodeList(document.getElementsByTagName("pagebuttons"), this.childMap);
        this.parseNodeList(document.getElementsByTagName("pageactions"), this.childMap);
        this.parseNodeList(document.getElementsByTagName("pageviews"), this.childMap);
    }

    private void parseNodeList(NodeList nodeList, HashMap map) {
        if (nodeList == null) {
            CCDebug.trace1("NodeList parameter is null in CCPageTitleModel.parseNodeList().");
            return;
        }
        int nodeListLength = nodeList.getLength();
        for (int i = 0; i < nodeListLength; ++i) {
            Node node = nodeList.item(i);
            if (node.hasChildNodes()) {
                this.parseNodeList(node.getChildNodes(), map);
            }
            if (!node.hasAttributes()) continue;
            NamedNodeMap nodeAttrs = node.getAttributes();
            Node nameNode = nodeAttrs.getNamedItem("name");
            Node tagclassNode = nodeAttrs.getNamedItem("tagclass");
            if (nameNode == null) continue;
            String nodeName = node.getNodeName();
            String name = nameNode.getNodeValue();
            if (!nodeName.equals("cc")) continue;
            map.put(name, tagclassNode.getNodeValue());
        }
    }

    protected void setChildMapValue(String name, String tagclass, HashMap map) {
        if (name == null) {
            CCDebug.trace1("name parameter is null.");
            return;
        }
        if (tagclass == null) {
            CCDebug.trace1("tagclass parameter is null.");
            return;
        }
        if (tagclass.equals("com.sun.web.ui.taglib.html.CCButtonTag")) {
            map.put(name, CCButton.class);
        } else if (tagclass.equals("com.sun.web.ui.taglib.html.CCDropDownMenuTag")) {
            map.put(name, CCDropDownMenu.class);
        } else if (tagclass.equals("com.sun.web.ui.taglib.html.CCStaticTextFieldTag")) {
            map.put(name, CCStaticTextField.class);
        } else {
            CCDebug.trace1("Unknown tag class: " + tagclass);
        }
    }

    public void registerChildren(ContainerViewBase view) {
        Iterator i = this.childMap.keySet().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            try {
                super.registerChildren(view, name, (String)this.childMap.get(name));
            }
            catch (IllegalArgumentException e) {
                CCDebug.trace1("Cannot register tag class: " + name);
            }
        }
    }

    public View createChild(View parent, String name) {
        String tagclass = (String)this.childMap.get(name);
        return super.createChild(parent, this, name, tagclass);
    }

    public boolean isChildSupported(String name) {
        boolean supported = this.childMap.containsKey(name);
        if (supported) {
            return true;
        }
        return super.isChildSupported(name);
    }

    public String getPageTitleText() {
        return this.pageTitleText;
    }

    public void setPageTitleText(String value) {
        this.pageTitleText = value;
    }

    public String getAlertIconType() {
        return this.alertIconType;
    }

    public void setAlertIconType(String value) {
        this.alertIconType = value;
    }

    public String getPageTitleHelpMessage() {
        return this.pageTitleHelpMessage;
    }

    public void setPageTitleHelpMessage(String value) {
        this.pageTitleHelpMessage = value;
    }

    public Boolean getShowPageTitleSeparator() {
        return this.showPageTitleSeparator;
    }

    public void setShowPageTitleSeparator(boolean value) {
        this.showPageTitleSeparator = new Boolean(value);
    }

    public Boolean getShowPageButtonsTop() {
        return this.showPageButtonsTop;
    }

    public void setShowPageButtonsTop(boolean value) {
        this.showPageButtonsTop = new Boolean(value);
    }

    public Boolean getShowPageButtonsBottom() {
        return this.showPageButtonsBottom;
    }

    public void setShowPageButtonsBottom(boolean value) {
        this.showPageButtonsBottom = new Boolean(value);
    }

    public Boolean getShowPageBottomSpacer() {
        return this.showPageBottomSpacer;
    }

    public void setShowPageBottomSpacer(boolean value) {
        this.showPageBottomSpacer = new Boolean(value);
    }
}

