/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.model;

import com.iplanet.jato.RequestCompletionListener;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestParticipant;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.Model;
import com.iplanet.jato.model.ValidationException;
import com.iplanet.jato.util.ClassUtil;
import com.iplanet.jato.view.View;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.model.CCWizardModelInterface;
import com.sun.web.ui.model.WizardInterfaceExtImpl;
import com.sun.web.ui.model.wizard.WizardCache;
import com.sun.web.ui.model.wizard.WizardEvent;
import com.sun.web.ui.model.wizard.WizardInterface;
import com.sun.web.ui.model.wizard.WizardInterfaceExt;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.EmptyStackException;
import java.util.Map;
import java.util.Stack;
import javax.servlet.http.HttpServletRequest;

public class CCWizardModel
extends DefaultModel
implements CCWizardModelInterface,
RequestParticipant,
RequestCompletionListener {
    DefaultModel wizardModel = new DefaultModel();
    private final String WIZARD_NAME = this.getQualifiedName("wizName");
    private final String HTTP_GET = "get";
    private WizardInterface wizard;
    private WizardState wizardState;
    private transient WizardInterfaceExt wizardExt;
    private transient RequestContext requestContext;

    public String initialize(String wizardName) {
        if (wizardName == null) {
            if (this.wizardState != null) {
                return this.wizardState.id;
            }
            throw new IllegalArgumentException(CCDebug.getClassMethod(0) + " : wizardState is null cannot continue.\n" + "Check the request parameters on the " + "initial GET request");
        }
        return this.createWizard(wizardName, null);
    }

    protected String createWizard(String wizardName, String wizardClass) {
        Object obj = WizardCache.get(wizardName);
        if (obj == null) {
            if (wizardClass == null) {
                throw new IllegalArgumentException("Cannot create a wizard without the wizClassName request parameter.");
            }
            this.wizard = this.getWizardFromFactory(wizardName, wizardClass);
            WizardCache.put(wizardName, this.wizard);
            this.wizardExt = this.wizard instanceof WizardInterfaceExt ? (WizardInterfaceExt)((Object)this.wizard) : new WizardInterfaceExtImpl();
            this.wizardState = new WizardState(this.wizard, this.wizardExt, wizardName, WizardCache.getId(wizardName + "_"));
            this.wizardState.name = wizardName;
            WizardCache.put(this.wizardState.id, this.wizardState);
        } else if (obj instanceof WizardInterface) {
            this.wizard = (WizardInterface)obj;
            this.wizardExt = this.wizard instanceof WizardInterfaceExt ? (WizardInterfaceExt)((Object)this.wizard) : new WizardInterfaceExtImpl();
            this.wizardState = new WizardState(this.wizard, this.wizardExt, wizardName, WizardCache.getId(wizardName + "_"));
            WizardCache.put(this.wizardState.id, this.wizardState);
        } else if (obj instanceof WizardState) {
            this.wizardState = (WizardState)obj;
            this.wizard = this.wizardState.wizard;
            this.wizardExt = this.wizard instanceof WizardInterfaceExt ? (WizardInterfaceExt)((Object)this.wizard) : new WizardInterfaceExtImpl();
        }
        return this.wizardState.id;
    }

    public String dumpState() {
        return this.wizardState.toString();
    }

    public void setRequestContext(RequestContext requestContext) {
        this.requestContext = requestContext;
        String wizardName = this.getParameter("wizName", requestContext);
        String wizardClassName = this.getParameter("wizClassName", requestContext);
        if (wizardName != null && wizardClassName != null) {
            this.createWizard(wizardName, wizardClassName);
        }
    }

    private WizardInterface getWizardFromFactory(String wizardName, String factoryClass) {
        WizardInterface w = null;
        Object exceptionMsg = null;
        try {
            Class wizardFactoryClass = ClassUtil.getClass((String)factoryClass);
            Method create = wizardFactoryClass.getMethod("create", RequestContext.class);
            Object[] args = new Object[]{this.requestContext};
            w = (WizardInterface)create.invoke(null, args);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.throwIllegalArgumentException(e, "Failed to create WizardInterface \"" + wizardName + "\" instance from " + " " + factoryClass);
        }
        if (w == null) {
            this.throwIllegalArgumentException(null, "Failed to create WizardInterface \"" + wizardName + "\" instance from " + " " + factoryClass);
        }
        return w;
    }

    private void throwIllegalArgumentException(Exception e, String dbgmsg) {
        Throwable te;
        String msg = null;
        if (e != null && (te = e.getCause()) != null) {
            msg = te.getMessage();
        }
        msg = msg == null ? dbgmsg : msg + "\n" + dbgmsg;
        throw new IllegalArgumentException(msg);
    }

    public void requestComplete() {
        if (this.wizardState.isDone()) {
            WizardCache.remove(this.wizardState.id);
            if (this.wizard.done(this.wizardState.name)) {
                WizardCache.remove(this.wizardState.name);
            }
        }
    }

    public boolean nextRequest(View view) {
        WizardEvent we = new WizardEvent(this.requestContext, view, this.wizardState.currentPageId, null, this.wizardState.name);
        we.setEvent("NEXT");
        boolean success = this.wizard.nextStep(we);
        if (success) {
            this.wizardState.nextRequest();
        }
        this.processEvent(success, we, "errorPrompt");
        return success;
    }

    public boolean previousRequest(View view) {
        WizardEvent we = new WizardEvent(this.requestContext, view, this.wizardState.currentPageId, null, this.wizardState.name);
        we.setEvent("PREVIOUS");
        boolean success = this.wizard.previousStep(we);
        if (success) {
            this.wizardState.previousRequest();
        }
        this.processEvent(success, we, "errorPrompt");
        return success;
    }

    public boolean cancelRequest(View view) {
        WizardEvent we = new WizardEvent(this.requestContext, view, this.wizardState.currentPageId, null, this.wizardState.name);
        we.setEvent("CANCEL");
        boolean success = this.wizard.cancelStep(we);
        if (success) {
            this.wizardState.cancelRequest();
        }
        return success;
    }

    public boolean finishRequest(View view) {
        WizardEvent we = new WizardEvent(this.requestContext, view, this.wizardState.currentPageId, null, this.wizardState.name);
        we.setEvent("FINISH");
        boolean success = this.wizard.finishStep(we);
        if (success) {
            this.wizardState.finishRequest();
        }
        this.processEvent(success, we, "errorPrompt");
        return success;
    }

    public void closeRequest(View view) {
        WizardEvent we = new WizardEvent(this.requestContext, view, this.wizardState.currentPageId, null, this.wizardState.name);
        we.setEvent("CLOSE");
        this.wizardExt.closeStep(we);
        this.wizardState.closeRequest();
        this.processEvent(true, we, "errorPrompt");
    }

    public boolean gotoRequest(View view) {
        String gotoPageId = (String)this.getValue("pagingHref");
        WizardEvent we = new WizardEvent(this.requestContext, view, this.wizardState.currentPageId, gotoPageId, this.wizardState.name);
        we.setEvent("GOTO");
        boolean success = this.wizard.gotoStep(we);
        if (success) {
            this.wizardState.gotoRequest(gotoPageId);
        }
        this.processEvent(success, we, "errorPrompt");
        return success;
    }

    public boolean helpRequest(View view) {
        WizardEvent we = new WizardEvent(this.requestContext, view, this.wizardState.currentPageId, null, this.wizardState.name);
        we.setEvent("HELP");
        boolean success = this.wizardExt.helpTab(we);
        if (success) {
            this.wizardState.activeTab = 1;
        }
        this.processEvent(success, we, "errorPrompt");
        return success;
    }

    public boolean stepRequest(View view) {
        WizardEvent we = new WizardEvent(this.requestContext, view, this.wizardState.currentPageId, null, this.wizardState.name);
        we.setEvent("STEP");
        boolean success = this.wizardExt.stepTab(we);
        if (success) {
            this.wizardState.activeTab = 0;
        }
        this.processEvent(success, we, "errorPrompt");
        return success;
    }

    private void processEvent(boolean success, WizardEvent we, String prompt) {
        if (success) {
            this.setValue(prompt, null);
            return;
        }
        Object[] promptValue = new Object[]{new Integer(we.getSeverity()), we.getErrorMessage()};
        this.setValue(prompt, promptValue);
    }

    public Model getCurrentPageModel() {
        Model model = this.wizard.getPageModel(this.wizardState.currentPageId);
        if (model == null) {
            model = new DefaultModel();
        }
        return model;
    }

    public int getActiveTab() {
        return this.wizardState.activeTab;
    }

    public boolean firstPageSeen() {
        return this.wizardState.firstPageSeen;
    }

    public String[] getVisitedPages() {
        if (this.wizardState.visitedPages.size() == 0) {
            return null;
        }
        Object[] vp = this.wizardState.visitedPages.toArray();
        String[] vpa = new String[vp.length];
        for (int i = 0; i < vp.length; ++i) {
            vpa[i] = (String)vp[i];
        }
        return vpa;
    }

    public String[] getVisitedSteps() {
        Object[] vp = this.wizardState.visitedPages.toArray();
        String[] vsa = new String[vp.length];
        for (int i = 0; i < vp.length; ++i) {
            vsa[i] = this.wizard.getStepText((String)vp[i]);
        }
        return vsa;
    }

    public String getResourceBundle() {
        return this.wizard.getResourceBundle();
    }

    public Class getCurrentPageClass() {
        if (this.wizardState == null || this.wizardState.state == this.wizardState.CMD_LAST) {
            return null;
        }
        return this.wizard.getPageClass(this.wizardState.currentPageId);
    }

    public String getTitle() {
        return this.wizard.getTitle();
    }

    public String getStepTitle() {
        return this.wizard.getStepTitle(this.wizardState.currentPageId);
    }

    public String getStepTitle(String pageId) {
        return this.wizard.getStepTitle(pageId);
    }

    public String[] getFuturePages() {
        return this.wizard.getFuturePages(this.wizardState.currentPageId);
    }

    public String[] getFutureSteps() {
        return this.wizard.getFutureSteps(this.wizardState.currentPageId);
    }

    public String getStepInstruction() {
        return this.wizard.getStepInstruction(this.wizardState.currentPageId);
    }

    public String getStepText() {
        return this.wizard.getStepText(this.wizardState.currentPageId);
    }

    public String[] getStepHelp() {
        return this.wizard.getStepHelp(this.wizardState.currentPageId);
    }

    public String getCancelPrompt() {
        return this.wizard.getCancelPrompt(this.wizardState.currentPageId);
    }

    public String getWizardName() {
        return this.wizardState.id;
    }

    public boolean isFinishPage() {
        return this.wizard.isFinishPageId(this.wizardState.currentPageId);
    }

    public boolean hasPreviousPage() {
        return this.wizard.hasPreviousPageId(this.wizardState.currentPageId);
    }

    public boolean isSubstep(String pageId) {
        return this.wizardExt.isSubstep(pageId);
    }

    public String getCurrentPageId() {
        return this.wizardState.currentPageId;
    }

    public String getPlaceholderText(String pageId) {
        return this.wizardExt.getPlaceholderText(pageId);
    }

    public boolean isResultsPage() {
        return this.wizardState.state == this.wizardState.CMD_FINISH;
    }

    public boolean canBeStepLink(String pageId) {
        return !this.isResultsPage() && this.wizardExt.canBeStepLink(pageId);
    }

    private Object getWizardValue(String name) {
        if (name.equals(this.WIZARD_NAME)) {
            return this.wizardState.id;
        }
        if (name.equals("visitedPages")) {
            return this.getVisitedPages();
        }
        if (name.equals("visitedSteps")) {
            return this.getVisitedSteps();
        }
        if (name.equals("futureSteps")) {
            return this.getFutureSteps();
        }
        if (name.equals("currentStep")) {
            return this.getStepText();
        }
        if (name.equals("wizardTitle")) {
            return this.getTitle();
        }
        if (name.equals("stepTitle")) {
            return this.getStepTitle();
        }
        if (name.equals("stepInstruction")) {
            return this.getStepInstruction();
        }
        if (name.equals("stepHelp")) {
            return this.getStepHelp();
        }
        if (name.equals("cancelPrompt")) {
            return this.getCancelPrompt();
        }
        return this.wizardModel.getValue(name);
    }

    private Object[] getWizardValues(String name) {
        if (name.equals(this.WIZARD_NAME)) {
            return new Object[]{this.wizardState.id};
        }
        if (name.equals("visitedPages")) {
            return this.getVisitedPages();
        }
        if (name.equals("visitedSteps")) {
            return this.getVisitedSteps();
        }
        if (name.equals("futureSteps")) {
            return this.getFutureSteps();
        }
        if (name.equals("currentStep")) {
            return new Object[]{this.getStepText()};
        }
        if (name.equals("wizardTitle")) {
            return new Object[]{this.getTitle()};
        }
        if (name.equals("stepTitle")) {
            return new Object[]{this.getStepTitle()};
        }
        if (name.equals("stepInstruction")) {
            return new Object[]{this.getStepInstruction()};
        }
        if (name.equals("stepHelp")) {
            return new Object[]{this.getStepHelp()};
        }
        if (name.equals("cancelPrompt")) {
            return new Object[]{this.getCancelPrompt()};
        }
        return this.wizardModel.getValues(name);
    }

    public Object getValue(String arg0) {
        Object obj = this.getWizardValue(arg0);
        return obj;
    }

    public Object[] getValues(String arg0) {
        Object[] obj = this.getWizardValues(arg0);
        return obj;
    }

    public void setValue(String arg0, Object arg1) throws ValidationException {
        this.wizardModel.setValue(arg0, arg1);
    }

    public void setValues(String arg0, Object[] arg1) throws ValidationException {
        this.wizardModel.setValues(arg0, arg1);
    }

    public String getFirstPageId() {
        return this.wizard.getFirstPageId();
    }

    private String getParameter(String name, RequestContext cntxt) {
        HttpServletRequest hrq = this.requestContext.getRequest();
        Map parameterMap = this.requestContext.getRequest().getParameterMap();
        String[] values = (String[])parameterMap.get(this.getQualifiedName(name));
        return values == null ? null : values[0];
    }

    private String getQualifiedName(String name) {
        return "WizardWindow." + name;
    }

    class WizardState
    implements Serializable {
        static final long serialVersionUID = 4439992595001302854L;
        final int CMD_FIRST = 0;
        final int CMD_PREVIOUS = 1;
        final int CMD_NEXT = 2;
        final int CMD_LAST = 3;
        final int CMD_HELP = 4;
        final int CMD_STEPS = 5;
        final int CMD_PAGE = 6;
        final int CMD_WAIT = 7;
        final int CMD_ERROR = 8;
        final int CMD_CANCEL = 9;
        final int CMD_FINISH = 10;
        WizardInterface wizard;
        String id;
        String name;
        String currentPageId;
        int state;
        Stack visitedPages;
        int activeTab;
        boolean firstPageSeen;

        public WizardState(WizardInterface wizard, WizardInterfaceExt wizardExt, String wizardName, String id) {
            this.wizard = wizard;
            this.id = id;
            this.name = wizardName;
            this.visitedPages = new Stack();
            this.activeTab = 0;
            this.state = 0;
            this.currentPageId = wizard.getFirstPageId();
            this.firstPageSeen = false;
        }

        public boolean isDone() {
            return this.state == 3 || this.state == 9;
        }

        public void nextRequest() {
            this.firstPageSeen = true;
            this.state = 2;
            this.visitedPages.push(this.currentPageId);
            this.currentPageId = this.wizard.getNextPageId(this.currentPageId);
        }

        public void previousRequest() {
            this.state = 1;
            try {
                this.currentPageId = (String)this.visitedPages.pop();
            }
            catch (EmptyStackException e) {
                CCDebug.trace1("The application wizard returned success for previousStep but there is no previous page.");
            }
        }

        public void cancelRequest() {
            this.state = 9;
        }

        public void finishRequest() {
            String resultsPageId = CCWizardModel.this.wizardExt.getResultsPageId(this.currentPageId);
            if (resultsPageId != null) {
                this.state = 10;
                this.visitedPages.push(this.currentPageId);
                this.currentPageId = resultsPageId;
            } else {
                this.state = 3;
            }
        }

        public void closeRequest() {
            this.state = 3;
        }

        public void gotoRequest(String gotoPage) {
            this.state = 6;
            try {
                while (!((String)this.visitedPages.pop()).equals(gotoPage)) {
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException(CCDebug.getClassMethod(0) + " : page " + gotoPage + " has not been seen.");
            }
            this.currentPageId = gotoPage;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("wizard = ").append(this.wizard).append("\nid = ").append(this.id).append("\nname = ").append(this.name).append("\nvisitedPages = ").append(this.visitedPages).append("\nactiveTab = ").append(this.activeTab).append("\ncurrentPageId = ").append(this.currentPageId).append("\nstate = ").append(this.state);
            return sb.toString();
        }

        private void debugout(String s) {
            System.out.println("\n** " + CCDebug.getClassMethod(1) + " : " + s + " **\n");
        }
    }
}

