/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.model;

import com.sun.web.ui.model.CCTopologyGroupNode;
import com.sun.web.ui.model.CCTopologyModelInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class TierNodeFactory {
    private int globalConnectionIndex = 0;
    private Map nodeInfoMap;
    private ArrayList[] tierInfosList = new ArrayList[]{new ArrayList(), new ArrayList(), new ArrayList()};
    private int tierIndex;

    TierNodeFactory() {
        this.nodeInfoMap = new HashMap();
    }

    CCTopologyModelInterface.Node[][] getTierNodes(CCTopologyModelInterface.Node[][] nodes, int tierCount, int primaryTier, CCTopologyModelInterface.Edge[] edges, boolean allowNestedGrouping, int maxNodesPerGroup) {
        Bucket[] topBuckets = this.getTopBuckets(nodes, tierCount, primaryTier, edges, allowNestedGrouping, maxNodesPerGroup);
        ArrayList<CCTopologyModelInterface.Node> groupNodes = new ArrayList<CCTopologyModelInterface.Node>();
        CCTopologyModelInterface.Node[][] tierNodes = new CCTopologyModelInterface.Node[topBuckets.length][];
        for (int t = 0; t < tierNodes.length; ++t) {
            CCTopologyModelInterface.GroupNode groupNode = topBuckets[t].createGroupNode(true);
            groupNodes.add(groupNode);
            tierNodes[t] = groupNode.getNodes();
        }
        while (groupNodes.size() > 0) {
            CCTopologyGroupNode groupNode = (CCTopologyGroupNode)groupNodes.remove(0);
            groupNode.setLabel(this.shortenGroupLabel(groupNode.getLabel()));
            CCTopologyModelInterface.Node[] shortNodes = groupNode.getNodes();
            for (int n = 0; n < shortNodes.length; ++n) {
                if (!(shortNodes[n] instanceof CCTopologyGroupNode)) continue;
                groupNodes.add(shortNodes[n]);
            }
        }
        return tierNodes;
    }

    Bucket[] getTopBuckets(CCTopologyModelInterface.Node[][] tierNodes, int tierCount, int primaryTier, CCTopologyModelInterface.Edge[] edges, boolean allowNestedGrouping, int maxNodesPerGroup) {
        int pb;
        primaryTier = Math.min(primaryTier, tierCount - 1);
        int[] tiers = new int[tierCount];
        int t = 0;
        int i = primaryTier;
        while (i < tierCount) {
            tiers[t++] = i++;
        }
        i = primaryTier - 1;
        while (i >= 0) {
            tiers[t++] = i--;
        }
        NodeInfo[][] tierInfos = this.createNodeInfos(tierNodes, edges);
        Bucket[] topBuckets = new Bucket[tiers.length];
        for (t = 0; t < tierCount; ++t) {
            topBuckets[t] = new Bucket(t, tierInfos[t]);
            topBuckets[t].isTop = true;
        }
        if (tierInfos[primaryTier].length > 0) {
            topBuckets[primaryTier].organizeByWithinTierConnectivity();
        }
        List primaryBuckets = topBuckets[primaryTier].bucketList;
        for (pb = 0; pb < primaryBuckets.size(); ++pb) {
            ((Bucket)primaryBuckets.get(pb)).organizeByConnectivity();
        }
        for (t = 1; t < tiers.length; ++t) {
            topBuckets[tiers[t]].organizeByConnectivity();
        }
        for (t = 1; t < tiers.length; ++t) {
            topBuckets[tiers[t]].flatten(allowNestedGrouping, maxNodesPerGroup);
        }
        if (allowNestedGrouping && topBuckets[primaryTier].getTotalNodeCount() > maxNodesPerGroup) {
            for (pb = 0; pb < primaryBuckets.size(); ++pb) {
                ((Bucket)primaryBuckets.get(pb)).flatten(allowNestedGrouping, maxNodesPerGroup);
            }
        } else {
            topBuckets[primaryTier].flatten(allowNestedGrouping, maxNodesPerGroup);
        }
        for (t = 0; t < tiers.length; ++t) {
            topBuckets[t].removeEmptyBuckets();
        }
        return topBuckets;
    }

    NodeInfo[][] createNodeInfos(CCTopologyModelInterface.Node[][] tierNodes, CCTopologyModelInterface.Edge[] edges) {
        NodeInfo[][] tierInfos = new NodeInfo[tierNodes.length][];
        for (int t = 0; t < tierNodes.length; ++t) {
            tierInfos[t] = new NodeInfo[tierNodes[t].length];
            for (int n = 0; n < tierNodes[t].length; ++n) {
                tierInfos[t][n] = this.createNodeInfo(tierNodes[t][n], t);
            }
        }
        for (int e = 0; e < edges.length; ++e) {
            CCTopologyModelInterface.Node destination;
            CCTopologyModelInterface.Node source = edges[e].getSource();
            if (source == (destination = edges[e].getDestination())) continue;
            NodeInfo sourceInfo = this.getNodeInfo(source);
            NodeInfo destinationInfo = this.getNodeInfo(destination);
            if (sourceInfo == null || destinationInfo == null) continue;
            sourceInfo.peerList.add(destinationInfo);
            destinationInfo.peerList.add(sourceInfo);
            sourceInfo.connections.set(destinationInfo.connectionIndex);
            destinationInfo.connections.set(sourceInfo.connectionIndex);
        }
        return tierInfos;
    }

    private int connectionIndex() {
        return this.globalConnectionIndex++;
    }

    public NodeInfo createNodeInfo(CCTopologyModelInterface.Node node, int tier) {
        NodeInfo nodeInfo = new NodeInfo(node, tier, this.connectionIndex());
        this.nodeInfoMap.put(node, nodeInfo);
        this.tierIndex = this.tierInfosList[tier].size();
        this.tierInfosList[tier].add(nodeInfo);
        return nodeInfo;
    }

    public NodeInfo createNodeInfo(Bucket bucket) {
        NodeInfo nodeInfo = new NodeInfo(bucket, this.connectionIndex());
        this.tierIndex = this.tierInfosList[bucket.tier].size();
        this.tierInfosList[bucket.tier].add(this);
        return nodeInfo;
    }

    public NodeInfo getNodeInfo(CCTopologyModelInterface.Node node) {
        return (NodeInfo)this.nodeInfoMap.get(node);
    }

    public List getTierInfos(int tier) {
        return this.tierInfosList[tier];
    }

    protected String[] getLabelParts(String label) {
        if (label == null) {
            label = "null";
        }
        String[] parts = new String[2];
        int sepIndex = label.indexOf("..");
        if (sepIndex == -1) {
            parts[0] = parts[1] = label;
        } else {
            parts[0] = label.substring(0, sepIndex);
            parts[1] = label.substring(sepIndex + "..".length());
        }
        return parts;
    }

    private String shortenGroupLabel(String groupLabel) {
        int z;
        int a;
        String last;
        String[] parts = this.getLabelParts(groupLabel);
        String first = parts[0];
        if (first.equals(last = parts[1])) {
            return groupLabel;
        }
        for (a = 0; a < first.length() && a < last.length() && first.charAt(a) == last.charAt(a); ++a) {
        }
        while (a > 0 && Character.isDigit(first.charAt(a - 1))) {
            --a;
        }
        for (z = 0; z < first.length() && z < last.length() && first.charAt(first.length() - 1 - z) == last.charAt(last.length() - 1 - z); ++z) {
        }
        while (z > 0 && Character.isDigit(first.charAt(first.length() - z))) {
            --z;
        }
        if (z > a) {
            first = first.substring(0, first.length() - z);
        } else if (a > 0) {
            last = last.substring(a);
        }
        if (a > 0 || z > 0) {
            return first + "-" + last;
        }
        return groupLabel;
    }

    private final class Bucket {
        public List bucketList = new ArrayList();
        public List nodeList = new ArrayList();
        public int tier;
        public boolean isTop;
        public NodeInfo info;
        private int totalNodeCount = -1;
        public int distance = Integer.MAX_VALUE;

        public String getCompareLabel() {
            return this.nodeList.size() > 0 ? ((NodeInfo)this.nodeList.get((int)0)).node.getLabel() : (this.bucketList.size() == 0 ? "zyz" : ((Bucket)this.bucketList.get(0)).getCompareLabel());
        }

        public Bucket(int tier) {
            this.tier = tier;
            this.info = TierNodeFactory.this.createNodeInfo(this);
        }

        public Bucket(int tier, NodeInfo[] nodes) {
            this(tier);
            for (int n = 0; n < nodes.length; ++n) {
                this.privateAddNode(nodes[n]);
            }
        }

        public void addBucketChildren(Bucket bucket) {
            int n;
            for (n = 0; n < bucket.nodeList.size(); ++n) {
                this.privateAddNode((NodeInfo)bucket.nodeList.get(n));
            }
            bucket.nodeList.clear();
            for (n = 0; n < bucket.bucketList.size(); ++n) {
                this.privateAddBucket((Bucket)bucket.bucketList.get(n));
            }
            bucket.bucketList.clear();
        }

        public void addNode(NodeInfo node) {
            Bucket previousBucket = this.getBucket(node);
            if (previousBucket != null) {
                previousBucket.nodeList.remove(node);
            }
            this.privateAddNode(node);
            this.info.connections.or(node.connections);
        }

        private void privateAddNode(NodeInfo node) {
            this.nodeList.add(node);
            node.parent = this;
        }

        public void addBucket(Bucket bucket) {
            Bucket previousBucket = this.getBucket(bucket);
            if (previousBucket != null) {
                previousBucket.removeBucket(bucket);
            }
            this.privateAddBucket(bucket);
            this.info.connections.or(bucket.info.connections);
        }

        public void removeBucket(Bucket bucket) {
            this.bucketList.remove(bucket);
            bucket.info.parent = null;
        }

        public void privateAddBucket(Bucket bucket) {
            this.bucketList.add(bucket);
            bucket.info.parent = this;
        }

        public void add(NodeInfo nodeOrBucket) {
            if (nodeOrBucket.bucket != null) {
                this.addBucket(nodeOrBucket.bucket);
            } else {
                this.addNode(nodeOrBucket);
                for (int p = 0; p < nodeOrBucket.peerList.size(); ++p) {
                    ((NodeInfo)nodeOrBucket.peerList.get((int)p)).connections.set(this.info.connectionIndex);
                }
            }
        }

        public void addBucketNodes(Bucket otherBucket) {
            for (int i = 0; i < otherBucket.nodeList.size(); ++i) {
                NodeInfo node = (NodeInfo)otherBucket.nodeList.get(i);
                this.privateAddNode(node);
                this.info.connections.or(node.connections);
            }
            otherBucket.nodeList.clear();
        }

        public CCTopologyModelInterface.GroupNode createGroupNode(boolean isTopBucket) {
            CCTopologyModelInterface.Node[] nodes = new CCTopologyModelInterface.Node[this.nodeList.size() + this.bucketList.size()];
            int i = 0;
            for (int b = 0; b < this.bucketList.size(); ++b) {
                nodes[i++] = ((Bucket)this.bucketList.get(b)).createGroupNode(false);
            }
            for (int n = 0; n < this.nodeList.size(); ++n) {
                nodes[i++] = ((NodeInfo)this.nodeList.get((int)n)).node;
            }
            Arrays.sort(nodes, new Comparator(){

                public int compare(Object o1, Object o2) {
                    try {
                        return ((CCTopologyModelInterface.Node)o1).getLabel().compareTo(((CCTopologyModelInterface.Node)o2).getLabel());
                    }
                    catch (Exception e) {
                        return (o2 == null ? 0 : o2.hashCode()) - (o1 == null ? 0 : o1.hashCode());
                    }
                }
            });
            String label = isTopBucket ? String.valueOf(this.hashCode()) : this.createGroupLabel(nodes);
            String id = isTopBucket ? label : label + this.hashCode();
            return new CCTopologyGroupNode(id, label, nodes);
        }

        private void organizeByWithinTierConnectivity() {
            Bucket peerBucket;
            Bucket[] unconnectedBuckets = new Bucket[3];
            for (int t = 0; t < 3; ++t) {
                unconnectedBuckets[t] = new Bucket(this.tier);
                this.addBucket(unconnectedBuckets[t]);
            }
            block1: while (this.nodeList.size() > 0) {
                int t;
                NodeInfo node = (NodeInfo)this.nodeList.get(0);
                if (node.peerList.size() == 0) {
                    unconnectedBuckets[this.tier].addNode(node);
                    continue;
                }
                boolean[] peerTiers = new boolean[3];
                Bucket firstBucket = null;
                for (int p = 0; p < node.peerList.size(); ++p) {
                    NodeInfo peer = (NodeInfo)node.peerList.get(p);
                    peerBucket = this.getBucket(peer);
                    if (peerBucket.tier == this.tier) {
                        if (firstBucket == null) {
                            if (peerBucket == this) {
                                firstBucket = new Bucket(this.tier);
                                this.addBucket(firstBucket);
                                firstBucket.add(node);
                                firstBucket.add(peer);
                                continue;
                            }
                            firstBucket = peerBucket;
                            firstBucket.add(node);
                            continue;
                        }
                        if (firstBucket == peerBucket) continue;
                        if (peerBucket == this) {
                            firstBucket.addNode(peer);
                            continue;
                        }
                        firstBucket.addBucketNodes(peerBucket);
                        this.removeBucket(peerBucket);
                        continue;
                    }
                    peerTiers[peerBucket.tier] = true;
                }
                if (firstBucket != null) continue;
                int connectedTiers = 0;
                for (t = 0; t < 3; ++t) {
                    if (!peerTiers[t]) continue;
                    ++connectedTiers;
                }
                if (connectedTiers > 1) {
                    Bucket newBucket = new Bucket(this.tier);
                    newBucket.add(node);
                    this.privateAddBucket(newBucket);
                    continue;
                }
                if (connectedTiers == 1) {
                    for (t = 0; t < 3; ++t) {
                        if (!peerTiers[t]) continue;
                        unconnectedBuckets[t].add(node);
                        continue block1;
                    }
                    continue;
                }
                unconnectedBuckets[this.tier].add(node);
            }
            for (int ub = 0; ub < unconnectedBuckets.length; ++ub) {
                List unconnectedNodes = unconnectedBuckets[ub].nodeList;
                block6: for (int un = 0; un < unconnectedNodes.size(); ++un) {
                    NodeInfo node = (NodeInfo)unconnectedNodes.get(un);
                    for (int p = 0; p < this.info.peerList.size(); ++p) {
                        peerBucket = this.getBucket((NodeInfo)this.info.peerList.get(p));
                        if (peerBucket.tier != this.tier) continue;
                        peerBucket.addNode(this.info);
                        continue block6;
                    }
                }
            }
        }

        public void organizeByConnectivity() {
            while (this.nodeList.size() + this.bucketList.size() > 2) {
                int i;
                NodeInfo[] infos = this.calculateDistances();
                int shortestDistance = Integer.MAX_VALUE;
                for (i = 0; i < infos.length; ++i) {
                    shortestDistance = Math.min(shortestDistance, infos[i].closestDistance);
                }
                for (i = 0; i < infos.length; ++i) {
                    if (infos[i].closestDistance != shortestDistance) continue;
                    Bucket closestNodeBucket = this.getBucket(infos[i].closestNode);
                    if (closestNodeBucket != this) {
                        closestNodeBucket.add(infos[i]);
                        closestNodeBucket.distance = shortestDistance;
                        continue;
                    }
                    Bucket newBucket = new Bucket(this.tier);
                    newBucket.add(infos[i]);
                    newBucket.add(infos[i].closestNode);
                    this.privateAddBucket(newBucket);
                    this.distance = shortestDistance;
                }
            }
        }

        public NodeInfo[] calculateDistances() {
            NodeInfo[] infos = new NodeInfo[this.nodeList.size() + this.bucketList.size()];
            for (int n = 0; n < this.nodeList.size(); ++n) {
                infos[n] = (NodeInfo)this.nodeList.get(n);
            }
            for (int b = 0; b < this.bucketList.size(); ++b) {
                infos[n + b] = ((Bucket)this.bucketList.get((int)b)).info;
            }
            for (int n1 = 0; n1 < infos.length; ++n1) {
                NodeInfo info1 = infos[n1];
                info1.closestDistance = Integer.MAX_VALUE;
                for (int n2 = 0; n2 < n1; ++n2) {
                    NodeInfo info2 = infos[n2];
                    BitSet comparison = (BitSet)info1.connections.clone();
                    comparison.xor(info2.connections);
                    int distance = comparison.cardinality();
                    info1.setDistance(n2, distance);
                    if (distance >= info1.closestDistance) continue;
                    info1.closestDistance = distance;
                    info1.closestNode = info2;
                }
            }
            return infos;
        }

        public void flatten(boolean allowNestedGrouping, int maxNodesPerGroup) {
            int maxGroups = allowNestedGrouping ? maxNodesPerGroup : Integer.MAX_VALUE;
            int count = this.getTotalNodeCount();
            if (count <= maxNodesPerGroup) {
                while (this.bucketList.size() > 0) {
                    this.addBucketChildren((Bucket)this.bucketList.remove(0));
                }
                return;
            }
            int grandChildrenCount = this.nodeList.size();
            for (int b = 0; b < this.bucketList.size(); ++b) {
                Bucket childBucket = (Bucket)this.bucketList.get(b);
                childBucket.flatten(allowNestedGrouping, maxNodesPerGroup);
                grandChildrenCount += childBucket.nodeList.size() + childBucket.bucketList.size();
            }
            if (grandChildrenCount <= maxNodesPerGroup) {
                ArrayList children = new ArrayList(this.bucketList);
                this.bucketList.clear();
                while (children.size() > 0) {
                    this.addBucketChildren((Bucket)children.remove(0));
                }
                return;
            }
            int childCount = this.nodeList.size() + this.bucketList.size();
            if (allowNestedGrouping ? childCount > maxNodesPerGroup : this.nodeList.size() > maxNodesPerGroup) {
                int nodeCount = this.nodeList.size();
                int numSubGroups = 1 + (nodeCount - 1) / maxNodesPerGroup;
                if (numSubGroups + this.bucketList.size() <= maxGroups) {
                    int subGroupSize = 1 + (nodeCount - 1) / numSubGroups;
                    Collections.sort(this.nodeList);
                    int n = 0;
                    for (int g = 0; g < numSubGroups; ++g) {
                        Bucket newBucket = new Bucket(this.tier);
                        this.privateAddBucket(newBucket);
                        int maxN = (g + 1) * subGroupSize;
                        while (n < maxN && n < this.nodeList.size()) {
                            newBucket.privateAddNode((NodeInfo)this.nodeList.get(n));
                            ++n;
                        }
                    }
                    this.nodeList.clear();
                } else {
                    ArrayList<NodeInfo> children = new ArrayList<NodeInfo>();
                    children.addAll(this.nodeList);
                    for (int b = 0; b < this.bucketList.size(); ++b) {
                        children.add(((Bucket)this.bucketList.get((int)b)).info);
                    }
                    Collections.sort(children);
                    this.nodeList.clear();
                    this.bucketList.clear();
                    numSubGroups = 1 + (childCount - 1) / maxNodesPerGroup;
                    int subGroupSize = 1 + (childCount - 1) / numSubGroups;
                    while (allowNestedGrouping && subGroupSize > maxNodesPerGroup) {
                        numSubGroups = 1 + (subGroupSize - 1) / maxNodesPerGroup;
                        subGroupSize = 1 + (subGroupSize - 1) / numSubGroups;
                    }
                    subGroupSize = 1 + (childCount - 1) / numSubGroups;
                    int n = 0;
                    for (int g = 0; g < numSubGroups; ++g) {
                        Bucket newBucket = new Bucket(this.tier);
                        this.privateAddBucket(newBucket);
                        int maxN = (g + 1) * subGroupSize;
                        while (n < maxN && n < children.size()) {
                            NodeInfo child = (NodeInfo)children.get(n);
                            if (child.node != null) {
                                newBucket.privateAddNode(child);
                            } else {
                                newBucket.privateAddBucket(child.bucket);
                            }
                            ++n;
                        }
                        if (subGroupSize <= maxNodesPerGroup) continue;
                        newBucket.flatten(allowNestedGrouping, maxNodesPerGroup);
                    }
                }
            }
            if (!allowNestedGrouping) {
                for (int b = 0; b < this.bucketList.size(); ++b) {
                    Bucket childBucket = (Bucket)this.bucketList.get(b);
                    while (childBucket.bucketList.size() > 0) {
                        this.privateAddBucket((Bucket)childBucket.bucketList.remove(0));
                    }
                }
            }
            boolean moveGrandchildrenAlgorithm = false;
            childCount = this.nodeList.size() + this.bucketList.size();
            int extraSpace = maxNodesPerGroup - childCount;
            if (moveGrandchildrenAlgorithm && (!this.isTop || childCount == 1) && extraSpace > 0) {
                ArrayList grandChildGroups = new ArrayList();
                for (int c = 0; c < this.bucketList.size(); ++c) {
                    grandChildGroups.addAll(((Bucket)this.bucketList.get((int)c)).bucketList);
                }
                Collections.sort(grandChildGroups, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        try {
                            return ((Bucket)o2).distance - ((Bucket)o1).distance;
                        }
                        catch (Exception e) {
                            return (o2 == null ? 0 : o2.hashCode()) - (o1 == null ? 0 : o1.hashCode());
                        }
                    }
                });
                for (int g = 0; g < extraSpace && g < grandChildGroups.size(); ++g) {
                    this.addBucket((Bucket)grandChildGroups.get(g));
                }
            }
        }

        public void removeEmptyBuckets() {
            Iterator iter = this.bucketList.iterator();
            while (iter.hasNext()) {
                Bucket bucket = (Bucket)iter.next();
                bucket.removeEmptyBuckets();
                int nodeCount = bucket.nodeList.size();
                int bucketCount = bucket.bucketList.size();
                if (nodeCount == 0) {
                    if (bucketCount == 0) {
                        iter.remove();
                        continue;
                    }
                    if (bucketCount != 1) continue;
                    Bucket childBucket = (Bucket)bucket.bucketList.remove(0);
                    bucket.addBucketChildren(childBucket);
                    continue;
                }
                if (nodeCount != 1 || bucketCount != 0) continue;
                this.privateAddNode((NodeInfo)bucket.nodeList.get(0));
                iter.remove();
            }
        }

        int getTotalNodeCount() {
            if (this.totalNodeCount == -1) {
                this.totalNodeCount = this.nodeList.size();
                for (int b = 0; b < this.bucketList.size(); ++b) {
                    this.totalNodeCount += ((Bucket)this.bucketList.get(b)).getTotalNodeCount();
                }
            }
            return this.totalNodeCount;
        }

        public Bucket getBucket(NodeInfo node) {
            return node.parent;
        }

        public Bucket getBucket(Bucket bucket) {
            return bucket.info.parent;
        }

        private String createGroupLabel(CCTopologyModelInterface.Node[] nodes) {
            if (nodes == null || nodes.length == 0) {
                return "null";
            }
            Object[] firstLabels = new String[nodes.length];
            Object[] lastLabels = new String[nodes.length];
            for (int n = 0; n < nodes.length; ++n) {
                String[] labelParts = TierNodeFactory.this.getLabelParts(nodes[n].getLabel());
                firstLabels[n] = labelParts[0];
                lastLabels[n] = labelParts[1];
            }
            Arrays.sort(firstLabels);
            Arrays.sort(lastLabels);
            Object firstLabel = firstLabels[0];
            Object lastLabel = lastLabels[lastLabels.length - 1];
            if (((String)firstLabel).equals(lastLabel)) {
                return firstLabel;
            }
            return (String)firstLabel + ".." + (String)lastLabel;
        }
    }

    private class NodeInfo
    implements Comparable {
        public final CCTopologyModelInterface.Node node;
        public final Bucket bucket;
        public Bucket parent;
        public final int connectionIndex;
        public final List peerList = new ArrayList();
        public final BitSet connections = new BitSet(200);
        public int closestDistance;
        public NodeInfo closestNode;
        public int[] nodeDistances = new int[100];

        public String getCompareLabel() {
            return this.node != null ? this.node.getLabel() : (this.bucket != null ? this.bucket.getCompareLabel() : "zyz");
        }

        public int compareTo(Object o) {
            if (!(o instanceof NodeInfo)) {
                return 1;
            }
            return this.getCompareLabel().compareTo(((NodeInfo)o).getCompareLabel());
        }

        public NodeInfo(CCTopologyModelInterface.Node node, int tier, int connectionIndex) {
            this.node = node;
            this.bucket = null;
            this.connectionIndex = connectionIndex;
            Arrays.fill(this.nodeDistances, Integer.MAX_VALUE);
        }

        public NodeInfo(Bucket bucket, int connectionIndex) {
            this.node = null;
            this.bucket = bucket;
            this.connectionIndex = connectionIndex;
        }

        public void clearDistances() {
            Arrays.fill(this.nodeDistances, Integer.MAX_VALUE);
        }

        public void setDistance(int index, int distance) {
            if (index >= this.nodeDistances.length) {
                int[] newArray = new int[this.nodeDistances.length * 2];
                System.arraycopy(this.nodeDistances, 0, newArray, 0, this.nodeDistances.length);
                Arrays.fill(newArray, this.nodeDistances.length, newArray.length, Integer.MAX_VALUE);
                this.nodeDistances = newArray;
            }
            this.nodeDistances[index] = distance;
        }

        public int getDistance(int index) {
            try {
                return this.nodeDistances[index];
            }
            catch (IndexOutOfBoundsException e) {
                return Integer.MAX_VALUE;
            }
        }
    }
}

