/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.servlet.help2;

import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCI18N;
import com.sun.web.ui.common.CCSystem;
import java.beans.Beans;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.IndexItem;
import javax.help.IndexView;
import javax.help.InvalidHelpSetContextException;
import javax.help.Map;
import javax.help.Merge;
import javax.help.NavigatorView;
import javax.help.SearchHit;
import javax.help.SearchTOCItem;
import javax.help.SearchView;
import javax.help.ServletHelpBroker;
import javax.help.TOCItem;
import javax.help.TOCView;
import javax.help.TreeItem;
import javax.help.search.MergingSearchEngine;
import javax.help.search.SearchEvent;
import javax.help.search.SearchItem;
import javax.help.search.SearchListener;
import javax.help.search.SearchQuery;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class Help2Utils
implements SearchListener {
    private ServletHelpBroker helpBroker;
    private TOCView tocView;
    private Enumeration tocTreeEnum;
    private ArrayList tocTreeList;
    private DefaultMutableTreeNode tocTopNode;
    private IndexView indexView;
    private Enumeration indexTreeEnum;
    private ArrayList indexTreeList;
    private DefaultMutableTreeNode indexTopNode;
    private SearchView searchView;
    private MergingSearchEngine helpSearch;
    private SearchQuery searchQuery;
    private Vector searchNodes;
    private Enumeration searchEnum;
    private boolean searchFinished;
    private String appName;
    private String pathPrefix;
    private Locale tagsLocale;
    public static final String BASE_ID = "root";
    protected static final String SECURE_SCHEME = "https";
    protected static final String UNSECURE_SCHEME = "http";
    protected static final String FILE_SCHEME = "file";
    protected static final String HTML_DIR = "html";
    protected static final String HELP_DIR = "help";
    protected static final String DEFAULT_HELPSET_NAME = "app.hs";
    protected static final String TIPS_ON_SEARCHING_FILE = "tips_on_searching.html";

    public Help2Utils(HttpServletRequest request, String appName) {
        CCDebug.initTrace();
        this.appName = appName;
        this.tagsLocale = CCI18N.getTagsLocale((ServletRequest)request);
        this.initHelp(request);
    }

    public Help2Utils(HttpServletRequest request, String appName, String pathPrefix) {
        CCDebug.initTrace();
        this.appName = appName;
        if (pathPrefix != null && pathPrefix.length() != 0 && pathPrefix.trim().length() != 0) {
            this.pathPrefix = pathPrefix.trim();
        }
        this.tagsLocale = CCI18N.getTagsLocale((ServletRequest)request);
        this.initHelp(request);
    }

    public String getTipsOnSearchingPath(ServletContext context) {
        NonSyncStringBuffer buf = new NonSyncStringBuffer("/").append(this.getHelpPath(this.appName)).append("/html/" + this.tagsLocale.toString() + "/" + HELP_DIR + "/" + TIPS_ON_SEARCHING_FILE);
        String resource = this.clean(buf.toString());
        if (context.getResourceAsStream(resource) != null) {
            return resource;
        }
        buf = new NonSyncStringBuffer(CCSystem.getResourceContextPath() + "/" + HTML_DIR + "/" + this.tagsLocale.toString() + "/" + HELP_DIR + "/" + TIPS_ON_SEARCHING_FILE);
        return this.clean(buf.toString());
    }

    private void initHelp(HttpServletRequest request) {
        this.instantiateHelpBroker(request);
        String hsPath = this.getDefaultHelpSetPath(request);
        CCDebug.trace3("hsPath: " + hsPath);
        this.validateHelpSet(request, hsPath, false);
        this.validateID(null);
        this.initNavigatorViews();
    }

    private void instantiateHelpBroker(HttpServletRequest request) {
        try {
            this.helpBroker = (ServletHelpBroker)Beans.instantiate(this.getClass().getClassLoader(), "javax.help.ServletHelpBroker");
        }
        catch (ClassNotFoundException exc) {
            CCDebug.trace1("Cannot instantiate ServletHelpBroker." + exc.getMessage());
        }
        catch (Exception exc) {
            CCDebug.trace1("Cannot create bean of class ServletHelpBroker." + exc.getMessage());
        }
    }

    public ServletHelpBroker getHelpBroker() {
        return this.helpBroker;
    }

    public String getDefaultHelpSetPath(HttpServletRequest request) {
        if (this.appName == null) {
            this.appName = request.getContextPath();
            if (this.appName == null) {
                CCDebug.trace1("Unable to obtain app name from request.");
                this.appName = "";
            } else if (this.appName.startsWith("/")) {
                this.appName = this.appName.substring(1);
            }
        }
        NonSyncStringBuffer buf = new NonSyncStringBuffer("/").append(this.getHelpPath(this.appName)).append("/").append(HTML_DIR).append("/").append(this.tagsLocale.toString()).append("/").append(HELP_DIR).append("/").append(DEFAULT_HELPSET_NAME);
        return this.clean(buf.toString());
    }

    private String getHelpPath(String appName) {
        if (appName == null || appName.length() == 0) {
            return HTML_DIR;
        }
        if (this.pathPrefix == null) {
            return appName;
        }
        if (this.pathPrefix.startsWith("/" + appName + "/")) {
            return this.pathPrefix;
        }
        return appName + "/" + this.pathPrefix;
    }

    private void initNavigatorViews() {
        HelpSet hs = this.helpBroker.getHelpSet();
        Locale locale = hs.getLocale();
        this.tocView = (TOCView)hs.getNavigatorView("TOC");
        if (this.tocView != null) {
            this.tocTopNode = this.tocView.getDataAsTree();
            this.addSubHelpSets(hs);
            this.tocTreeEnum = this.tocTopNode.preorderEnumeration();
            this.setTOCTreeList();
        }
        this.indexView = (IndexView)hs.getNavigatorView("Index");
        if (this.indexView != null) {
            this.indexTopNode = this.indexView.getDataAsTree();
            this.indexTreeEnum = this.indexTopNode.preorderEnumeration();
            this.setIndexTreeList();
        }
        this.searchView = (SearchView)hs.getNavigatorView("Search");
    }

    public void validateHelpSet(HttpServletRequest request, String hsName, boolean merge) {
        HelpSet hs = this.helpBroker.getHelpSet();
        if (hs != null) {
            if (hsName == null) {
                return;
            }
            HelpSet newHS = this.createHelpSet(request, hsName);
            if (merge && !hs.contains(newHS)) {
                hs.add(newHS);
            } else {
                this.helpBroker.setHelpSet(newHS);
            }
        } else {
            if (hsName == null) {
                CCDebug.trace1("Invalid URL path: " + hsName);
                return;
            }
            this.helpBroker.setHelpSet(this.createHelpSet(request, hsName));
        }
    }

    public void validateID(String helpID) {
        if (helpID != null) {
            this.helpBroker.setCurrentID(helpID);
        } else if (this.helpBroker.getCurrentID() == null && this.helpBroker.getCurrentURL() == null) {
            try {
                this.helpBroker.setCurrentID(this.helpBroker.getHelpSet().getHomeID());
            }
            catch (InvalidHelpSetContextException invalidHelpSetContextException) {
                // empty catch block
            }
        }
    }

    public void setCurrentHelpPage(URL url) {
        this.helpBroker.setCurrentURL(url);
    }

    private HelpSet createHelpSet(HttpServletRequest request, String hsName) {
        String temp;
        HelpSet hs = null;
        String urlstr = null;
        int i = hsName.indexOf(":");
        if (i > 0 && ((temp = hsName.substring(0, i)).equalsIgnoreCase(SECURE_SCHEME) || temp.equalsIgnoreCase(UNSECURE_SCHEME) || temp.equalsIgnoreCase(FILE_SCHEME))) {
            urlstr = hsName;
        }
        if (urlstr == null) {
            if (!hsName.startsWith("/")) {
                hsName = "/" + hsName;
            }
            urlstr = CCSystem.getHelpUrlHeader(request) + hsName;
        }
        try {
            URL url = new URL(urlstr);
            hs = new HelpSet(null, url);
        }
        catch (MalformedURLException e) {
        }
        catch (HelpSetException hse) {
            if (!this.tagsLocale.toString().equals(Locale.ENGLISH)) {
                this.tagsLocale = Locale.ENGLISH;
                hs = this.createHelpSet(request, this.getDefaultHelpSetPath(request));
            }
            CCDebug.trace1("Can not create helpset for en locale: " + hse.getMessage());
            throw new RuntimeException(hse);
        }
        return hs;
    }

    private void addSubHelpSets(HelpSet hs) {
        Enumeration e = hs.getHelpSets();
        while (e.hasMoreElements()) {
            HelpSet ehs = (HelpSet)e.nextElement();
            if (ehs == null) continue;
            NavigatorView[] views = ehs.getNavigatorViews();
            for (int i = 0; i < views.length; ++i) {
                Merge mergeObject;
                if (!(views[i] instanceof TOCView) || (mergeObject = Merge.DefaultMergeFactory.getMerge((NavigatorView)this.tocView, (NavigatorView)views[i])) == null) continue;
                mergeObject.processMerge((TreeNode)this.tocTopNode);
            }
            this.addSubHelpSets(ehs);
        }
    }

    public String getID(TreeNode node) {
        if (node == this.tocTopNode) {
            return BASE_ID;
        }
        TreeNode parent = node.getParent();
        if (parent == null) {
            return "";
        }
        String id = this.getID(parent);
        return id.concat("_" + Integer.toString(parent.getIndex(node)));
    }

    public String getContentURL(TreeItem item) {
        URL url = null;
        Map.ID id = item.getID();
        if (id != null) {
            HelpSet hs = id.hs;
            Map map = hs.getLocalMap();
            try {
                url = map.getURLFromID(id);
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        return url != null ? url.toExternalForm() : "";
    }

    public String getExternalContentURL(TreeItem item, HttpServletRequest request) {
        String extForm = null;
        Map.ID id = item.getID();
        if (id != null) {
            HelpSet hs = id.hs;
            Map map = hs.getLocalMap();
            try {
                extForm = this.getExternalContentURL(map.getURLFromID(id), request);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return extForm;
    }

    public String getExternalContentURL(URL url, HttpServletRequest request) {
        String path = this.clean(url.getPath());
        String extForm = null;
        if (url != null && url.getPath().length() > 0) {
            extForm = request.getScheme() + "://" + request.getServerName() + ":" + Integer.toString(request.getServerPort()) + path;
            if (url.getRef() != null) {
                extForm = extForm + "#" + url.getRef();
            }
        }
        return extForm;
    }

    private void setTOCTreeList() {
        this.tocTreeList = new ArrayList();
        while (this.tocTreeEnum.hasMoreElements()) {
            this.tocTreeList.add(this.tocTreeEnum.nextElement());
        }
    }

    public ArrayList getTOCTreeList() {
        if (this.tocTreeList == null) {
            this.setTOCTreeList();
        }
        return this.tocTreeList;
    }

    private void setIndexTreeList() {
        this.indexTreeList = new ArrayList();
        while (this.indexTreeEnum.hasMoreElements()) {
            this.indexTreeList.add(this.indexTreeEnum.nextElement());
        }
    }

    public ArrayList getIndexTreeList() {
        if (this.indexTreeList == null) {
            this.setIndexTreeList();
        }
        return this.indexTreeList;
    }

    public synchronized Enumeration doSearch(String query) {
        if (query == null) {
            return null;
        }
        if (this.helpSearch == null) {
            if (this.searchView == null) {
                this.searchView = (SearchView)this.helpBroker.getHelpSet().getNavigatorView("Search");
            }
            if (this.searchView == null) {
                return null;
            }
            this.helpSearch = new MergingSearchEngine((NavigatorView)this.searchView);
            this.searchQuery = this.helpSearch.createQuery();
            this.searchQuery.addSearchListener((SearchListener)this);
        }
        if (this.searchQuery.isActive()) {
            this.searchQuery.stop();
        }
        this.searchFinished = false;
        this.searchQuery.start(query, this.tagsLocale);
        if (!this.searchFinished) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.searchEnum;
    }

    public synchronized void searchStarted(SearchEvent e) {
        this.searchNodes = new Vector();
        this.searchFinished = false;
    }

    public synchronized void searchFinished(SearchEvent e) {
        this.searchFinished = true;
        this.searchEnum = this.searchNodes.elements();
        this.notifyAll();
    }

    public synchronized void itemsFound(SearchEvent e) {
        Enumeration itemEnum = e.getSearchItems();
        while (itemEnum.hasMoreElements()) {
            SearchTOCItem tocitem;
            URL url;
            SearchItem item = (SearchItem)itemEnum.nextElement();
            try {
                url = new URL(item.getBase(), item.getFilename());
            }
            catch (MalformedURLException me) {
                CCDebug.trace3("Could not create URL from: " + item.getBase() + "|" + item.getFilename());
                continue;
            }
            boolean foundNode = false;
            Enumeration nodesEnum = this.searchNodes.elements();
            while (nodesEnum.hasMoreElements()) {
                tocitem = (SearchTOCItem)nodesEnum.nextElement();
                URL testURL = tocitem.getURL();
                if (testURL == null || url == null || !url.sameFile(testURL)) continue;
                tocitem.addSearchHit(new SearchHit(item.getConfidence(), item.getBegin(), item.getEnd()));
                foundNode = true;
                break;
            }
            if (foundNode) continue;
            tocitem = new SearchTOCItem(item);
            this.searchNodes.addElement(tocitem);
        }
    }

    private String clean(String str) {
        return str.replaceAll("//*", "/");
    }

    public void printDebug() {
        ArrayList tocTreeList = this.getTOCTreeList();
        if (tocTreeList == null) {
            CCDebug.trace1("tocTreeList null.");
            return;
        }
        NonSyncStringBuffer buf = new NonSyncStringBuffer("tocTreeList dump:\n");
        DefaultMutableTreeNode node = null;
        int nTreeNodes = tocTreeList.size();
        for (int i = 0; i < nTreeNodes; ++i) {
            node = (DefaultMutableTreeNode)tocTreeList.get(i);
            buf.append(this.tocTreeToString(node)).append("\n");
        }
        ArrayList indexTreeList = this.getIndexTreeList();
        if (indexTreeList == null) {
            CCDebug.trace1("indexTreeList null.");
            return;
        }
        buf = new NonSyncStringBuffer("indexTreeList dump:\n");
        nTreeNodes = indexTreeList.size();
        for (int i = 0; i < nTreeNodes; ++i) {
            node = (DefaultMutableTreeNode)indexTreeList.get(i);
            buf.append(this.indexTreeToString(node)).append("\n");
        }
    }

    public String tocTreeToString(DefaultMutableTreeNode node) {
        if (node == null) {
            return "\n\tTOC tree node is null.";
        }
        TOCItem item = (TOCItem)node.getUserObject();
        if (item == null) {
            return "\n\tTOCItem is null.";
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
        NonSyncStringBuffer buf = new NonSyncStringBuffer();
        buf.append("\n\tname:          " + item.getName());
        buf.append("\n\thelpID:        " + (item.getID() != null ? item.getID().id : ""));
        buf.append("\n\tparentID:        " + (parent != null ? Integer.toHexString(parent.hashCode()) : ""));
        buf.append("\n\tparentID 2:      " + this.getID(parent));
        buf.append("\n\tnode:          " + Integer.toHexString(node.hashCode()));
        buf.append("\n\tnodeID:        " + this.getID(node));
        buf.append("\n\tcontentURL:    " + this.getContentURL((TreeItem)item));
        buf.append("\n\texpansionType: " + Integer.toString(item.getExpansionType()));
        return buf.toString();
    }

    public String indexTreeToString(DefaultMutableTreeNode node) {
        if (node == null) {
            return "\n\tTree node is null.";
        }
        IndexItem item = (IndexItem)node.getUserObject();
        if (item == null) {
            return "\n\tIndexItem is null.";
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
        NonSyncStringBuffer buf = new NonSyncStringBuffer();
        buf.append("\n\tname:          " + item.getName());
        buf.append("\n\thelpID:        " + (item.getID() != null ? item.getID().id : ""));
        buf.append("\n\tparentID:        " + (parent != null ? Integer.toHexString(parent.hashCode()) : ""));
        buf.append("\n\tparentID 2:      " + this.getID(parent));
        buf.append("\n\tnode:          " + Integer.toHexString(node.hashCode()));
        buf.append("\n\tnodeID:        " + this.getID(node));
        buf.append("\n\texpansionType: " + Integer.toString(item.getExpansionType()));
        return buf.toString();
    }
}

