/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.taglib.alarm;

import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.html.ImageField;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCImage;
import com.sun.web.ui.taglib.common.CCTagBase;
import com.sun.web.ui.taglib.html.CCImageTag;
import com.sun.web.ui.view.alarm.CCAlarm;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;

public class CCAlarmTag
extends CCTagBase {
    protected static final String ATTRIB_DEFAULT_VALUE = "defaultValue";
    protected static final String ATTRIB_EXTRAHTML = "extraHtml";
    protected static final String ATTRIB_BORDER = "border";
    protected static final String ATTRIB_ALIGN = "align";
    private String alarmImageSrc;
    private String alarmImageHeight;
    private String alarmImageWidth;
    private String alarmImageAltText;
    private static final String ALARM_CRITICAL_ALT_TEXT = "alarm.criticalAltText";
    private static final String ALARM_MAJOR_ALT_TEXT = "alarm.majorAltText";
    private static final String ALARM_MINOR_ALT_TEXT = "alarm.minorAltText";
    private static final String ALARM_DOWN_ALT_TEXT = "alarm.downAltText";
    private String DEFAULT_BORDER = "0";
    protected static final String ATTRIB_TITLE = "title";
    protected static final String ATTRIB_ALT = "alt";
    protected static final String ATTRIB_DEFVALUE = "defaultValue";
    protected static final String ATTRIB_HSPACE = "hspace";
    protected static final String ATTRIB_VSPACE = "vspace";

    public void reset() {
        super.reset();
        this.alarmImageSrc = null;
        this.alarmImageHeight = null;
        this.alarmImageWidth = null;
        this.alarmImageAltText = null;
    }

    protected String getHTMLStringInternal(Tag parent, PageContext pageContext, View view) throws JspException {
        String severity;
        if (parent == null) {
            throw new IllegalArgumentException("parent cannot be null");
        }
        if (pageContext == null) {
            throw new IllegalArgumentException("pageContext cannot be null");
        }
        if (view == null) {
            throw new IllegalArgumentException("view cannot be null");
        }
        super.getHTMLStringInternal(parent, pageContext, view);
        this.checkChildType(view, CCAlarm.class);
        CCAlarm container = (CCAlarm)view;
        this.setParent(parent);
        this.setPageContext(pageContext);
        if (container.getValue() == null) {
            container.setValue(this.getDefaultValue());
        }
        return (severity = this.initAlarmProperties(container)).equalsIgnoreCase("ok") ? "" : this.getImageHTMLString(container);
    }

    private String initAlarmProperties(CCAlarm container) {
        String severity = container.getValue().toString();
        if (severity.equalsIgnoreCase("critical")) {
            this.alarmImageSrc = CCImage.ALARM_CRITICAL_MEDIUM;
            this.alarmImageHeight = "13";
            this.alarmImageWidth = "13";
            this.alarmImageAltText = ALARM_CRITICAL_ALT_TEXT;
        } else if (severity.equalsIgnoreCase("down")) {
            this.alarmImageSrc = CCImage.ALARM_DOWN_MEDIUM;
            this.alarmImageHeight = "13";
            this.alarmImageWidth = "13";
            this.alarmImageAltText = ALARM_DOWN_ALT_TEXT;
        } else if (severity.equalsIgnoreCase("major")) {
            this.alarmImageSrc = CCImage.ALARM_MAJOR_MEDIUM;
            this.alarmImageHeight = "13";
            this.alarmImageWidth = "13";
            this.alarmImageAltText = ALARM_MAJOR_ALT_TEXT;
        } else if (severity.equalsIgnoreCase("minor")) {
            this.alarmImageSrc = CCImage.ALARM_MINOR_MEDIUM;
            this.alarmImageHeight = "13";
            this.alarmImageWidth = "13";
            this.alarmImageAltText = ALARM_MINOR_ALT_TEXT;
        } else {
            severity = "ok";
        }
        return severity;
    }

    private String getImageHTMLString(CCAlarm container) throws JspException {
        NonSyncStringBuffer buffer = new NonSyncStringBuffer(128);
        View child = container.getChild("AlarmImage");
        this.checkChildType(child, ImageField.class);
        ImageField imageField = (ImageField)child;
        CCImageTag ccImageTag = new CCImageTag();
        ccImageTag.setBundleID("com.sun.web.ui");
        ccImageTag.setAlt(this.alarmImageAltText);
        ccImageTag.setTitle(this.getTitle() != null ? this.getTitle() : this.alarmImageAltText);
        ccImageTag.setDefaultValue(this.alarmImageSrc);
        ccImageTag.setHeight(this.alarmImageHeight);
        ccImageTag.setWidth(this.alarmImageWidth);
        ccImageTag.setVspace(this.getVspace());
        ccImageTag.setHspace(this.getHspace());
        ccImageTag.setExtraHtml(this.getExtraHtml());
        ccImageTag.setBorder(this.getBorder());
        ccImageTag.setAlign(this.getAlign());
        return ccImageTag.getHTMLString(this.getParent(), this.pageContext, (View)imageField);
    }

    public void setDefaultValue(String value) {
        if (!(value == null || value.equals("critical") || value.equals("major") || value.equals("minor") || value.equals("down") || value.equals("ok"))) {
            CCDebug.trace1("Invalid parameter: " + value);
            return;
        }
        this.setValue("defaultValue", value);
    }

    public String getDefaultValue() {
        return this.getValue("defaultValue") != null ? (String)this.getValue("defaultValue") : "ok";
    }

    public String getHspace() {
        return (String)this.getValue(ATTRIB_HSPACE);
    }

    public void setHspace(String value) {
        this.setValue(ATTRIB_HSPACE, value);
    }

    public String getVspace() {
        return (String)this.getValue(ATTRIB_VSPACE);
    }

    public void setVspace(String value) {
        this.setValue(ATTRIB_VSPACE, value);
    }

    public String getExtraHtml() {
        return (String)this.getValue(ATTRIB_EXTRAHTML);
    }

    public void setExtraHtml(String value) {
        this.setValue(ATTRIB_EXTRAHTML, value);
    }

    public String getBorder() {
        return this.getValue(ATTRIB_BORDER) != null ? (String)this.getValue(ATTRIB_BORDER) : this.DEFAULT_BORDER;
    }

    public void setBorder(String value) {
        this.setValue(ATTRIB_BORDER, value);
    }

    public String getAlign() {
        return (String)this.getValue(ATTRIB_ALIGN);
    }

    public void setAlign(String value) {
        this.setValue(ATTRIB_ALIGN, value);
    }

    public String getAlt() {
        return (String)this.getValue(ATTRIB_ALT);
    }

    public void setAlt(String value) {
        this.setValue(ATTRIB_ALT, value);
    }

    public String getTitle() {
        return (String)this.getValue(ATTRIB_TITLE);
    }

    public void setTitle(String value) {
        this.setValue(ATTRIB_TITLE, value);
    }
}

