/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.taglib.html;

import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.CommandField;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.html.HtmlDisplayField;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCImage;
import com.sun.web.ui.taglib.common.CCDisplayFieldTagBase;
import com.sun.web.ui.taglib.header.CCHtmlHeaderTag;
import com.sun.web.ui.view.html.CCHref;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTag;
import javax.servlet.jsp.tagext.Tag;

public class CCHrefTag
extends CCDisplayFieldTagBase
implements BodyTag {
    protected static final String ATTRIB_ANCHOR = "anchor";
    protected static final String ATTRIB_FORM = "form";
    protected static final String ATTRIB_QUERYPARAMS = "queryParams";
    protected static final String ATTRIB_SUBMITFORMDATA = "submitformData";
    protected static final String ATTRIB_TARGET = "target";
    protected static final String ATTRIB_TITLE = "title";
    protected static final String ATTRIB_TRIM = "trim";
    protected static final String ATTRIB_TYPE = "type";
    protected static final String ATTRIB_IS_POPUP = "isPopup";
    private BodyContent bodyContent = null;
    private CommandField field = null;
    private String className = null;

    public int doStartTag() throws JspException {
        this.reset();
        return 2;
    }

    public void reset() {
        super.reset();
        this.field = null;
        this.className = null;
    }

    public int doAfterBody() throws JspException {
        return 0;
    }

    public void doInitBody() throws JspException {
    }

    protected String getHTMLStringInternal(Tag parent, PageContext pageContext, View view) throws JspException {
        if (parent == null) {
            throw new IllegalArgumentException("parent cannot be null");
        }
        if (pageContext == null) {
            throw new IllegalArgumentException("pageContext cannot be null");
        }
        if (view == null) {
            throw new IllegalArgumentException("view cannot be null");
        }
        this.checkChildType(view, CommandField.class);
        this.field = (CommandField)view;
        this.setParent(parent);
        this.setPageContext(pageContext);
        this.setAttributes();
        NonSyncStringBuffer buffer = new NonSyncStringBuffer(8192);
        buffer.append("<a");
        if (this.getAnchor() != null && this.getType() != null && (this.getType().equals("jumpTop") || this.getType().equals("jump"))) {
            CCHrefTag.appendAttribute(buffer, "href", "#" + this.getAnchor());
        } else {
            CCHrefTag.appendAttribute(buffer, "href", this.getURLString(parent, pageContext, this.field));
        }
        CCHrefTag.appendAttribute(buffer, "name", this.field.getQualifiedName());
        CCHrefTag.appendAttribute(buffer, "id", this.getElementId());
        CCHrefTag.appendAttribute(buffer, "class", this.getStyleClass());
        CCHrefTag.appendAttribute(buffer, ATTRIB_TARGET, this.getTarget());
        CCHrefTag.appendAttribute(buffer, ATTRIB_TITLE, this.getMessage(this.getTitle()));
        this.initOnClickAttribute();
        this.appendCommonHtmlAttributes(buffer);
        this.appendJavaScriptAttributes(buffer);
        if (this.field instanceof HtmlDisplayField) {
            this.appendExtraHtml((HtmlDisplayField)this.field, buffer);
        }
        buffer.append(">");
        this.appendLinkIcon(buffer);
        BodyContent bodyContent = this.getBodyContent();
        if (bodyContent != null) {
            if (this.getTrim() == null || this.isTrue(this.getTrim())) {
                buffer.append(bodyContent.getString().trim());
            } else {
                buffer.append(bodyContent.getString());
            }
        }
        buffer.append("</a>");
        return buffer.toString();
    }

    private void appendExtraValues(CommandField field, NonSyncStringBuffer buffer) throws JspException {
        Map values = field.getExtraValuesMap();
        if (values == null || values.size() == 0) {
            return;
        }
        Iterator i = values.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            Object value = values.get(key);
            if (value == null) continue;
            try {
                buffer.append("&amp;").append(key).append("=").append(URLEncoder.encode(value.toString(), this.encoding));
            }
            catch (UnsupportedEncodingException e) {
                CCDebug.trace3(this.encoding + " encoding is not supported.");
            }
        }
    }

    private void appendLinkIcon(NonSyncStringBuffer buffer) throws JspException {
        if (this.getType() == null) {
            return;
        }
        if (this.getType().equals("jump")) {
            buffer.append(CCHrefTag.getImageHTMLString(CCImage.HREF_ANCHOR, "10", "16"));
        } else if (this.getType().equals("jumpTop")) {
            buffer.append(CCHrefTag.getImageHTMLString(CCImage.HREF_TOP, "10", "11"));
        }
    }

    private void appendPopupQuery(NonSyncStringBuffer buffer) throws JspException {
        boolean isPopup = false;
        CCHref child = null;
        if (this.field instanceof CCHref) {
            child = (CCHref)this.field;
        }
        if (child != null && child.getIsPopup() != null) {
            isPopup = child.getIsPopup();
        } else if (this.getIsPopup() != null) {
            isPopup = this.isTrue(this.getIsPopup());
        } else {
            CCHtmlHeaderTag tag = (CCHtmlHeaderTag)CCHrefTag.findAncestorWithClass((Tag)this, (Class)CCHtmlHeaderTag.class);
            boolean bl = isPopup = tag != null && this.isTrue(tag.getIsPopup());
        }
        if (isPopup) {
            buffer.append("&amp;").append("com_sun_web_ui_popup").append("=").append("true");
        }
    }

    private void appendQueryParams(NonSyncStringBuffer buffer) throws JspException {
        String nvPairs = this.getQueryParams();
        if (nvPairs != null && nvPairs.length() > 0) {
            StringTokenizer st = new StringTokenizer(nvPairs, "&");
            while (st.hasMoreTokens()) {
                StringTokenizer st2 = new StringTokenizer(st.nextToken(), "=");
                try {
                    if (st2.hasMoreTokens()) {
                        buffer.append("&amp;").append(URLEncoder.encode(st2.nextToken(), this.encoding));
                    }
                    if (!st2.hasMoreTokens()) continue;
                    buffer.append("=").append(URLEncoder.encode(st2.nextToken(), this.encoding));
                }
                catch (UnsupportedEncodingException e) {
                    CCDebug.trace3(this.encoding + " encoding is not supported.");
                }
            }
        }
    }

    public String getURLString(Tag parent, PageContext pageContext, CommandField field) throws JspException {
        this.setParent(parent);
        this.setPageContext(pageContext);
        ViewBean viewBean = this.getParentViewBean();
        HttpServletResponse response = (HttpServletResponse)pageContext.getResponse();
        NonSyncStringBuffer buffer = new NonSyncStringBuffer(response.encodeURL(viewBean.getModuleURL() + "/" + viewBean.getRequestInvocationName()));
        buffer.append("?").append(field.getQualifiedName()).append("=");
        if (this.getDefaultValue() != null) {
            try {
                buffer.append(URLEncoder.encode(this.getDefaultValue(), this.encoding));
            }
            catch (UnsupportedEncodingException e) {
                CCDebug.trace3(this.encoding + " encoding is not supported.");
            }
        }
        this.appendPopupQuery(buffer);
        this.appendQueryParams(buffer);
        this.appendExtraValues(field, buffer);
        if (!this.isTrue(this.getSubmitFormData())) {
            buffer.append("&amp;").append("jato.pageSession").append("=").append(viewBean.getPageSessionAttributeString(false));
            if (this.getAnchor() != null) {
                buffer.append("#").append(this.getAnchor());
            }
        }
        return buffer.toString();
    }

    private void initOnClickAttribute() {
        if (this.getForm() == null || !this.isTrue(this.getSubmitFormData())) {
            return;
        }
        NonSyncStringBuffer buffer = new NonSyncStringBuffer();
        if (this.getOnClick() != null) {
            buffer.append(this.getOnClick()).append(";");
        }
        buffer.append("javascript:var f=document.").append(this.getForm()).append(";if (f != null) {f.action=this.href").append(";f.submit();return false}");
        this.setOnClick(buffer.toString());
    }

    protected void setAttributes() {
        if (this.field.getValue() != null) {
            this.setDefaultValue(this.field.getValue().toString());
        }
        if (this.field instanceof CCHref) {
            CCHref child = (CCHref)this.field;
            if (child.getElementId() != null) {
                this.setElementId(child.getElementId());
            }
            if (child.getType() != null) {
                this.setType(child.getType());
            }
            if (child.getTitle() != null) {
                this.setTitle(child.getTitle());
            }
        }
    }

    public String getStyleClass() {
        String className = super.getStyleClass();
        if (className == null && this.getType() != null) {
            if (this.getType().equals("jump")) {
                className = "JmpLnk";
            } else if (this.getType().equals("jumpTop")) {
                className = "JmpTopLnk";
            }
        }
        return className;
    }

    public BodyContent getBodyContent() {
        return this.bodyContent;
    }

    public void setBodyContent(BodyContent value) {
        this.bodyContent = value;
    }

    public String getAnchor() {
        return (String)this.getValue(ATTRIB_ANCHOR);
    }

    public void setAnchor(String value) {
        this.setValue(ATTRIB_ANCHOR, value);
    }

    public String getForm() {
        if (this.getValue(ATTRIB_FORM) != null) {
            return (String)this.getValue(ATTRIB_FORM);
        }
        return this.getFormName();
    }

    public void setForm(String value) {
        this.setValue(ATTRIB_FORM, value);
    }

    public String getQueryParams() {
        return (String)this.getValue(ATTRIB_QUERYPARAMS);
    }

    public void setQueryParams(String value) {
        this.setValue(ATTRIB_QUERYPARAMS, value);
    }

    public String getSubmitFormData() {
        return this.getValue(ATTRIB_SUBMITFORMDATA) != null ? (String)this.getValue(ATTRIB_SUBMITFORMDATA) : "false";
    }

    public void setSubmitFormData(String value) {
        if (value != null && !value.toLowerCase().equals("true") && !value.toLowerCase().equals("false")) {
            CCDebug.trace1("Invalid parameter: " + value);
            return;
        }
        this.setValue(ATTRIB_SUBMITFORMDATA, value);
    }

    public String getTarget() {
        return (String)this.getValue(ATTRIB_TARGET);
    }

    public void setTarget(String value) {
        this.setValue(ATTRIB_TARGET, value);
    }

    public String getTitle() {
        return (String)this.getValue(ATTRIB_TITLE);
    }

    public void setTitle(String value) {
        this.setValue(ATTRIB_TITLE, value);
    }

    public String getTrim() {
        return (String)this.getValue(ATTRIB_TRIM);
    }

    public void setTrim(String value) {
        if (value != null && !value.toLowerCase().equals("true") && !value.toLowerCase().equals("false")) {
            CCDebug.trace1("Invalid parameter: " + value);
            return;
        }
        this.setValue(ATTRIB_TRIM, value);
    }

    public String getType() {
        return (String)this.getValue(ATTRIB_TYPE);
    }

    public void setType(String value) {
        if (value != null && !value.equals("jump") && !value.equals("jumpTop")) {
            CCDebug.trace1("Invalid parameter: " + value);
            return;
        }
        this.setValue(ATTRIB_TYPE, value);
    }

    public void setIsPopup(String value) {
        if (value != null && !value.toLowerCase().equals("true") && !value.toLowerCase().equals("false")) {
            CCDebug.trace1("Invalid parameter: " + value);
            return;
        }
        this.setValue(ATTRIB_IS_POPUP, value);
    }

    public String getIsPopup() {
        return (String)this.getValue(ATTRIB_IS_POPUP);
    }

    public String getActionURLJavascript(Tag parent, PageContext pageContext, CommandField field) throws JspException {
        if (this.getFormName() == null) {
            return null;
        }
        NonSyncStringBuffer buffer = new NonSyncStringBuffer();
        String url = this.getURLString(parent, pageContext, field);
        buffer.append("javascript:var f=document.").append(this.getFormName()).append(";if (f != null) {f.action='").append(url).append("' + f.elements['").append("jato.pageSession").append("'].value;f.submit();}");
        return buffer.toString();
    }
}

