/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.taglib.html;

import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.DisplayField;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.html.HtmlDisplayField;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCManageChild;
import com.sun.web.ui.taglib.common.CCTextFieldTagBase;
import com.sun.web.ui.view.html.CCTextField;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;

public class CCTextFieldTag
extends CCTextFieldTagBase {
    protected static final String ATTRIB_SUBMIT = "AutoSubmit";
    protected static final String ATTRIB_DYNAMIC = "dynamic";
    protected static final String ATTRIB_MAXLENGTH = "maxLength";
    protected static final String ATTRIB_READONLY = "readOnly";
    protected static final String ATTRIB_SIZE = "size";
    protected static final String ATTRIB_TITLE = "title";
    protected static final String ATTRIB_TITLE_DISABLED = "titleDisabled";
    protected static final String ATTRIB_LOCALIZE_DISPLAYFIELD_VALUE = "localizeDisplayFieldValue";
    protected String type = null;
    private DisplayField field = null;
    protected static final String TYPE_PASSWORD = "password";
    protected static final String TYPE_TEXT = "text";

    public void reset() {
        super.reset();
        this.field = null;
    }

    protected String getHTMLStringInternal(Tag parent, PageContext pageContext, View view) throws JspException {
        if (parent == null) {
            throw new IllegalArgumentException("parent cannot be null");
        }
        if (pageContext == null) {
            throw new IllegalArgumentException("pageContext cannot be null");
        }
        if (view == null) {
            throw new IllegalArgumentException("view cannot be null");
        }
        super.getHTMLStringInternal(parent, pageContext, view);
        this.checkChildType(view, DisplayField.class);
        this.field = (DisplayField)view;
        if (this.field instanceof CCManageChild) {
            ((CCManageChild)this.field).beginDisplay();
        }
        this.setParent(parent);
        this.setPageContext(pageContext);
        this.setAttributes();
        NonSyncStringBuffer buffer = new NonSyncStringBuffer(8192);
        buffer.append("<input");
        CCTextFieldTag.appendAttribute(buffer, "type", this.getType());
        CCTextFieldTag.appendAttribute(buffer, "name", this.field.getQualifiedName());
        CCTextFieldTag.appendAttribute(buffer, "id", this.getElementId());
        CCTextFieldTag.appendAttribute(buffer, "value", this.getValue());
        CCTextFieldTag.appendAttribute(buffer, "maxlength", this.getMaxLength());
        CCTextFieldTag.appendAttribute(buffer, ATTRIB_SIZE, this.getSize());
        if (this.isTrue(this.getReadOnly())) {
            CCTextFieldTag.appendAttribute(buffer, "readonly", "readonly");
        }
        CCTextFieldTag.appendAttribute(buffer, ATTRIB_TITLE, this.isTrue(this.getDisabled()) && this.getTitleDisabled() != null ? this.getMessage(this.getTitleDisabled()) : this.getMessage(this.getTitle()));
        CCTextFieldTag.appendAttribute(buffer, "class", this.isTrue(this.getDisabled()) ? "TxtFldDis" : "TxtFld");
        if (this.getAutoSubmit() != null) {
            this.addAutoSubmitJavascript(this.isTrue(this.getAutoSubmit()));
        }
        this.appendCommonHtmlAttributes(buffer);
        this.appendJavaScriptAttributes(buffer);
        if (this.field instanceof HtmlDisplayField) {
            this.appendExtraHtml((HtmlDisplayField)this.field, buffer);
        }
        buffer.append(" />");
        if (this.isTrue(this.getDynamic())) {
            this.appendHiddenFields(buffer);
            this.includeDynamicJS();
        }
        return buffer.toString();
    }

    private void addAutoSubmitJavascript(boolean submit) {
        String keyCode = this.isNav() ? "event.which" : "event.keyCode";
        NonSyncStringBuffer buffer = new NonSyncStringBuffer("javascript: ");
        if (submit) {
            if (this.getFormName() == null) {
                return;
            }
            if (this.isNav4() && this.isSun()) {
                if (this.getOnChange() != null) {
                    buffer.append(this.getOnChange()).append(";");
                }
                buffer.append("if (").append(keyCode).append(" == 0) document.").append(this.getFormName()).append(".submit()");
                this.setOnChange(buffer.toString());
            } else {
                if (this.getOnKeyPress() != null) {
                    buffer.append(this.getOnKeyPress()).append(";");
                }
                buffer.append("if (").append(keyCode).append(" == 13) document.").append(this.getFormName()).append(".submit()");
                this.setOnKeyPress(buffer.toString());
            }
        } else if (this.isNav4() && this.isSun()) {
            if (this.getOnClick() != null) {
                buffer.append(this.getOnClick()).append(";");
            }
            buffer.append("return false");
            this.setOnClick(buffer.toString());
        } else {
            if (this.getOnKeyPress() != null) {
                buffer.append(this.getOnKeyPress()).append(";");
            }
            if (this.isNav6() || this.getClientSniffer().isNav70()) {
                buffer.append(" if (").append(keyCode).append(" == 13) event.cancelBubble = true");
            } else {
                buffer.append("if (").append(keyCode).append(" == 13) return false");
            }
            this.setOnKeyPress(buffer.toString());
        }
    }

    private void appendHiddenFields(NonSyncStringBuffer buffer) throws JspException {
        if (!(this.field instanceof CCTextField)) {
            return;
        }
        buffer.append("\n").append(this.getHiddenFieldHTMLString((View)this.field, "ValueDisabledHiddenField", this.getValue()));
        buffer.append("\n").append(this.getHiddenFieldHTMLString((View)this.field, "DisabledHiddenField", this.getDisabled()));
        if (this.getTitleDisabled() == null) {
            return;
        }
        buffer.append("\n").append(this.getHiddenFieldHTMLString((View)this.field, "TitleEnabledHiddenField", this.getMessage(this.getTitle())));
        buffer.append("\n").append(this.getHiddenFieldHTMLString((View)this.field, "TitleDisabledHiddenField", this.getMessage(this.getTitleDisabled())));
    }

    protected String getType() {
        return this.type != null ? this.type : TYPE_TEXT;
    }

    protected void setType(String value) {
        if (value != null && !value.equals(TYPE_TEXT) && !value.equals(TYPE_PASSWORD)) {
            CCDebug.trace1("Invalid parameter: " + value);
            return;
        }
        this.type = value;
    }

    private String getValue() {
        String value = this.getDisplayFieldValue();
        if (value == null && this.getDefaultValue() != null && this.getType().equals(TYPE_TEXT)) {
            value = this.getMessage(this.getDefaultValue());
        }
        return value != null ? this.formatValue(value) : "";
    }

    private String getDisplayFieldValue() {
        String value;
        String string = value = this.field.getValue() != null ? this.field.getValue().toString() : null;
        if (value != null && this.field instanceof CCTextField && this.getType().equals(TYPE_TEXT)) {
            Boolean localize;
            CCTextField child = (CCTextField)this.field;
            Boolean bl = child.getLocalizeDisplayFieldValue() != null ? child.getLocalizeDisplayFieldValue() : (localize = this.getLocalizeDisplayFieldValue() != null ? new Boolean(this.getLocalizeDisplayFieldValue()) : null);
            if (localize == null || localize.booleanValue()) {
                value = this.getMessage(value);
            }
        }
        return value;
    }

    protected void setAttributes() {
        if (!(this.field instanceof CCTextField)) {
            return;
        }
        CCTextField child = (CCTextField)this.field;
        if (child.getAutoSubmit() != null) {
            this.setAutoSubmit(child.getAutoSubmit().toString());
        }
        if (child.getDisabled() != null) {
            this.setDisabled(child.getDisabled().toString());
        }
        if (child.getDynamic() != null) {
            this.setDynamic(child.getDynamic().toString());
        }
        if (child.getElementId() != null) {
            this.setElementId(child.getElementId());
        }
        if (child.getFormatMask() != null) {
            this.setFormatMask(child.getFormatMask());
        }
        if (child.getFormatType() != null) {
            this.setFormatType(child.getFormatType());
        }
        if (child.getMaxLength() != null) {
            this.setMaxLength(child.getMaxLength().toString());
        }
        if (child.getReadOnly() != null) {
            this.setReadOnly(child.getReadOnly().toString());
        }
        if (child.getSize() != null) {
            this.setSize(child.getSize().toString());
        }
        if (child.getTitle() != null) {
            this.setTitle(child.getTitle());
        }
        if (child.getTitleDisabled() != null) {
            this.setTitleDisabled(child.getTitleDisabled());
        }
    }

    public void setAutoSubmit(String value) {
        if (value != null && !value.toLowerCase().equals("true") && !value.toLowerCase().equals("false")) {
            CCDebug.trace1("Invalid parameter " + value);
            return;
        }
        this.setValue(ATTRIB_SUBMIT, value);
    }

    public String getAutoSubmit() {
        return (String)this.getValue(ATTRIB_SUBMIT);
    }

    public String getDynamic() {
        return (String)this.getValue(ATTRIB_DYNAMIC);
    }

    public void setDynamic(String value) {
        if (value != null && !value.toLowerCase().equals("true") && !value.toLowerCase().equals("false")) {
            CCDebug.trace1("Invalid parameter: " + value);
            return;
        }
        this.setValue(ATTRIB_DYNAMIC, value);
    }

    public String getLocalizeDisplayFieldValue() {
        return (String)this.getValue(ATTRIB_LOCALIZE_DISPLAYFIELD_VALUE);
    }

    public void setLocalizeDisplayFieldValue(String value) {
        if (value != null && !value.toLowerCase().equals("true") && !value.toLowerCase().equals("false")) {
            CCDebug.trace1("Invalid parameter: " + value);
            return;
        }
        this.setValue(ATTRIB_LOCALIZE_DISPLAYFIELD_VALUE, value);
    }

    public String getMaxLength() {
        return (String)this.getValue(ATTRIB_MAXLENGTH);
    }

    public void setMaxLength(String value) {
        this.setValue(ATTRIB_MAXLENGTH, value);
    }

    public String getReadOnly() {
        return (String)this.getValue(ATTRIB_READONLY);
    }

    public void setReadOnly(String value) {
        if (value != null && !value.toLowerCase().equals("true") && !value.toLowerCase().equals("false")) {
            CCDebug.trace1("Invalid parameter: " + value);
            return;
        }
        this.setValue(ATTRIB_READONLY, value);
    }

    public String getSize() {
        return (String)this.getValue(ATTRIB_SIZE);
    }

    public void setSize(String value) {
        this.setValue(ATTRIB_SIZE, value);
    }

    public String getTitle() {
        return (String)this.getValue(ATTRIB_TITLE);
    }

    public void setTitle(String value) {
        this.setValue(ATTRIB_TITLE, value);
    }

    public String getTitleDisabled() {
        return (String)this.getValue(ATTRIB_TITLE_DISABLED);
    }

    public void setTitleDisabled(String value) {
        this.setValue(ATTRIB_TITLE_DISABLED, value);
    }
}

