/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.taglib.tabs;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.HtmlUtil;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.JspDisplayEvent;
import com.sun.web.ui.common.CCBodyContentImpl;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCImage;
import com.sun.web.ui.common.CCJspWriterImpl;
import com.sun.web.ui.model.CCNavNodeInterface;
import com.sun.web.ui.model.CCTabsModelInterface;
import com.sun.web.ui.taglib.common.CCTagBase;
import com.sun.web.ui.taglib.html.CCHrefTag;
import com.sun.web.ui.taglib.skip.CCSkipTag;
import com.sun.web.ui.view.html.CCHref;
import com.sun.web.ui.view.tabs.CCTabs;
import java.io.IOException;
import java.util.Iterator;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;

public class CCTabsTag
extends CCTagBase {
    protected static final String ATTRIB_TARGET = "target";
    protected static final String ATTRIB_TYPE = "type";
    protected static final String ATTRIB_SUBMITFORMDATA = "submitFormData";
    public static final String TYPE_DEFAULT = "default";
    public static final String TYPE_MINI = "mini";
    private int PADDING_MIN_LEN = 6;
    private static final String WHITESPACE = "[ \t\n\f\r]";
    private CCTabsModelInterface model = null;
    private CCTabs tabsView = null;
    private NonSyncStringBuffer buffer = null;
    private NonSyncStringBuffer skipTagAltText = null;
    private boolean bIsMiniTab = false;

    public void reset() {
        super.reset();
        this.model = null;
        this.tabsView = null;
        this.buffer = null;
        this.bIsMiniTab = false;
    }

    protected String getHTMLStringInternal(Tag parent, PageContext pageContext, View view) throws JspException {
        if (parent == null) {
            throw new IllegalArgumentException("parent cannot be null");
        }
        if (pageContext == null) {
            throw new IllegalArgumentException("pageContext cannot be null");
        }
        if (view == null) {
            throw new IllegalArgumentException("view cannot be null");
        }
        super.getHTMLStringInternal(parent, pageContext, view);
        this.checkChildType(view, CCTabs.class);
        this.tabsView = (CCTabs)view;
        this.model = this.tabsView.getCCTabsModel();
        if (this.model == null) {
            CCDebug.trace1("Model is null.");
            return null;
        }
        this.setParent(parent);
        this.setPageContext(pageContext);
        if (this.getType().equals(TYPE_MINI)) {
            this.bIsMiniTab = true;
        }
        try {
            this.tabsView.beginDisplay((DisplayEvent)new JspDisplayEvent((Tag)this, pageContext));
        }
        catch (ModelControlException e) {
            throw new JspException(e.getMessage());
        }
        return this.getTabComponentHTML();
    }

    private String getTabComponentHTML() throws JspException {
        if (this.isNav4()) {
            return null;
        }
        if (this.bIsMiniTab) {
            return this.getTabsHTMLString();
        }
        CCSkipTag ccSkipTag = new CCSkipTag();
        ccSkipTag.setBundleID(this.getBundleID());
        ccSkipTag.setColor(CCImage.COLOR_MEDIUM_GREY1);
        ccSkipTag.setTabIndex(this.getTabIndex());
        try {
            CCBodyContentImpl bodyContent = new CCBodyContentImpl(new CCJspWriterImpl(null, 100, false));
            bodyContent.print(this.getTabsHTMLString());
            ccSkipTag.setBodyContent(bodyContent);
        }
        catch (IOException e) {
            CCDebug.trace1(e.getMessage());
        }
        ccSkipTag.setAlt(HtmlUtil.escape((String)this.skipTagAltText.toString()));
        return ccSkipTag.getHTMLString(this.getParent(), this.pageContext, null);
    }

    private String getTabsHTMLString() throws JspException {
        if (this.model.getNodes().size() < 1) {
            CCDebug.trace1("No tabs defined.");
            return null;
        }
        this.skipTagAltText = new NonSyncStringBuffer(128);
        this.skipTagAltText.append(this.getTagMessage("tab.skipTagAltText"));
        this.buffer = new NonSyncStringBuffer(8192);
        CCNavNodeInterface level1SelectedTab = null;
        CCNavNodeInterface level2SelectedTab = null;
        CCNavNodeInterface lastSelectedTab = null;
        int depth = this.model.getMaxDepth() + 1;
        level1SelectedTab = this.appendFirstLevelTabs();
        this.appendSkipTagAltText(level1SelectedTab);
        if (this.bIsMiniTab || depth <= 1) {
            return this.buffer.toString();
        }
        if (depth <= 2) {
            lastSelectedTab = this.appendSecondLevelTabs(level1SelectedTab);
        } else {
            level2SelectedTab = this.appendSecondLevelTabs(level1SelectedTab);
            this.appendSkipTagAltText(level2SelectedTab);
            lastSelectedTab = this.appendLastLevelTabs(level2SelectedTab);
        }
        this.appendSkipTagAltText(lastSelectedTab);
        return this.buffer.toString();
    }

    private CCNavNodeInterface appendFirstLevelTabs() throws JspException {
        String tableStyle;
        String textStyle;
        String tdStyle;
        String linkStyle;
        String divStyle;
        CCNavNodeInterface selectedTab = this.getSelectedTab();
        if (!this.bIsMiniTab) {
            divStyle = "Tab1Div";
            linkStyle = "Tab1Lnk";
            tdStyle = "Tab1TblSelTd";
            textStyle = "Tab1SelTxtNew";
            int tabDepth = this.getTabDepth(selectedTab);
            tableStyle = tabDepth == 3 ? "Tab1Tbl3New" : (tabDepth == 2 ? "Tab1Tbl2New" : "Tab1TblNew");
        } else {
            divStyle = "MniTabDiv";
            linkStyle = "MniTabLnk";
            tdStyle = "MniTabTblSelTd";
            textStyle = "MniTabSelTxt";
            tableStyle = "MniTabTbl";
        }
        this.appendOpeningDivAndTable(divStyle, tableStyle);
        CCNavNodeInterface tabNext = null;
        Iterator it = this.model.getNodes().iterator();
        while (it.hasNext()) {
            tabNext = (CCNavNodeInterface)it.next();
            if (!tabNext.equals(selectedTab)) {
                this.appendUnselectedTab(tabNext, linkStyle, false);
                continue;
            }
            this.appendSelectedTab(tabNext, tdStyle, textStyle);
        }
        this.appendClosingDivAndTable();
        return selectedTab;
    }

    private CCNavNodeInterface appendSecondLevelTabs(CCNavNodeInterface level1SelectedTab) throws JspException {
        if (level1SelectedTab.getNumChildren() < 1) {
            return null;
        }
        CCNavNodeInterface level2SelectedTab = this.getSelectedSubTab(level1SelectedTab);
        int tabDepth = level2SelectedTab.getNumChildren() > 0 ? 3 : 2;
        String tableStyle = tabDepth == 3 ? "Tab2Tbl3New" : "Tab2TblNew";
        this.appendLevel2Level3Tabs(2, level1SelectedTab, level2SelectedTab, "Tab2Div", tableStyle, "Tab2Lnk", "Tab2TblSelTd", "Tab2SelTxt");
        return level2SelectedTab;
    }

    private CCNavNodeInterface appendLastLevelTabs(CCNavNodeInterface level2SelectedTab) throws JspException {
        if (level2SelectedTab == null || level2SelectedTab.getNumChildren() < 1) {
            return null;
        }
        CCNavNodeInterface lastLevelSelectedTab = this.getSelectedSubTab(level2SelectedTab);
        this.appendLevel2Level3Tabs(3, level2SelectedTab, lastLevelSelectedTab, "Tab3Div", "Tab3TblNew", "Tab3Lnk", "Tab3TblSelTd", "Tab3SelTxt");
        return lastLevelSelectedTab;
    }

    private void appendLevel2Level3Tabs(int level, CCNavNodeInterface parentTab, CCNavNodeInterface selectedTab, String divStyle, String tableStyle, String linkStyle, String tdStyle, String textStyle) throws JspException {
        this.appendOpeningDivAndTable(divStyle, tableStyle);
        CCNavNodeInterface tabNext = null;
        boolean bNeedDivider = false;
        Iterator it = parentTab.getChildren().iterator();
        while (it.hasNext()) {
            tabNext = (CCNavNodeInterface)it.next();
            if (!tabNext.equals(selectedTab)) {
                this.appendUnselectedTab(tabNext, linkStyle, bNeedDivider);
                if (level == 2) continue;
                bNeedDivider = true;
                continue;
            }
            this.appendSelectedTab(tabNext, tdStyle, textStyle);
            bNeedDivider = false;
        }
        this.appendClosingDivAndTable();
    }

    private void appendOpeningDivAndTable(String divStyle, String tableStyle) {
        this.buffer.append("<div class=\"").append(divStyle).append("\">\n").append("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"").append(" class=\"").append(tableStyle).append("\" title=\"\">\n<tr>\n");
    }

    private void appendClosingDivAndTable() {
        this.buffer.append("</tr>\n</table>\n</div>\n");
    }

    private void appendUnselectedTab(CCNavNodeInterface tab, String linkStyle, boolean bNeedDivider) throws JspException {
        String label = this.getMessage(tab.getLabel());
        if (label.length() <= this.PADDING_MIN_LEN) {
            linkStyle = linkStyle + " " + "TabPad";
        }
        if (bNeedDivider) {
            this.appendDivider(CCImage.TAB_DIVIDER, "20", "5");
        }
        this.buffer.append("<td>").append(this.getHrefHTMLString(tab, linkStyle)).append("</td>\n");
    }

    private void appendSelectedTab(CCNavNodeInterface tab, String tdStyle, String textStyle) {
        String label = this.getMessage(tab.getLabel());
        if (label.length() <= this.PADDING_MIN_LEN) {
            textStyle = textStyle + " " + "TabPad";
        }
        this.buffer.append("<td class=\"").append(tdStyle).append("\"><div class=\"").append(textStyle).append("\" title=\"");
        this.appendCurrTabMessage(tab);
        this.buffer.append("\">").append(HtmlUtil.escape((String)label)).append("</div></td>\n");
    }

    private String getHrefHTMLString(CCNavNodeInterface tab, String style) throws JspException {
        String target;
        View child = this.tabsView.getChild("TabHref");
        this.checkChildType(child, CCHref.class);
        CCHref href = (CCHref)child;
        CCHrefTag ccHrefTag = new CCHrefTag();
        href.setValue(new Integer(tab.getId()));
        ccHrefTag.setName("TabHref");
        ccHrefTag.setStyleClass(style);
        ccHrefTag.setBundleID(this.getBundleID());
        ccHrefTag.setTabIndex(this.getTabIndex());
        if (tab.getTooltip() != null) {
            ccHrefTag.setTitle(tab.getTooltip());
        }
        if (tab.getStatus() != null) {
            this.setHrefStatus(ccHrefTag, HtmlUtil.escapeQuotes((String)this.getMessage(tab.getStatus())));
        }
        String string = target = tab.getTarget() != null ? tab.getTarget() : this.getTarget();
        if (target != null) {
            ccHrefTag.setTarget(target);
            href.addExtraValue("reload", "true");
            this.setOnClickJavascript(tab.getOnClick(), ccHrefTag);
        } else {
            if (tab.getOnClick() != null) {
                ccHrefTag.setOnClick(tab.getOnClick());
            }
            ccHrefTag.setSubmitFormData(this.getSubmitFormData());
        }
        String label = HtmlUtil.escape((String)this.getMessage(tab.getLabel()));
        try {
            CCBodyContentImpl bodyContent = new CCBodyContentImpl(new CCJspWriterImpl(null, 100, false));
            bodyContent.print(label);
            ccHrefTag.setBodyContent(bodyContent);
        }
        catch (IOException e) {
            CCDebug.trace1(e.getMessage());
        }
        String html = "";
        if (this.fireBeginDisplayEvent((ContainerView)this.tabsView, ccHrefTag)) {
            html = ccHrefTag.getHTMLString(this.getParent(), this.pageContext, (View)href);
        }
        return this.fireEndDisplayEvent((ContainerView)this.tabsView, ccHrefTag, html);
    }

    private void setOnClickJavascript(String onClick, CCHrefTag ccHrefTag) throws JspException {
        String formName = this.getFormName();
        if (formName == null) {
            return;
        }
        NonSyncStringBuffer buffer = new NonSyncStringBuffer();
        if (onClick != null) {
            buffer.append(onClick).append(";");
        }
        buffer.append("javascript:var f=document.").append(formName).append(";if (f != null) {f.action=this.href").append(";f.submit();return true}");
        ccHrefTag.setOnClick(buffer.toString());
    }

    private void setHrefStatus(CCHrefTag ccHrefTag, String status) throws JspException {
        if (ccHrefTag == null) {
            CCDebug.trace1("CCHrefTag parameter is null.");
            return;
        }
        if (status == null) {
            CCDebug.trace1("status parameter is null.");
            return;
        }
        NonSyncStringBuffer statusBuffer = new NonSyncStringBuffer(8192);
        statusBuffer.append("window.status='").append(CCTabsTag.escapeJsQuotes(status)).append("'; return true");
        ccHrefTag.setOnMouseOver(statusBuffer.toString());
        ccHrefTag.setOnFocus(statusBuffer.toString());
        ccHrefTag.setOnMouseOut("window.status=''; return true");
        ccHrefTag.setOnBlur("window.status=''; return true");
    }

    private CCNavNodeInterface getSelectedTab() {
        CCNavNodeInterface selectedTab = this.model.getSelectedNode();
        if (selectedTab != null) {
            if (selectedTab.getParent() == null) {
                return selectedTab;
            }
            CCNavNodeInterface[] tabs = selectedTab.getPath();
            if (tabs.length > 0) {
                return tabs[0];
            }
        }
        selectedTab = (CCNavNodeInterface)this.model.getNodes().get(0);
        this.model.setSelectedNode(selectedTab);
        return selectedTab;
    }

    private CCNavNodeInterface getSelectedSubTab(CCNavNodeInterface parent) {
        if (parent == null || parent.getNumChildren() < 1) {
            return null;
        }
        CCNavNodeInterface selectedTab = this.model.getSelectedNode();
        if (selectedTab != null) {
            if (selectedTab.equals(parent)) {
                selectedTab = (CCNavNodeInterface)parent.getChildren().get(0);
                this.model.setSelectedNode(selectedTab);
                return selectedTab;
            }
            CCNavNodeInterface[] tabs = selectedTab.getPath();
            int level = parent.getLevel();
            return level + 1 >= tabs.length ? selectedTab : tabs[level + 1];
        }
        selectedTab = (CCNavNodeInterface)parent.getChildren().get(0);
        this.model.setSelectedNode(selectedTab);
        return selectedTab;
    }

    private void appendCurrTabMessage(CCNavNodeInterface tab) {
        this.buffer.append(HtmlUtil.escape((String)(this.getTagMessage("tab.currTab") + " " + this.getMessage(tab.getLabel()))));
    }

    private void appendSkipTagAltText(CCNavNodeInterface tab) {
        if (tab != null) {
            this.skipTagAltText.append(": ").append(this.getMessage(tab.getLabel()));
        }
    }

    private void appendDivider(String divider, String height, String width) {
        this.buffer.append("<td>").append(CCTabsTag.getImageHTMLString(divider, height, width)).append("</td>\n");
    }

    private void appendLevel1Gutter(int width, String style) throws JspException {
        this.buffer.append("<td class=\"").append(style).append("\">").append(CCTabsTag.getImageHTMLString(CCImage.DOT, 1, width)).append("</td>\n");
    }

    private int getTabDepth(CCNavNodeInterface tab) {
        int numChildren = tab.getNumChildren();
        if (numChildren < 1) {
            return 1;
        }
        return tab.getNumDescendants() > numChildren ? 3 : 2;
    }

    private void appendColSpanAttribute(int numCols) {
        if (numCols > 1) {
            this.buffer.append(" colspan=\"").append(numCols + "\"");
        }
    }

    private void appendTabSpacer(int width) throws JspException {
        this.buffer.append("<td>").append(CCTabsTag.getImageHTMLString(CCImage.DOT, 1, width)).append("</td>\n");
    }

    public String getTarget() {
        return (String)this.getValue(ATTRIB_TARGET);
    }

    public void setTarget(String value) {
        this.setValue(ATTRIB_TARGET, value);
    }

    public String getType() {
        String value = (String)this.getValue(ATTRIB_TYPE);
        if (value != null && value.equalsIgnoreCase(TYPE_MINI)) {
            return TYPE_MINI;
        }
        return TYPE_DEFAULT;
    }

    public void setType(String value) {
        if (value != null && (value.equalsIgnoreCase(TYPE_MINI) || value.equalsIgnoreCase(TYPE_DEFAULT))) {
            this.setValue(ATTRIB_TYPE, value);
        }
    }

    public String getSubmitFormData() {
        return this.getValue(ATTRIB_SUBMITFORMDATA) != null ? (String)this.getValue(ATTRIB_SUBMITFORMDATA) : "false";
    }

    public void setSubmitFormData(String value) {
        if (value != null && !value.toLowerCase().equals("true") && !value.toLowerCase().equals("false")) {
            CCDebug.trace1("Invalid parameter: " + value);
            return;
        }
        this.setValue(ATTRIB_SUBMITFORMDATA, value);
    }
}

