/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.taglib.tree;

import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.View;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCImage;
import com.sun.web.ui.common.CCJavascript;
import com.sun.web.ui.model.CCNavNode;
import com.sun.web.ui.model.CCNavNodeInterface;
import com.sun.web.ui.model.CCTreeModelInterface;
import com.sun.web.ui.taglib.tree.CCTreeTagBase;
import com.sun.web.ui.view.tree.CCClientSideTree;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;

public class CCClientSideTreeTag
extends CCTreeTagBase {
    protected CCClientSideTree treeView = null;
    protected static final String ATTRIB_IS_PERSISTENT = "isPersistent";
    protected static final String ATTRIB_TOP = "top";
    protected String jsTreeName = null;
    protected ArrayList openContainers = new ArrayList();

    public void reset() {
        super.reset();
        this.treeView = null;
    }

    protected String getHTMLStringInternal(Tag parent, PageContext pageContext, View view) throws JspException {
        int i;
        if (parent == null) {
            throw new IllegalArgumentException("parent cannot be null");
        }
        if (pageContext == null) {
            throw new IllegalArgumentException("pageContext cannot be null");
        }
        if (view == null) {
            throw new IllegalArgumentException("view cannot be null");
        }
        super.getHTMLStringInternal(parent, pageContext, view);
        this.checkChildType(view, CCClientSideTree.class);
        this.treeView = (CCClientSideTree)view;
        this.model = (CCTreeModelInterface)this.treeView.getModel();
        if (this.model == null) {
            CCDebug.trace1("Model is null.");
            return null;
        }
        this.initProperties();
        this.setParent(parent);
        this.setPageContext(pageContext);
        this.includeJavascriptFile(CCJavascript.BROWSER_VERSION_JS);
        this.includeJavascriptFile(CCJavascript.TREE_JS);
        NonSyncStringBuffer buffer = new NonSyncStringBuffer(8192);
        buffer.append("<script type=\"text/javascript\">\n");
        this.appendConstants(buffer);
        if (this.isNav4()) {
            buffer.append("doc.yPos = ").append(this.getTop() != null ? this.getTop() : "8").append(";\n");
        }
        List nodes = this.model.getNodes();
        this.jsTreeName = this.treeView.getQualifiedName().replace('.', '_');
        buffer.append("var ").append(this.jsTreeName).append("= new CCTree(\"").append(this.jsTreeName).append("\");\nvar container;\nvar object;\n");
        for (i = 0; i < nodes.size(); ++i) {
            CCNavNodeInterface node = (CCNavNodeInterface)nodes.get(i);
            this.outputNode(buffer, node, this.jsTreeName);
        }
        if (this.isTrue(this.getIsPersistent())) {
            buffer.append(this.jsTreeName).append(".isPersistent = true;\n");
        }
        buffer.append("var openContainers = new Array(");
        for (i = 0; i < this.openContainers.size(); ++i) {
            buffer.append("\"").append(this.openContainers.get(i)).append("\"");
            if (i >= this.openContainers.size() - 1) continue;
            buffer.append(", ");
        }
        buffer.append(");\n");
        buffer.append(this.jsTreeName).append(".target = \"").append(this.getTargetFrame() != null ? this.getTargetFrame() : "").append("\";\n").append(this.jsTreeName).append(".init(openContainers);\n");
        if (this.model.getSelectedNode() != null) {
            buffer.append("if (").append(this.jsTreeName).append(".selectedNode == null) {\n   ").append(this.jsTreeName).append(".yokeToAndLoad(").append(this.model.getSelectedNode().getId()).append(");\n};\n");
        }
        buffer.append("\n</script>\n");
        return buffer.toString();
    }

    protected void appendConstants(NonSyncStringBuffer buffer) {
        buffer.append("var CCTREE_BGCOLOR = \"");
        if (this.type != 2) {
            buffer.append("#E5E5E5");
        } else {
            buffer.append("#FFFFFF");
        }
        buffer.append("\";\nvar CCTREE_SELECTEDCOLOR = \"");
        if (this.type != 2) {
            buffer.append("#FFFFFF");
        } else {
            buffer.append("#E5E5E5");
        }
        buffer.append("\";\nvar CCTREE_SELECTED_ROW = \"");
        if (this.type != 2) {
            buffer.append("TreSelRow");
        } else {
            buffer.append("TreWhtSelRow");
        }
        buffer.append("\"; \nvar CCTREE_ROOT_ROW_STLYE = \"").append("TreRotRow").append("\";\nvar CCTREE_LINK_STYLE = \"").append("TreLnk").append("\";\nvar CCTREE_SPACER_WIDTH = ").append(this.getSpacerWidth() != null ? this.getSpacerWidth() : "5").append(";\nvar CCTREE_OPEN_LAST_SRC = \"").append(CCImage.TREE_HANDLE_DOWN_LAST).append("\";\nvar CCTREE_OPEN_MIDDLE_SRC = \"").append(CCImage.TREE_HANDLE_DOWN_MIDDLE).append("\";\nvar CCTREE_CLOSED_LAST_SRC = \"").append(CCImage.TREE_HANDLE_RIGHT_LAST).append("\";\nvar CCTREE_CLOSED_MIDDLE_SRC = \"").append(CCImage.TREE_HANDLE_RIGHT_MIDDLE).append("\";\nvar CCTREE_OPEN_TOP_SRC = \"").append(CCImage.TREE_HANDLE_DOWN_TOP).append("\";\nvar CCTREE_CLOSED_TOP_SRC = \"").append(CCImage.TREE_HANDLE_RIGHT_TOP).append("\";\nvar CCTREE_OPEN_TOP_NS_SRC = \"").append(CCImage.TREE_HANDLE_DOWN_TOP_NOSIBLING).append("\";\nvar CCTREE_CLOSED_TOP_NS_SRC = \"").append(CCImage.TREE_HANDLE_RIGHT_TOP_NOSIBLING).append("\";\nvar CCTREE_BLANK_SRC = \"").append(CCImage.TREE_BLANK).append("\";\nvar CCTREE_BLANK_IMG = \"<img src='").append(CCImage.TREE_BLANK).append("' border='0' width='16' height='22' alt=''>\";\n").append("var CCTREE_LINE_IMG = \"<img src='").append(CCImage.TREE_LINE_VERTICAL).append("' border='0' width='16' height='22' alt=''>\";\n").append("var CCTREE_LINE_FIRST_IMG = \"<img src='").append(CCImage.TREE_LINE_FIRST_NODE).append("' border='0' width='16' height='22' alt=''>\";\n").append("var CCTREE_LINE_LAST_IMG = \"<img src='").append(CCImage.TREE_LINE_LAST_NODE).append("' border='0' width='16' height='22' alt=''>\";\n").append("var CCTREE_LINE_MIDDLE_IMG = \"<img src='").append(CCImage.TREE_LINE_MIDDLE_NODE).append("' border='0' width='16' height='22' alt=''>\";\n").append("var CCTREE_TABINDEX = ").append(this.getTabIndex()).append(";\nvar CCTREE_TITLE = \"").append(this.treeTitle).append("\";\nvar CCTREE_ALTTXT = \"").append(this.treeAltText).append("\";\nvar CCTREE_TURNER_OPEN_ALTTXT = \"").append(this.turnerOpenAltText).append("\";\nvar CCTREE_TURNER_CLOSED_ALTTXT = \"").append(this.turnerClosedAltText).append("\";\nvar CCIMAGE_DOT_SRC =\"").append(CCImage.DOT).append("\";\nvar CCTREE_NODE_IMG_WIDTH=").append(new Integer("19").intValue()).append(";\n");
    }

    protected void outputNode(NonSyncStringBuffer buffer, CCNavNodeInterface node, String parentJsName) {
        int imageWidth;
        String image = this.getMessage(node.getImage());
        int depth = node.getLevel();
        String target = node.getTarget();
        boolean isContainer = node.getAcceptsChildren();
        if (isContainer) {
            if (image == null) {
                image = CCImage.TREE_FOLDER;
                switch (this.getMaximumChildSeverity(node)) {
                    case 2: {
                        image = CCImage.TREE_FOLDER_ALARM_CRITICAL;
                        break;
                    }
                    case 1: {
                        image = CCImage.TREE_FOLDER_ALARM_DOWN;
                        break;
                    }
                    case 3: {
                        image = CCImage.TREE_FOLDER_ALARM_MAJOR;
                        break;
                    }
                    case 4: {
                        image = CCImage.TREE_FOLDER_ALARM_MINOR;
                        break;
                    }
                }
            } else if (node.getAlarmSeverity() != 5) {
                image = this.getBadgeSrc(image, node.getAlarmSeverity(), 9, 9);
            }
            if (node.getExpanded()) {
                this.openContainers.add(Integer.toString(node.getId()));
            }
            buffer.append("container").append(depth).append(" = new CCContainerNode(\"");
        } else {
            if (image == null) {
                image = CCImage.TREE_DOCUMENT;
            }
            buffer.append("object = new CCObjectNode(\"");
            if (node.getAlarmSeverity() != 5) {
                image = this.getBadgeSrc(image, node.getAlarmSeverity(), 9, 9);
            }
        }
        buffer.append(this.getMessage(node.getLabel())).append("\", \"");
        String status = node.getStatus() != null ? node.getStatus() : node.getLabel();
        buffer.append(CCClientSideTreeTag.escapeJsQuotes(this.getMessage(status))).append("\", \"");
        boolean notClickable = node instanceof CCNavNode ? ((CCNavNode)node).getNotClickable() : false;
        int n = imageWidth = node instanceof CCNavNode ? ((CCNavNode)node).getImageWidth() : 19;
        if (notClickable) {
            buffer.append("null");
        } else {
            buffer.append(node.getValue());
        }
        buffer.append("\", \"").append(image).append("\", \"").append(node.getId()).append("\", ").append(imageWidth).append(", \"").append(node.getOnClick()).append("\", \"");
        if (this.getUseNodeTarget().equals("false")) {
            buffer.append(this.getTargetFrame());
        } else if (target != null) {
            buffer.append(target);
        } else {
            buffer.append(this.getTargetFrame());
        }
        buffer.append("\");\n");
        if (isContainer) {
            buffer.append(parentJsName).append(".addChild(container").append(depth).append(");\n");
            if (node.isRoot() && depth == 0) {
                buffer.append("container").append(depth).append(".isRoot = true;\n");
            }
            List children = node.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                CCNavNodeInterface child = (CCNavNodeInterface)children.get(i);
                this.outputNode(buffer, child, "container" + depth);
            }
        } else {
            buffer.append(parentJsName).append(".addChild(object);\n");
        }
    }

    public void setIsPersistent(String value) {
        this.setValue(ATTRIB_IS_PERSISTENT, value);
    }

    public String getIsPersistent() {
        return (String)this.getValue(ATTRIB_IS_PERSISTENT);
    }

    public void setTop(String value) {
        this.setValue(ATTRIB_TOP, value);
    }

    public String getTop() {
        return (String)this.getValue(ATTRIB_TOP);
    }
}

