/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.view.addremove;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.html.HiddenField;
import com.iplanet.jato.view.html.ListBox;
import com.iplanet.jato.view.html.OptionList;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCStateData;
import com.sun.web.ui.model.CCAddRemoveModelInterface;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.orderedlist.CCOrderedListBase;
import java.util.HashMap;
import java.util.Map;

public class CCAddRemove
extends CCOrderedListBase
implements CCStateData {
    public static final String ADD_BUTTON = "AddButton";
    public static final String ADDALL_BUTTON = "AddAllButton";
    public static final String REMOVE_BUTTON = "RemoveButton";
    public static final String REMOVEALL_BUTTON = "RemoveAllButton";
    public static final String AVAILABLE_LISTBOX = "AvailableListBox";
    public static final String AVAILABLE_TEXTFIELD = "AvailableTextField";
    private String allowAvailableMove = null;
    private Boolean sortOnAdd = null;

    public CCAddRemove(ContainerView parent, CCAddRemoveModelInterface model, String name) {
        super(parent, model, name);
        this.setDefaultModel(model);
    }

    protected void registerChildren() {
        super.registerChildren();
        this.registerChild(ADD_BUTTON, CCButton.class);
        this.registerChild(ADDALL_BUTTON, CCButton.class);
        this.registerChild(REMOVE_BUTTON, CCButton.class);
        this.registerChild(REMOVEALL_BUTTON, CCButton.class);
        this.registerChild(AVAILABLE_TEXTFIELD, HiddenField.class);
        this.registerChild(AVAILABLE_LISTBOX, ListBox.class);
    }

    protected View createChild(String name) {
        if (name.equals(ADD_BUTTON)) {
            CCButton child = new CCButton((ContainerView)this, name, null);
            child.setDisabled(true);
            return child;
        }
        if (name.equals(ADDALL_BUTTON)) {
            CCButton child = new CCButton((ContainerView)this, name, null);
            if (this.getModel().getAvailableOptionList(this).size() < 1) {
                child.setDisabled(true);
            } else {
                child.setDisabled(false);
            }
            return child;
        }
        if (name.equals(REMOVE_BUTTON)) {
            CCButton child = new CCButton((ContainerView)this, name, null);
            child.setDisabled(true);
            return child;
        }
        if (name.equals(REMOVEALL_BUTTON)) {
            CCButton child = new CCButton((ContainerView)this, name, null);
            if (this.getModel().getSelectedOptionList(this).size() < 1) {
                child.setDisabled(true);
            } else {
                child.setDisabled(false);
            }
            return child;
        }
        if (name.equals("MoveUpButton")) {
            CCButton child = new CCButton((ContainerView)this, name, null);
            child.setDisabled(true);
            return child;
        }
        if (name.equals("MoveDownButton")) {
            CCButton child = new CCButton((ContainerView)this, name, null);
            child.setDisabled(true);
            return child;
        }
        if (name.equals(AVAILABLE_LISTBOX)) {
            ListBox child = new ListBox((ContainerView)this, name, null);
            return child;
        }
        if (name.equals("SelectedListBox")) {
            ListBox child = new ListBox((ContainerView)this, name, null);
            return child;
        }
        if (name.equals(AVAILABLE_TEXTFIELD) || name.equals("SelectedTextField")) {
            HiddenField child = new HiddenField((ContainerView)this, name, null);
            return child;
        }
        return super.createChild(name);
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        this.restoreStateData();
        this.setDisplayFieldValue(AVAILABLE_TEXTFIELD, this.getOptions(this.getModel().getAvailableOptionList()));
        this.setDisplayFieldValue("SelectedTextField", this.getOptions(this.getModel().getSelectedOptionList()));
    }

    public Map getStateData() {
        this.restoreStateData();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(AVAILABLE_LISTBOX, this.getOptions(this.getModel().getAvailableOptionList()));
        map.put("SelectedListBox", this.getOptions(this.getModel().getSelectedOptionList()));
        return map;
    }

    public void setStateData() {
        this.restoreStateData();
    }

    public void setStateData(Map map) {
        this.resetStateData();
        if (map == null) {
            CCDebug.trace1("State data map is null");
            return;
        }
        this.getModel().setAvailableOptionList(this.getOptions((String)map.get(AVAILABLE_LISTBOX)));
        this.getModel().setSelectedOptionList(this.getOptions((String)map.get("SelectedListBox")));
    }

    public void reset() {
        this.resetStateData();
    }

    public void resetStateData() {
        this.setDisplayFieldValue(AVAILABLE_TEXTFIELD, null);
        this.setDisplayFieldValue("SelectedTextField", null);
    }

    public void restoreStateData() {
        OptionList availableOptionList = this.getModel().getAvailableOptionList(this);
        OptionList selectedOptionList = this.getModel().getSelectedOptionList(this);
        if (availableOptionList != null || selectedOptionList != null) {
            this.getModel().setAvailableOptionList(availableOptionList);
            this.getModel().setSelectedOptionList(selectedOptionList);
        }
    }

    public boolean isAllowAvailableMoveSet() {
        return this.allowAvailableMove != null;
    }

    public void setAllowAvailableMove(boolean allow) {
        this.allowAvailableMove = Boolean.toString(allow);
    }

    public boolean getAllowAvailableMove() {
        return this.allowAvailableMove == null ? false : new Boolean(this.allowAvailableMove);
    }

    public boolean isSortOnAddSet() {
        return this.sortOnAdd != null;
    }

    public void setSortOnAdd(boolean sort) {
        this.sortOnAdd = sort;
    }

    public boolean getSortOnAdd() {
        return this.isSortOnAddSet() ? this.sortOnAdd : false;
    }

    public CCAddRemoveModelInterface getModel() {
        return (CCAddRemoveModelInterface)this.model;
    }
}

