/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.view.datetime;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.RequestHandlingViewBase;
import com.iplanet.jato.view.View;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCI18N;
import com.sun.web.ui.model.CCDateTimeModelInterface;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import sun.text.resources.LocaleData;

public abstract class CCDateTimeBase
extends RequestHandlingViewBase {
    public static final String DEFAULT_TIME_VALUE = "  ";
    public static final String INTERVAL_PREFIX = "interval";
    public static final String LIMITUNIT_PREFIX = "limitUnit";
    protected Locale locale = null;
    protected String dateFormatPattern = null;
    protected SimpleDateFormat dateFormat = null;
    protected CCDateTimeModelInterface model = null;
    protected String year = null;
    protected String day = null;
    protected String month = null;
    private Boolean showPreviewButton = null;

    public CCDateTimeBase(ContainerView parent, CCDateTimeModelInterface model, String name) {
        super((View)parent, name);
        CCDebug.initTrace();
        CCI18N.setResourceBundle((ServletRequest)RequestManager.getRequest(), (ServletResponse)RequestManager.getResponse(), "com.sun.web.ui.resources.Resources", "com.sun.web.ui", null);
        ResourceBundle bundle = CCI18N.getResourceBundle((ServletRequest)RequestManager.getRequest(), "com.sun.web.ui");
        this.locale = bundle.getLocale();
        this.initDateFormat();
        this.setModel(model);
    }

    protected void initDateFormat() {
        ResourceBundle r = LocaleData.getLocaleElements((Locale)this.locale);
        String[] dateTimePatterns = r.getStringArray("DateTimePatterns");
        String pattern = dateTimePatterns[7];
        boolean bYearSet = false;
        boolean bMonthSet = false;
        boolean bDaySet = false;
        String newPattern = "";
        int length = pattern.length();
        for (int i = 0; i < length; ++i) {
            if (pattern.charAt(i) == 'y') {
                if (bYearSet) continue;
                bYearSet = true;
                newPattern = newPattern + "yyyy/";
                continue;
            }
            if (pattern.charAt(i) == 'M') {
                if (bMonthSet) continue;
                bMonthSet = true;
                newPattern = newPattern + "MM/";
                continue;
            }
            if (pattern.charAt(i) != 'd' || bDaySet) continue;
            bDaySet = true;
            newPattern = newPattern + "dd/";
        }
        this.dateFormatPattern = newPattern = newPattern.substring(0, newPattern.length() - 1);
        this.dateFormat = new SimpleDateFormat(newPattern, this.locale);
        this.dateFormat.setLenient(false);
    }

    public String validateDateString(String date) {
        if (date == null) {
            return null;
        }
        StringTokenizer dateFormatST = new StringTokenizer(this.dateFormatPattern, "/");
        String[] patterns = new String[dateFormatST.countTokens()];
        int[] patternLengths = new int[dateFormatST.countTokens()];
        int index = 0;
        while (dateFormatST.hasMoreTokens()) {
            String s;
            patterns[index] = s = dateFormatST.nextToken();
            patternLengths[index] = s.length();
            ++index;
        }
        StringTokenizer st = new StringTokenizer(date, "/");
        index = 0;
        if (st.countTokens() != patternLengths.length) {
            return null;
        }
        String newDate = "";
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (patterns[index].equals("yyyy") && token.length() == 2) {
                token = "20" + token;
            } else if (token.length() != patternLengths[index]) {
                return null;
            }
            ++index;
            newDate = newDate + token + "/";
        }
        date = newDate.substring(0, newDate.length() - 1);
        return date;
    }

    public void setModel(CCDateTimeModelInterface model) {
        this.model = model;
    }

    public CCDateTimeModelInterface getModel() {
        return this.model;
    }

    public Calendar getCalendar() {
        Calendar c = Calendar.getInstance(this.locale);
        if (this.model != null && this.model.getTimeZone() != null) {
            c = Calendar.getInstance(this.model.getTimeZone(), this.locale);
        }
        return c;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public String getDateFormatPattern() {
        return this.dateFormatPattern;
    }

    public Boolean getShowPreviewButton() {
        return this.showPreviewButton;
    }

    public void setShowPreviewButton(boolean show) {
        this.showPreviewButton = new Boolean(show);
    }
}

