/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.view.tabs;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.RequestHandlingViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCStateData;
import com.sun.web.ui.model.CCNavNodeInterface;
import com.sun.web.ui.model.CCTabsModelInterface;
import com.sun.web.ui.view.html.CCHref;
import com.sun.web.ui.view.tabs.CCNodeEventHandlerInterface;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;

public class CCTabs
extends RequestHandlingViewBase
implements CCStateData {
    public static final String CHILD_TABHREF = "TabHref";
    private final String LOCAL_TAB_ID = "CCTabs.SelectedTabId";
    private CCTabsModelInterface model = null;

    public CCTabs(View parent, CCTabsModelInterface model, String name) {
        super(parent, name);
        CCDebug.initTrace();
        if (model == null) {
            return;
        }
        this.setCCTabsModel(model);
        this.registerChildren();
    }

    protected void registerChildren() {
        this.registerChild(CHILD_TABHREF, CCHref.class);
    }

    protected View createChild(String name) {
        if (name.equals(CHILD_TABHREF)) {
            CCHref child = new CCHref((ContainerView)this, name, null);
            return child;
        }
        throw new IllegalArgumentException("Invalid child name [" + name + "]");
    }

    public void handleTabHrefRequest(RequestInvocationEvent event) throws ServletException, IOException {
        this.restoreStateData();
        ViewBean vb = this.getParentViewBean();
        String value = (String)this.getDisplayFieldValue(CHILD_TABHREF);
        vb.setPageSessionAttribute("CCTabs.SelectedTabId", (Serializable)((Object)value));
        String forward = event.getRequestContext().getRequest().getParameter("reloadPage");
        if (forward != null && forward.equals("true")) {
            vb.forwardTo(this.getRequestContext());
        } else {
            int id = -1;
            try {
                id = Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                CCDebug.trace1("Could not get tab ID: " + nfe.getMessage());
            }
            ((CCNodeEventHandlerInterface)vb).nodeClicked(event, id);
        }
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        this.restoreStateData();
    }

    public void setStateData(Map map) {
        this.resetStateData();
        if (map == null) {
            CCDebug.trace1("State data map is null");
            return;
        }
        if (this.model == null) {
            CCDebug.trace3("Tabs model is null.");
            return;
        }
        if (map.get("CCTabs.SelectedTabId") != null) {
            this.model.setSelectedNode((Integer)map.get("CCTabs.SelectedTabId"));
        }
    }

    public Map getStateData() {
        if (this.model == null) {
            CCDebug.trace3("Tabs model is null.");
            return null;
        }
        this.restoreStateData();
        HashMap<String, CCNavNodeInterface> map = new HashMap<String, CCNavNodeInterface>();
        map.put("CCTabs.SelectedTabId", this.model.getSelectedNode());
        return map;
    }

    public void resetStateData() {
        this.getParentViewBean().setPageSessionAttribute("CCTabs.SelectedTabId", null);
    }

    public void restoreStateData() {
        if (this.model == null) {
            CCDebug.trace3("Tabs model is null.");
            return;
        }
        String value = (String)this.getParentViewBean().getPageSessionAttribute("CCTabs.SelectedTabId");
        if (value != null) {
            try {
                this.model.setSelectedNode(Integer.parseInt(value));
            }
            catch (Exception e) {
                CCDebug.trace1("Could not set selected tab: " + e.getMessage());
            }
        }
    }

    public CCTabsModelInterface getCCTabsModel() {
        return (CCTabsModelInterface)this.getDefaultModel();
    }

    public void setCCTabsModel(CCTabsModelInterface value) {
        if (value == null) {
            CCDebug.trace3("Tabs model is null.");
            return;
        }
        this.model = value;
        this.setDefaultModel(value);
    }

    public void reset() {
        this.resetStateData();
    }

    public void setStateData() {
        this.restoreStateData();
    }
}

