/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.view.topology;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.view.CommandFieldBase;
import com.iplanet.jato.view.CommandSourceTargetPair;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.model.CCTopologyModelInterface;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public final class CCTopology
extends CommandFieldBase {
    private CCTopologyModelInterface model;

    public CCTopology(ContainerView parent, String name, CCTopologyModelInterface model) {
        super(parent, name, null);
        this.setTopologyModel(model);
        CCTopology.expandSimilarGroupNodes(this.getSavedTopologyModel(RequestManager.getSession()), model);
    }

    protected Object getSourceValue(CommandSourceTargetPair pair, int position) {
        return null;
    }

    public CCTopologyModelInterface getTopologyModel() {
        return this.model;
    }

    public CCTopologyModelInterface getSavedTopologyModel(HttpSession session) {
        try {
            String attr = "CCTopology." + this.getQualifiedName();
            SoftReference softRef = (SoftReference)session.getAttribute(attr);
            return (CCTopologyModelInterface)softRef.get();
        }
        catch (NullPointerException npe) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }

    public void setTopologyModel(CCTopologyModelInterface model) {
        if (model == null) {
            throw new IllegalArgumentException("model == null");
        }
        this.model = model;
    }

    public String getRequestId(RequestInvocationEvent event) {
        HttpServletRequest request = event.getRequestContext().getRequest();
        return request.getParameter("cctopologyid");
    }

    public String getRequestAction(RequestInvocationEvent event) {
        HttpServletRequest request = event.getRequestContext().getRequest();
        return request.getParameter("cctopologyaction");
    }

    public String[] getRequestGroupEdgeNodeIds(RequestInvocationEvent event) {
        String id = this.getRequestId(event);
        String action = this.getRequestAction(event);
        if (id != null) {
            int sep = id.indexOf("^cc^");
            int sep2 = id.indexOf("^cc^", sep + 1);
            if (sep != -1 && sep2 != -1) {
                return new String[]{id.substring(0, sep), id.substring(sep + "^cc^".length(), sep2)};
            }
        }
        return null;
    }

    public int getRequestGroupEdgeBadge(RequestInvocationEvent event) {
        String id = this.getRequestId(event);
        String action = this.getRequestAction(event);
        if (id != null) {
            int sep = id.indexOf("^cc^");
            int sep2 = id.indexOf("^cc^", sep + 1);
            if (sep != -1 && sep2 != -1) {
                try {
                    return Integer.parseInt(id.substring(sep2 + "^cc^".length()));
                }
                catch (NumberFormatException nfe) {
                    return 0;
                }
            }
        }
        return 0;
    }

    public boolean handleRequest(RequestInvocationEvent event) {
        CCTopologyModelInterface oldModel = this.getSavedTopologyModel(event.getRequestContext().getRequest().getSession());
        if (oldModel == null) {
            oldModel = this.model;
        }
        Map oldModelMap = null;
        boolean eventHandled = false;
        try {
            String action = this.getRequestAction(event);
            boolean open = "cctrno".equals(action);
            if (open || "cctrnc".equals(action)) {
                CCTopologyModelInterface.GroupNode node = (CCTopologyModelInterface.GroupNode)oldModel.getNode(this.getRequestId(event));
                if (node != null) {
                    node.setExpanded(open);
                }
                eventHandled = true;
            } else if ("ccGedg".equals(action)) {
                String[] nodeIds = this.getRequestGroupEdgeNodeIds(event);
                if (nodeIds != null) {
                    for (int i = 0; i < nodeIds.length; ++i) {
                        CCTopologyModelInterface.Node node = oldModel.getNode(nodeIds[i]);
                        if (!(node instanceof CCTopologyModelInterface.GroupNode)) continue;
                        ((CCTopologyModelInterface.GroupNode)node).setExpanded(true);
                    }
                    eventHandled = true;
                }
            } else if ("ccGnodb".equals(action)) {
                CCTopologyModelInterface.GroupNode node = (CCTopologyModelInterface.GroupNode)oldModel.getNode(this.getRequestId(event));
                int badge = node.getBadge();
                if (node != null && badge != 0) {
                    ArrayList<CCTopologyModelInterface.Node> groupNodes = new ArrayList<CCTopologyModelInterface.Node>();
                    groupNodes.add(node);
                    while (groupNodes.size() > 0) {
                        node = (CCTopologyModelInterface.GroupNode)groupNodes.remove(0);
                        node.setExpanded(true);
                        CCTopologyModelInterface.Node[] children = node.getNodes();
                        for (int c = 0; c < children.length; ++c) {
                            if (children[c].getBadge() != badge || !(children[c] instanceof CCTopologyModelInterface.GroupNode)) continue;
                            groupNodes.add(children[c]);
                        }
                    }
                }
                eventHandled = true;
            } else if ("ccGedgb".equals(action)) {
                String[] nodeIds = this.getRequestGroupEdgeNodeIds(event);
                int badge = this.getRequestGroupEdgeBadge(event);
                if (badge != 0 && nodeIds != null) {
                    oldModelMap = NodeData.createNodeDataMap(oldModel);
                    CCTopologyModelInterface.Edge[] edges = oldModel.getEdges();
                    for (int e = 0; e < edges.length; ++e) {
                        if (edges[e] == null || edges[e].getBadge() != badge) continue;
                        CCTopologyModelInterface.Node source = edges[e].getSource();
                        CCTopologyModelInterface.Node destination = edges[e].getDestination();
                        if (source == null || destination == null) continue;
                        NodeData sourceData = (NodeData)oldModelMap.get(source.getId());
                        NodeData destinationData = (NodeData)oldModelMap.get(destination.getId());
                        if (sourceData == null || destinationData == null) continue;
                        boolean sourceOpened = sourceData.openIfDescendent(nodeIds);
                        boolean destinationOpened = destinationData.openIfDescendent(nodeIds);
                    }
                }
                eventHandled = true;
            }
        }
        catch (Exception e) {
            CCDebug.trace1("Could not handle request", e);
        }
        CCTopology.expandSimilarGroupNodes(oldModel, this.model, oldModelMap);
        return eventHandled;
    }

    protected static void expandSimilarGroupNodes(CCTopologyModelInterface fromModel, CCTopologyModelInterface toModel) {
        CCTopology.expandSimilarGroupNodes(fromModel, toModel, null);
    }

    private static void expandSimilarGroupNodes(CCTopologyModelInterface oldModel, CCTopologyModelInterface model, Map oldModelMap) {
        if (oldModel != null && model != null && model != oldModel) {
            NodeData newNode;
            int t;
            if (oldModelMap == null) {
                oldModelMap = NodeData.createNodeDataMap(oldModel);
            }
            Map newModelMap = NodeData.createNodeDataMap(model);
            ArrayList<CCTopologyModelInterface.Node> nodeList = new ArrayList<CCTopologyModelInterface.Node>();
            for (t = 0; t < oldModel.getTierCount(); ++t) {
                nodeList.addAll(Arrays.asList(oldModel.getTierNodes(t)));
            }
            while (nodeList.size() > 0) {
                CCTopologyModelInterface.Node node = (CCTopologyModelInterface.Node)nodeList.remove(0);
                if (node instanceof CCTopologyModelInterface.GroupNode) {
                    nodeList.addAll(Arrays.asList(((CCTopologyModelInterface.GroupNode)node).getNodes()));
                    continue;
                }
                NodeData oldNode = (NodeData)oldModelMap.get(node.getId());
                newNode = (NodeData)newModelMap.get(node.getId());
                if (oldNode == null || newNode == null || oldNode.depth != newNode.depth) continue;
                NodeData oldParent = oldNode.parent;
                NodeData newParent = newNode.parent;
                while (oldParent != null && newParent != null) {
                    newParent.openVotes = oldParent.isOpen ? ++newParent.openVotes : --newParent.openVotes;
                    oldParent = oldParent.parent;
                    newParent = newParent.parent;
                }
            }
            for (t = 0; t < model.getTierCount(); ++t) {
                nodeList.addAll(Arrays.asList(model.getTierNodes(t)));
            }
            while (nodeList.size() > 0) {
                CCTopologyModelInterface.Node node = (CCTopologyModelInterface.Node)nodeList.remove(0);
                if (!(node instanceof CCTopologyModelInterface.GroupNode)) continue;
                CCTopologyModelInterface.GroupNode gNode = (CCTopologyModelInterface.GroupNode)node;
                nodeList.addAll(Arrays.asList(gNode.getNodes()));
                newNode = (NodeData)newModelMap.get(node.getId());
                if (newNode == null) continue;
                gNode.setExpanded(newNode.openVotes > 0);
            }
        }
    }

    static final class NodeData {
        public int openVotes = 0;
        public final CCTopologyModelInterface.Node node;
        public final NodeData parent;
        public final int depth;
        public boolean isOpen;

        public NodeData(NodeData parent, CCTopologyModelInterface.Node node) {
            this.node = node;
            this.parent = parent;
            this.depth = parent == null ? 0 : parent.depth + 1;
            this.isOpen = node instanceof CCTopologyModelInterface.GroupNode ? ((CCTopologyModelInterface.GroupNode)node).isExpanded() : false;
        }

        public boolean openIfDescendent(String[] nodeIds) {
            String id = this.node.getId();
            for (int n = 0; n < nodeIds.length; ++n) {
                if (!id.equals(nodeIds[n])) continue;
                this.isOpen = true;
                return true;
            }
            if (this.parent != null && this.parent.openIfDescendent(nodeIds)) {
                this.isOpen = true;
                return true;
            }
            return false;
        }

        public static Map createNodeDataMap(CCTopologyModelInterface model) {
            HashMap map = new HashMap();
            for (int t = 0; t < model.getTierCount(); ++t) {
                NodeData.addNodeData(map, null, model.getTierNodes(t));
            }
            return map;
        }

        private static void addNodeData(Map map, NodeData parent, CCTopologyModelInterface.Node[] nodes) {
            for (int n = 0; n < nodes.length; ++n) {
                if (nodes[n] == null) continue;
                NodeData nodeData = new NodeData(parent, nodes[n]);
                map.put(nodes[n].getId(), nodeData);
                if (!(nodes[n] instanceof CCTopologyModelInterface.GroupNode)) continue;
                NodeData.addNodeData(map, nodeData, ((CCTopologyModelInterface.GroupNode)nodes[n]).getNodes());
            }
        }
    }
}

