/*
 * Decompiled with CFR 0.152.
 */
package com.sun.genericra.inbound;

import com.sun.genericra.AbstractXAResourceType;
import com.sun.genericra.XAResourceType;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class InboundXAResourceProxy
extends AbstractXAResourceType {
    private XAResource xar = null;
    private boolean toRollback = true;
    private boolean rolledback = false;
    private boolean suspended = false;
    private boolean endCalled = false;
    private Xid savedxid = null;

    public InboundXAResourceProxy(XAResource xar) {
        this.xar = xar;
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        this.xar.commit(this.savedXid(), onePhase);
    }

    public void end(Xid xid, int flags) throws XAException {
        if (!this.beingRedelivered()) {
            this.xar.end(this.savedXid(), flags);
            if (flags == 0x2000000) {
                this.suspended = true;
            }
            this.endCalled = true;
        }
    }

    private boolean beingRedelivered() {
        return this.endCalled && !this.suspended;
    }

    public void forget(Xid xid) throws XAException {
        this.xar.forget(this.savedXid());
    }

    public int getTransactionTimeout() throws XAException {
        return this.xar.getTransactionTimeout();
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        XAResource inxa = xares;
        if (xares instanceof XAResourceType) {
            XAResourceType wrapper = (XAResourceType)((Object)xares);
            inxa = (XAResource)wrapper.getWrappedObject();
            if (!this.compare(wrapper)) {
                return false;
            }
        }
        return this.xar.isSameRM(inxa);
    }

    public int prepare(Xid xid) throws XAException {
        return this.xar.prepare(this.savedXid());
    }

    public Xid[] recover(int flag) throws XAException {
        return this.xar.recover(flag);
    }

    public void rollback(Xid xid) throws XAException {
        this.rolledback = true;
        if (this.toRollback) {
            this.xar.rollback(this.savedXid());
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return this.xar.setTransactionTimeout(seconds);
    }

    public void start(Xid xid, int flags) throws XAException {
        if (this.beingRedelivered()) {
            return;
        }
        int actualflag = flags;
        if (this.savedxid == null) {
            this.savedxid = xid;
        } else if (flags == 0 && this.rolledback) {
            this.rolledback = false;
            this.endCalled = false;
            if (this.suspended) {
                this.suspended = false;
                actualflag = 0x8000000;
            } else {
                actualflag = 0x200000;
            }
        }
        this.xar.start(this.savedXid(), actualflag);
    }

    public Object getWrappedObject() {
        return this.xar;
    }

    void setToRollback(boolean flag) {
        this.toRollback = flag;
    }

    boolean endCalled() {
        return this.endCalled;
    }

    private Xid savedXid() {
        return this.savedxid;
    }
}

