/*
 * Decompiled with CFR 0.152.
 */
package com.sun.genericra.outbound;

import com.sun.genericra.outbound.ConnectionRequestInfo;
import com.sun.genericra.util.ExceptionUtils;
import com.sun.genericra.util.LogUtils;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;

public class ConnectionFactory
implements javax.jms.ConnectionFactory,
TopicConnectionFactory,
QueueConnectionFactory,
Serializable,
Referenceable {
    private ManagedConnectionFactory mcf;
    private ConnectionManager cm;
    private Reference ref;
    private static Logger logger = LogUtils.getLogger();

    public ConnectionFactory(ManagedConnectionFactory mcf, ConnectionManager cm) {
        this.mcf = mcf;
        this.cm = cm;
    }

    public Connection createConnection() throws JMSException {
        Connection con = null;
        try {
            con = (Connection)this.cm.allocateConnection(this.mcf, null);
        }
        catch (ResourceException e) {
            logger.log(Level.INFO, e.getMessage(), e);
            throw ExceptionUtils.newJMSException(e);
        }
        return con;
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        ConnectionRequestInfo info = new ConnectionRequestInfo(this.mcf, userName, password);
        Connection con = null;
        try {
            con = (Connection)this.cm.allocateConnection(this.mcf, (javax.resource.spi.ConnectionRequestInfo)info);
        }
        catch (ResourceException e) {
            logger.log(Level.INFO, e.getMessage(), e);
            throw ExceptionUtils.newJMSException(e);
        }
        return con;
    }

    public TopicConnection createTopicConnection() throws JMSException {
        return (TopicConnection)this.createConnection();
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        return (TopicConnection)this.createConnection(userName, password);
    }

    public QueueConnection createQueueConnection() throws JMSException {
        return (QueueConnection)this.createConnection();
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        return (QueueConnection)this.createConnection(userName, password);
    }

    public void setReference(Reference ref) {
        this.ref = ref;
    }

    public Reference getReference() {
        return this.ref;
    }
}

