function Scheduler(datePickerId, fieldId, dateClass,
		   selectedClass, edgeClass, edgeSelectedClass,
		   todayClass, dateFormat) { 
    this.dateLinkId = datePickerId + ":dateLink"; 
    this.dateFieldId = fieldId;
    this.dateClass = dateClass;
    this.selectedClass = selectedClass;
    this.edgeClass = edgeClass;
    this.edgeSelectedClass = edgeSelectedClass;
    this.todayClass = todayClass;
    this.dateFormat = dateFormat;	
    this.setSelected = scheduler_setSelected;
    this.setDateValue = scheduler_setDateValue; 
    this.isToday = scheduler_isToday;	
} 

function scheduler_setDateValue(value, link) {
    field_setValue(this.dateFieldId, value); 
    this.setSelected(link);	
} 

function scheduler_setSelected(link) {
    if (link == null) {
	return;
    }

    var dateLink;	
    var linkNum = 0;	

    // Remove any prior highlight 
    while (linkNum< 42) {
	dateLink = document.getElementById(this.dateLinkId + linkNum);  
	if (dateLink == null) {
	    break;    
	}

	if (dateLink.className == this.edgeSelectedClass) {
	    dateLink.className = this.edgeClass;
	} else if (dateLink.className == this.selectedClass) {
	    if (this.isToday(dateLink.title)) {
	        dateLink.className = this.todayClass;
	    } else {
	        dateLink.className = this.dateClass;
	    }
	}
	linkNum++;
    }

    // apply the selected style to highlight the selected link
    if (link.className == this.dateClass || 
            link.className == this.todayClass) {	
	link.className = this.selectedClass;
    } else if (link.className = this.edgeClass) {
	link.className = this.edgeSelectedClass;
    }
	
    this.currentSelection = link;	
}

// Find out if date is today's date
function scheduler_isToday(date) {
    var todaysDate = new Date();

    var pattern = new String(this.dateFormat); 
    var yearIndex = pattern.indexOf("yyyy"); 
    var monthIndex = pattern.indexOf("MM"); 
    var dayIndex = pattern.indexOf("dd"); 

    var currYear = todaysDate.getFullYear(); 
    var currMonth = todaysDate.getMonth() + 1; 
    var currDay = todaysDate.getDate(); 

    if (currYear == parseInt(date.substr(yearIndex, 4)) &&
	    currMonth == parseInt(date.substr(monthIndex, 2)) &&
	    currDay == parseInt(date.substr(dayIndex, 2))) {
	return true;
    }
    return false;
}

