#!/usr/bin/perl

#
# Copyright 2006 Sun Microsystems, Inc. All rights reserved.
# Use is subject to license terms
# 
use Getopt::Long;
use English;
use FileHandle;
require "ctime.pl";

# Definitions
use Env qw(HOST);
$rm = "rm -rf";
$pkgaddLog = "/tmp/pkgaddLog.$$";
$asadmin = "/usr/share/sunappserver/bin/asadmin";
$confRoot = "/usr/share/sunappserver/config";
$sampleDir = "/usr/share/sunappserver/samples";
$installDir = "/usr/share/sunappserver";
$javaHome = "/usr/lib/jvm/java-1.5.0-sun";
$basedir = "/usr/share/sunappserver";
$bindir = "/usr/share/sunappserver/bin";
$install = "/usr/share/sunappserver/config";
$shareDir = "/usr/share";
$docs = "/usr/share/sunappserver/docs";
$imqDir = "$installDir/imq";
$arch=`dpkg-architecture -qDEB_HOST_ARCH`;
chomp $arch;

# main.
print "\n";
print "__________________________________________________________\n";
print "Start processing at    ", &ctime(time), "\n";

# Reading info.
sub read_inf($) {
    my ($file) = @_;
    open F, "< $file" or die "$!, reading from $file";
    # m/^\s*\[[^\[\]]+\]\s*$/;
    my @vals = map { m/^\s*([^= \t]+)\s*[= \t]\s*(.+)/ ? (lc $1,$2) : () } <F>;
    close F;
    return @vals;
}

$inf_file = "$install/install/conf.linux.txt";
my %NVP = read_inf $inf_file;
$domainRoot = $NVP{domainroot};
$adminUser = $NVP{adminuser};
$adminPort = $NVP{adminport};
$adminPasswd = $NVP{adminpasswd};
$instanceport = $NVP{serverport};


# install existing packages
$retCode = system("mkdir -p $basedir/bin");

print "/bin/sh $install/install/appservenv $install $basedir\n";
$retCode = system("/bin/sh $install/install/appservenv $install $basedir");
if ($retCode ne "0")
{
	print "Failed to do token replacement #1.\n";
	exit 1
}
print "/bin/sh $install/install/asenv $install $basedir $basedir $javaHome\n";
$retCode = system("/bin/sh $install/install/asenv $install $basedir $basedir $javaHome");
if ($retCode ne "0")
{
	print "Failed to do token replacement #2.\n";
	exit 1
}
#  rename("$sampleDir/common.properties", "$sampleDir/common.properties.orig");
#  open(F1, "<$sampleDir/common.properties.orig");
#  open(F2, ">$sampleDir/common.properties") || die ("common.properties cannot be opened\n");
#  while (<F1>)
#  {
#     if (m/^com.sun.aas.pointbaseRoot=/) {s/=.*$/=$installDir\/pointbase/;}
#     if (m/^com.sun.aas.webServicesLib=/) {s/=.*$/=$installDir\/lib/;}
#     if (m/^com.sun.aas.imqLib=/) {s/=.*$/=$instasllDir\/imq\/lib/;}
#     if (m/^com.sun.aas.installRoot=/) {s/=.*$/=$installDir/;}
#     if (m/^com.sun.aas.javaRoot=/) {s/=.*$/=$javaHome/;}
#	 if (m/^#admin.password=/) {s/#admin.password=.*$/admin.password=$adminPasswd/;}
#     if (m/^admin.host=/) {s/=.*$/=localhost/;}
#     if (m/^appserver.instance.port=/) {s/=.*$/=$instanceport/;}
#     if (m/^admin.user=/) {s/=.*$/=$adminUser/;}
#     if (m/^admin.port=/) {s/=.*$/=$adminPort/;}
#	 if (m/^appserver.instance=/) {s/=.*$/=server/;}
#     if (m/^pointbase.port=/) {s/=.*$/=9092/;}
#     print F2 ("$_");
#  }
#  close(F1);
#  close(F2);

  $SUN_acc = "$domainRoot/domain1/config/sun-acc.xml";
  rename("$confRoot/asenv.conf", "$confRoot/asenv.conf.orig");
  open(F3, "<$confRoot/asenv.conf.orig");
  open(F4, ">$confRoot/asenv.conf") || die ("asenv.conf cannot be opened\n");
  while (<F3>)
  {
     if (m/^AS_ACC_CONFIG=/) {s/=.*$/="$SUN_acc"/;}
     if (m/^AS_DEF_DOMAINS_PATH=/) {s/=.*$/="$domainRoot"/;}
     if (m/^AS_IMQ_LIB=/) {s/=.*$/="$installDir\/imq\/lib"/;}
     if (m/^AS_IMQ_BIN=/) {s/=.*$/="$installDir\/imq\/bin"/;}
     if (m/^AS_ANT=/) {s/=.*$/="$shareDir\/ant"/;}
     if (m/^AS_ANT_LIB=/) {s/=.*$/="$shareDir\/ant\/lib"/;}
     if (m/^AS_JHELP=/) {s/=.*$/="$installDir\/lib"/;}
     if (m/^AS_ICU_LIB=/) {s/=.*$/="$installDir\/lib"/;}
     if (m/^AS_JATO_LIB=/) {s/=.*$/="$installDir\/lib"/;}
     if (m/^AS_WEBCONSOLE_LIB=/) {s/=.*$/="$installDir\/lib"/;}
     if (m/^AS_CONFIG=/) {s/=.*$/="$installDir\/config"/;}
     if (m/^AS_INSTALL=/) {s/=.*$/="$installDir"/;}
     if (m/^AS_DERBY_INSTALL=/) {s/=.*$/="$installDir\/javadb"/;}
     if (m/^AS_WEBSERVICES_LIB=/) {s/=.*$/="$installDir\/lib"/;}
     if (m/^AS_JAVA=/) {s/=.*$/="$javaHome"/}
     if (m/^AS_NATIVE_LAUNCHER=/) {s/=.*$/="false"/}
     if (m/^AS_NATIVE_LAUNCHER_LIB_PREFIX=/) {s/=.*$/="$javaHome\/jre\/lib\/$arch\/server"/}
     print F4 ("$_");
  }
  close(F3);
  close(F4);

  if (-f "$imqDir/etc/imqenv.conf")
  {
    rename("$imqDir/etc/imqenv.conf", "$imqDir/etc/imqenv.conf.orig");
    open(F5, "<$imqDir/etc/imqenv.conf.orig");
    open(F6, ">$imqDir/etc/imqenv.conf") || die ("imqenv.conf cannot be opened\n");
    while (<F5>)
    {
       if (m/^# IMQ_DEFAULT_JAVAHOME/) {s/# IMQ_DEFAULT_JAVAHOME=.*$/IMQ_DEFAULT_JAVAHOME="$javaHome"/;}
       if (m/^# IMQ_DEFAULT_VARHOME/) {s/# IMQ_DEFAULT_VARHOME=.*$/IMQ_DEFAULT_VARHOME="$installDir\/domains\/domain1\/imq"/;}
       print F6 ("$_");
    }
    close(F5);
    close(F6);
  }
  $retCode = system("mkdir -p $domainRoot");
  if ($retCode ne "0")
  {
	print "Failed to create domain directory : $domainRoot\n";
	exit 1;
  }
  
  # create the domain if it does not already exist
  $retCode = system("sh $install/install/create.sh $basedir $domainRoot $adminPort $adminUser $installDir/config/install/default/passwordfile $instanceport domain1");
  if ($retCode eq "0")
  {
	# start the domain up
        $retCode = system("sh $install/install/start.sh $bindir $adminUser $installDir/config/install/default/passwordfile");
  }

#  $docRoot = "$domainRoot/domain1/docroot";
#  $retCode = system("cp -r $basedir/lib/install/docs/ $basedir");
  
#  $retCode = system("cd $sampleDir; find . -name docs > docslist;");
#  $retCode = system("./xcp $docRoot/samples $sampleDir/docslist $sampleDir");
#  $retCode = system("mkdir -p $docRoot/samples");
#  $retCode = system("cp -r $sampleDir/index.html $docRoot/samples/");
#  $retCode = system("cp -r $sampleDir/indexSamplesDomain.html $docRoot/samples/");
#  $retCode = system("rm $sampleDir/docslist");
print "__________________________________________________________\n";
print "Finished processing at ", &ctime(time), "\n";  

