/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-cli/cli-api/src/java/com/sun/cli/jmx/cmd/ArgHelperOptionsInfoTest.java,v 1.3 2005/12/25 03:45:28 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:45:28 $
 */
package com.sun.cli.jmx.cmd;

import java.util.ArrayList;
import java.util.Iterator;
 


public class ArgHelperOptionsInfoTest extends junit.framework.TestCase
{

		public void
	testCreate()
		throws ArgHelper.IllegalOptionException
	{
		new ArgHelperOptionsInfo();
		new ArgHelperOptionsInfo( "a b c" );
		new ArgHelperOptionsInfo( "aa bb,2 cc" );
		new ArgHelperOptionsInfo( "long-option-dashed-name" );
		new ArgHelperOptionsInfo( "long.option.dotted.name" );
		new ArgHelperOptionsInfo( "long_option_underscore_name" );
		new ArgHelperOptionsInfo( "long-option_mixed.name" );
	}
	
	
		void
	checkCreateFailure( String options )
		throws ArgHelper.IllegalOptionException
	{
		try
		{
			new ArgHelperOptionsInfo( options );
			fail( "expected failure from option description \"" + options + "\"" );
		}
		catch( Exception e )
		{
			// good
		}
	}
	
		public void
	testCreateFailures()
		throws ArgHelper.IllegalOptionException
	{
		final String	illegals	= "~`!@#$%^&*()+={}[]|\\:;\"'<>?,/";
		
		for( int i = 0; i < illegals.length(); ++i )
		{
			checkCreateFailure( "" + illegals.charAt( i ) );
		}
	}
	
	
		public void
	testIllegals()
		throws ArgHelper.IllegalOptionException
	{
		final ArgHelperOptionsInfo	info	= new ArgHelperOptionsInfo( "hello h" );
		
		assertEquals( false, info.isLegalOption( "hello" ) );
		assertEquals( false, info.isLegalOption( "-hello" ) );
		assertEquals( false, info.isLegalOption( "h" ) );
		assertEquals( false, info.isLegalOption( "--h" ) );
		assertEquals( false, info.isLegalOption( "-" ) );
		assertEquals( false, info.isLegalOption( "--" ) );
		assertEquals( false, info.isLegalOption( "" ) );
	}
	
		public void
	testLegals()
		throws ArgHelper.IllegalOptionException
	{
		final ArgHelperOptionsInfo	info	= new ArgHelperOptionsInfo( "hello --there,3 x,1 -y,1" );
		
		assertEquals( true, info.isLegalOption( "--hello" ) );
		assertEquals( true, info.isLegalOption( "--there" ) );
		assertEquals( true, info.isLegalOption( "-x" ) );
		assertEquals( true, info.isLegalOption( "-y" ) );
	}
	
	
		void
	checkRedundantFailure( String args )
	{
		try
		{
			new ArgHelperOptionsInfo( args );
			fail( "expected rejection of redundant option" );
		}
		catch( Exception e )
		{
		}
	}

		public void
	testRedundant()
		throws ArgHelper.IllegalOptionException
	{
		checkRedundantFailure( "a a" );
		checkRedundantFailure( "aa aa" );
		checkRedundantFailure( "--aa --aa" );
		checkRedundantFailure( "-a -a" );
	}

		public void
	testMixedArgs()
		throws ArgHelper.IllegalOptionException
	{
		final ArgHelperOptionsInfo	info	= new ArgHelperOptionsInfo( "a b,1 c,2 d,3 --xyz,4" );
		
		assertEquals( true, info.isLegalOption( "-a" ) );
		assertEquals( false, info.isLegalOption( "--a" ) );
		assertEquals( 1, info.getNumValues( "-a" ) );
		assertEquals( true, info.isBoolean( "-a" ) );
		
		assertEquals( 1, info.getNumValues( "-b" ) );
		assertEquals( 2, info.getNumValues( "-c" ) );
		assertEquals( 3, info.getNumValues( "-d" ) );
		assertEquals( 4, info.getNumValues( "--xyz" ) );
		
	}



		public
	ArgHelperOptionsInfoTest()
	{
	}

		public void
	setUp()
	{
	}
	
		public void
	tearDown()
	{
	}

}

