/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-cli/cli-api/src/java/com/sun/cli/jmx/cmd/CmdFactory.java,v 1.3 2005/12/25 03:45:29 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:45:29 $
 */
 
package com.sun.cli.jmx.cmd;

import java.util.HashMap;
import java.util.ArrayList;
import java.util.Iterator;

import com.sun.cli.jmx.support.CLISupportMBeanProxy;
import com.sun.cli.util.ClassUtil;
import com.sun.cli.util.stringifier.SmartStringifier;

public class CmdFactory
{
	private final HashMap	mCmds;
	
	public static final String	DEFAULT_CMD_NAME	= "DEFAULT_CMD";
	
		private static void
	p( Object o )
	{
		System.out.println( SmartStringifier.toString( o ) );
	}
	
		public
	CmdFactory()
	{
		mCmds	= new HashMap();
	}
	
		public void
	addCmdMapping( String name, Class theClass )
	{
		if ( ! Cmd.class.isAssignableFrom( theClass ) )
		{
			throw new IllegalArgumentException( "Command " + theClass.getName() +
				" must implement " + Cmd.class.getName() );
		}
		
		mCmds.put( name, theClass );
	}
	
		public void
	removeCmdMapping( String name )
	{
		mCmds.remove( name );
	}
	
		public Cmd
	createCmd( String name, CmdEnv env )
		throws Exception
	{
		final String	cmdString	= name;
		
		final Cmd	cmd	= instantiateCmd( cmdString, env );
		
		return( cmd );
	}
	
		public Class
	getClass( String cmdName  )
		throws Exception
	{
		final Class	cmdClass	= (Class)mCmds.get( cmdName );
		
		return( cmdClass );
	}
	
		public String []
	getNames( Class theClass )
	{
		final ArrayList	list	= new ArrayList();
		
		final Iterator keys	= mCmds.keySet().iterator();
		
		while( keys.hasNext() )
		{
			final String	key	= (String)keys.next();
			
			final Class	thisClass	= (Class)mCmds.get( key );
			if ( thisClass == theClass ) 
			{
				list.add( key );
			}
		}
		
		final String []	names	= new String [ list.size() ];
		list.toArray( names );
		
		return( names );
	}
	
		private Cmd
	instantiateCmd( String cmdName, CmdEnv env )
		throws Exception
	{
		Class	cmdClass	= (Class)mCmds.get( cmdName );
		
		if ( cmdClass == null )
		{
			// not found; see if there is a default registered
			cmdClass	= (Class)mCmds.get( DEFAULT_CMD_NAME );
		}
		
		if ( cmdClass == null )
		{
			return( null );
		}

		final Object []	args	= new Object [] { env };

		Cmd cmd	= null;
		try
		{
			cmd	= (CmdBase)ClassUtil.InstantiateObject( cmdClass, args );
		}
		catch( Exception e )
		{
			p( e.getMessage() );
			e.printStackTrace();
			throw e;
		}
		
		return( cmd );
	}
}

