/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-cli/cli-api/src/java/com/sun/cli/jmx/cmd/CmdFactoryIniter.java,v 1.3 2005/12/25 03:45:29 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:45:29 $
 */
 
package com.sun.cli.jmx.cmd;

import java.lang.reflect.Method;

public final class CmdFactoryIniter
{
	final CmdFactory	mFactory;
		
		public
	CmdFactoryIniter( CmdFactory factory)
		throws Exception
	{
		mFactory	= factory;
	}
	
		public
	CmdFactoryIniter( CmdFactory factory, final Class [] cmds )
		throws Exception
	{
		mFactory	= factory;
		init( cmds );
	}

	
		public void
	addMappings( Class theClass )
		throws Exception
	{
		final String []	names	= CmdBase.getCmdNames( theClass );
		
		for( int i = 0; i < names.length; ++i )
		{
			mFactory.addCmdMapping( names[ i ], theClass );
		}
	}
	
		public void
	removeMappings( Class theClass )
		throws Exception
	{
		final String []	names	= CmdBase.getCmdNames( theClass );
		
		for( int i = 0; i < names.length; ++i )
		{
			mFactory.removeCmdMapping( names[ i ] );
		}
	}
	
		private void
	init( final Class [] cmds )
		throws Exception
	{
		for( int i = 0; i < cmds.length; ++i )
		{
			addMappings( cmds[ i ] );
		}
	}
}

