/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-cli/cli-api/src/java/com/sun/cli/jmx/cmd/ConnectInfo.java,v 1.3 2005/12/25 03:45:33 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:45:33 $
 */
 

package com.sun.cli.jmx.cmd;

import javax.management.remote.JMXServiceURL;
import javax.management.remote.JMXConnector;
import java.net.MalformedURLException;

import java.util.Map;
import java.util.HashMap;

import com.sun.cli.jmx.support.ArgParserImpl;
import com.sun.cli.jmx.support.ArgParserException;


public final class ConnectInfo
{
	public final Map		mParams;
	
	public final static char	ESCAPE_CHAR	= '\\';
	public final static char	VALUE_DELIM		= '=';
	public final static char	PAIR_DELIM		= ',';
	
	
	/*
		A connect string consists of a series of name/value pairs eg:
		host=myhost,port=9993,user=foo
	*/
		static Map
	connectStringToParams( final String connectString )
		throws ArgParserException
	{
		final Map	m	= new java.util.HashMap();
		
		final ArgParserImpl.ParseChars	parseChars	= new ArgParserImpl.ParseChars();
		parseChars.mArgDelim	= PAIR_DELIM;
		final ArgParserImpl	parser	= new ArgParserImpl();
		
		final String []	pairs	= parser.ParseNames( connectString );
		
		for( int i = 0; i < pairs.length; ++i )
		{
			final String	pair	= pairs[ i ];
			final int		delimIndex	= pair.indexOf( VALUE_DELIM );
			
			if ( delimIndex <= 0 )
			{
				throw new IllegalArgumentException( "Illegal connect string: " + connectString );
			}
				
				
			final String	name	= pair.substring( 0, delimIndex );
			final String	value	= pair.substring( delimIndex + 1, pair.length() );
			
			m.put( name, value );
		}

		return( m );
	}

		public
	ConnectInfo( final String connectString )
		throws ArgParserException
	{
		this( connectStringToParams( connectString ) );
	}
	
		public
	ConnectInfo( final Map params )
		throws ArgParserException
	{
		mParams	= params;
	}

	
		public
	ConnectInfo( final ConnectInfo rhs )
	{
		mParams	= new HashMap();
		mParams.putAll( rhs.mParams );
	}
	

		static String
	escapeString( char charToEscape, String stringToEscape )
	{
		String	result	= stringToEscape;
		
		if ( result.indexOf( charToEscape ) >= 0 )
		{
			result	= result.replaceAll( "" + charToEscape,
								ESCAPE_CHAR + "" + charToEscape );
		}
		return( result );
	}
	
		static String
	escapeString( String value )
	{
		String	escapedValue	= escapeString( PAIR_DELIM, value );
		escapedValue	= escapeString( VALUE_DELIM, escapedValue );
		
		return( escapedValue );
	}
	
		String
	paramsToString( )
	{
		final java.util.Iterator	iter	= mParams.keySet().iterator();
		
		StringBuffer	buf	= new StringBuffer();
		while ( iter.hasNext() )
		{
			final String	key		= (String)iter.next();
			final String	value	=(String)mParams.get( key );
			
			final String	pair	= key + VALUE_DELIM + escapeString( value );
			
			buf.append( PAIR_DELIM + pair );
		}
		
		String	result	= buf.toString();
		if ( result.length() != 0 )
		{
			// strip leading ":"
			result	= result.substring( 1, result.length() );
		}
		
		return( result );
	}
	
		String
	getParam( String name )
	{
		return( (String)mParams.get( name ) );
	}
		
		public String
	toString()
	{
		return( paramsToString() );
	}
	
	
		public boolean
	equals( Object o )
	{
		if ( o == this )
		{
			return( true );
		}
			
		if ( ! (o instanceof ConnectInfo ) )
		{
			return( false );
		}
		
		final ConnectInfo	rhs	= (ConnectInfo)o;
		
		return( mParams.equals( rhs.mParams ) );
	}
}







