/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-cli/cli-api/src/java/com/sun/cli/jmx/cmd/DeleteCmd.java,v 1.3 2005/12/25 03:45:34 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:45:34 $
 */
 
package com.sun.cli.jmx.cmd;

import com.sun.cli.jmx.support.CLISupportMBeanProxy;

/*
	Invokes the 'list' commmand on all specified targets
 */
public class DeleteCmd extends JMXCmd
{
		public
	DeleteCmd( final CmdEnv env )
	{
		super( env );
	}
	
		int
	getNumRequiredOperands()
	{
		return( 1 );
	}
	
		public String
	getUsage()
	{
		return( CmdStrings.DELETE_HELP.toString() );
	}
	
	
		ArgHelper.OptionsInfo
	getOptionInfo()
		throws ArgHelper.IllegalOptionException
	{
		return( new ArgHelperOptionsInfo( ) );
	}

	
		public static String []
	getNames( )
	{
		return( new String [] { NAME, NAME_ABBREV } );
	}
	
	final static String	NAME		= "delete";
	final static String	NAME_ABBREV	= "del";

	
		void
	executeInternal()
		throws Exception
	{
		final String [] operands	= getOperands();
		
		if ( operands.length != 1 )
		{
			final String	msg	= "Exactly one name must be specified";
			printError( msg  );
			throw new IllegalArgumentException( msg );
		}
		final String name	= operands[ operands.length - 1 ];
			
		establishProxy();
		getProxy().mbeanUnregister( name );
	}
}






