/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-cli/cli-api/src/java/com/sun/cli/jmx/cmd/SetenvCmd.java,v 1.3 2005/12/25 03:45:40 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:45:40 $
 */
 
package com.sun.cli.jmx.cmd;

import java.util.ArrayList;
import java.util.Iterator;

import com.sun.cli.util.stringifier.IteratorStringifier;

import com.sun.cli.jmx.spi.JMXConnectorProvider;

public class SetenvCmd extends JMXCmd
{
		public
	SetenvCmd( final CmdEnv env )
	{
		super( env );
	}
	
		int
	getNumRequiredOperands()
	{
		return( 0 );
	}
	
	
		String
	getUsage()
	{
		return( CmdStrings.SETENV_HELP.toString() );
		//return( CmdStrings.SETENV_HELP.toString() );
	}
	
	public final static String NAME			= "setenv";
	
		public static String []
	getNames( )
	{
		return( new String [] { NAME } );
	}
	
	
	static private final String	OPTIONS_INFO	= "";
		
	
		ArgHelper.OptionsInfo
	getOptionInfo()
		throws ArgHelper.IllegalOptionException
	{
		return( new ArgHelperOptionsInfo( OPTIONS_INFO ) );
	}


		void
	displayEnv()
	{
		final Iterator	iter	= getEnvKeys().iterator();
		
		while ( iter.hasNext() )
		{
			final String name	= (String)iter.next();
			
			final Object value	= envGet( name );
			
			if ( value instanceof String )
			{
				println( name + "=" + value );
			}
		}
	}
	
	public final static char	DELIM	= '=';
	
		void
	executeInternal()
		throws Exception
	{
		final String []	operands	= getOperands();
		
		if ( operands.length == 0 )
		{
			displayEnv();
		}
		else if ( operands.length == 1 )
		{
			final String oper	= operands[ 0 ];
			final int			delimIndex	= oper.indexOf( DELIM );
			
				
			if ( delimIndex > 0 )
			{
				final String	name	= oper.substring( 0, delimIndex );
				final String	value	= oper.substring( delimIndex + 1, oper.length() );
				
				envPut( name, value, true );
			}
			else
			{
				if ( envGet( oper ) != null )
				{
					envRemove( oper );
					println( "Variable " + oper + " removed." );
				}
				else
				{
					println( "Variable " + oper + " does not exist." );
				}
			}
		}
		else
		{
			printUsage();
		}
	}
}






