/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-cli/cli-api/src/java/com/sun/cli/jmx/test/JUnitTestsMain.java,v 1.3 2005/12/25 03:45:52 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:45:52 $
 */
 
package com.sun.cli.jmx.test;

import java.util.Iterator;
import java.util.Arrays;

import junit.extensions.ActiveTestSuite;

import com.sun.cli.jmx.cmd.ArgHelperTest;
import com.sun.cli.jmx.cmd.ArgHelperOptionsInfoTest;
import com.sun.cli.util.TokenizerTest;
import com.sun.cli.jmx.support.ArgParserTest;
import com.sun.cli.jmx.support.AliasMgrTest;
import com.sun.cli.jmx.support.CLISupportMBeanImplTest;
import com.sun.cli.jmx.util.ObjectNameQueryImplTest;

public class JUnitTestsMain
{
	
	final static Class [] TEST_CLASSES = 
	{
		ObjectNameQueryImplTest.class,
		TokenizerTest.class,
		ArgHelperOptionsInfoTest.class,
		ArgHelperTest.class,
		ArgParserTest.class,
		AliasMgrTest.class,
		CLISupportMBeanImplTest.class,
	};
	
		static void
	testClass( Class theClass )
	{
		System.out.println( "*** testing " + theClass.getName() + " ***");
		// use 'ActiveTestSuite' to thread the tests
		final ActiveTestSuite	suite	= new ActiveTestSuite( theClass );
		junit.textui.TestRunner.run( suite );
	}
	
		public static void
	main( String [] args )
	{
		final Iterator iter	= Arrays.asList( TEST_CLASSES ).iterator();
		
		while ( iter.hasNext() )
		{
			final Class	theClass	= (Class)iter.next();
			
			testClass( theClass );
		}
	}
}


