/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-cli/cli-api/src/java/com/sun/cli/jmx/util/ObjectNameQuery.java,v 1.3 2005/12/25 03:45:55 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:45:55 $
 */
package com.sun.cli.jmx.util;

import java.util.Set;

import javax.management.ObjectName;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;

public interface ObjectNameQuery
{
	/*
		Return the ObjectNames of all MBeans whose properties match all the specified
		regular expressions.  Both property names and values may be searched.
		
		A starting set may be specified by using an ObjectName pattern.
		This can greatly improve the performance of the search by restricting the
		set of MBeans which are examined; otherwise all registered MBeans must be examined.
		
		The regexNames[ i ] pattern corresponds to regexValues[ i ].  A value of null
		for any item is taken to mean "match anything".  Thus specifing null for 
		'regexNames' means "match any name" and specifying regexNames[ i ] = null means
		to match only based on regexValues[ i ] (and vice versa).
		
		@param startingSetPattern 	optional ObjectName pattern for starting set to search
		@param regexNames			optional series of regular expressions for Property names
		@param regexNames			optional series of regular expressions for Property values
		@returns 					array of ObjectName (may be of zero length)
	 */
	Set	matchAll( Set startingSet, String [] regexNames, String [] regexValues );
				
	/*
		Return the ObjectNames of all MBeans whose properties match any of the specified
		regular expressions.  Both property names and values may be searched.
		
		A starting set may be specified by using an ObjectName pattern.
		This can greatly improve the performance of the search by restricting the
		set of MBeans which are examined; otherwise all registered MBeans must be examined.
		
		
		The regexNames[ i ] pattern corresponds to regexValues[ i ].  A value of null
		for any item is taken to mean "match anything".  Thus specifing null for 
		'regexNames' means "match any name" and specifying regexNames[ i ] = null means
		to match only based on regexValues[ i ] (and vice versa).
		
		@param startingSetPattern 	optional ObjectName pattern for starting set to search
		@param regexNames			optional series of regular expressions for Property names
		@param regexNames			optional series of regular expressions for Property values
		@returns 					array of ObjectName (may be of zero length)
	 */
	Set	matchAny( Set startingSet, String [] regexNames, String [] regexValues );
}






