/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-cli/cli-api/src/java/com/sun/cli/util/stringifier/MBeanServerNotificationStringifier.java,v 1.3 2005/12/25 03:46:06 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:46:06 $
 */
 

package com.sun.cli.util.stringifier;

import javax.management.MBeanServerNotification;

import java.util.Date;
import javax.management.Notification;


public class MBeanServerNotificationStringifier
				extends NotificationStringifier implements Stringifier
{
	public static MBeanServerNotificationStringifier	DEFAULT	=
			new MBeanServerNotificationStringifier();
	
		public
	MBeanServerNotificationStringifier( )
	{
		super();
	}
	
		public
	MBeanServerNotificationStringifier( Options options )
	{
		super( options );
	}
	
		public String
	stringify( Object o )
	{
		final MBeanServerNotification	notif	= (MBeanServerNotification)o;
		
		final StringBuffer	b	= super._stringify( notif );
		append( b, "" );
		
		append( b, "registered MBean: " + notif.getMBeanName() );
		
		return( b.toString() );
	}
}



















