/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.cli.commands;

/**
   Note that this test requires resources for testing. These resources
   are construct4ed from the two files P1 & P2 located in the current
   directory. If these file names are changed then the corresponding
   names in this submodules build.xml file should be changed also
*/
import com.sun.enterprise.cli.framework.*;
//import java.util.ArrayList;
//import java.util.Arrays;
//import java.util.HashMap;
//import java.util.List;
//import java.util.Properties;
import junit.framework.*;
import junit.textui.TestRunner;
import java.util.Vector;
/**
 *
 * @author prashanth.abbagani@sun.com
 * @version $Revision: 1.2 $
 */

/**
   Execute these tests using gmake (and Ant) by:
   cd <commands>
   gmake ANT_TARGETS=CommandTest.java
*/

public class DottedNamesCommandTest extends TestCase {

    public void testcheckPropertyToConvertValid() throws Exception{
        assertEquals(testCommand.checkPropertyToConvert("server.jdbc-resource.jdbc1.property"), true);
    }

    public void testcheckPropertyToConvertInvalid() throws Exception{
        assertEquals(testCommand.checkPropertyToConvert("server.jdbc-resource.jdbc1.property.xyz"), false);
    }

    public void testconvertUnderscoreToHyphenWithEquals() throws Exception{
        String value = testCommand.convertUnderscoreToHyphen("server.jdbc-resource.jdbc1.attr_1=value");
        assertEquals(value, "server.jdbc-resource.jdbc1.attr-1=value");
        
    }

    public void testconvertUnderscoreToHyphenWithoutEquals() throws Exception{
        
        String value = testCommand.convertUnderscoreToHyphen("server.jdbc-resource.jdbc1.attr_1");
        assertEquals(value, "server.jdbc-resource.jdbc1.attr-1");
        
    }

    public void testValidateOptionsWithFailureCase() throws Exception{
        testCommand.setName("get");
        testCommand.setOption("monitor", "true");
        testCommand.setOption("iterations", "1");
        testCommand.setOption("interval", "0");
        assertEquals(testCommand.validateOptions(), false);
    }

    public void testValidateOptions() throws Exception{
        testCommand.setName("set");
        assertEquals(testCommand.validateOptions(), true);
    }

    public DottedNamesCommandTest(String name){
        super(name);
    }

    DottedNamesCommand testCommand = null;

    protected void setUp() throws Exception{
        //Properties systemProperties = new java.util.Propertis();
        //systemProperties.put("com.sun.aas.configRoot",)
        //String configProperty = SystemPropertyConstants.CONFIG_ROOT_PROPERTY;
        //System.out.println(configProperty + " = " + System.getProperty(configProperty));
        final CLIDescriptorsReader cliDescriptorsReader = CLIDescriptorsReader.getInstance();
        ValidCommand validCommand = cliDescriptorsReader.getCommand(null);
        LocalStringsManagerFactory.setCommandLocalStringsManagerProperties(
            CLIDescriptorsReader.getInstance().getProperties());
        testCommand = new DottedNamesCommand();
        testCommand.setName("sampleCommand");
    }
  
  

    protected void tearDown() {
    }

    private void nyi(){
        fail("Not Yet Implemented");
    }

    public static Test suite(){
        TestSuite suite = new TestSuite(BackupCommandsTest.class);
        return suite;
    }

    public static void main(String args[]) throws Exception {
        final TestRunner runner= new TestRunner();
        final TestResult result = runner.doRun(BackupCommandsTest.suite(), false);
        System.exit(result.errorCount() + result.failureCount());
    }
}

