/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.cli.commands;

/**
   Note that this test requires resources for testing. These resources
   are construct4ed from the two files P1 & P2 located in the current
   directory. If these file names are changed then the corresponding
   names in this submodules build.xml file should be changed also
*/
import com.sun.enterprise.cli.framework.*;
//import java.util.ArrayList;
//import java.util.Arrays;
//import java.util.HashMap;
//import java.util.List;
//import java.util.Properties;
import junit.framework.*;
import junit.textui.TestRunner;
import java.util.Vector;
import java.io.File;
import java.io.PrintWriter;
import java.io.OutputStreamWriter;
import java.io.FileOutputStream;
/**
 *
 * @author prashanth.abbagani@sun.com
 * @version $Revision: 1.2 $
 */

/**
   Execute these tests using gmake (and Ant) by:
   cd <commands>
   gmake ANT_TARGETS=CommandTest.java
*/

public class UnsetCommandTest extends TestCase {

    public void testrunCommandRemoveEnvVariables() throws Exception{
        Vector operands = new Vector();
        System.setProperty("user.home", System.getProperty("java.io.tmpdir"));//tempDir.getPath());
        operands.add("AS_ADMIN_USER");
        operands.add("AS_ADMIN_PASSWORD");
        testCommand.setOperands(operands);
        CommandEnvironment.getInstance().setEnvironment("user", "admin");
        CommandEnvironment.getInstance().setEnvironment("password", "adminadmin");
        testCommand.runCommand();
        assertEquals(testCommand.getOption("user"), null);
        assertEquals(testCommand.getOption("password"), null);
    }

    public void testrunCommandRemoveEnvVariablesWithWildCard() throws Exception{
        Vector operands = new Vector();
        System.setProperty("user.home", System.getProperty("java.io.tmpdir"));
        operands.add("AS_ADMIN_*");
        testCommand.setOperands(operands);
        CommandEnvironment.getInstance().setEnvironment("user", "admin");
        CommandEnvironment.getInstance().setEnvironment("password", "adminadmin");
        testCommand.runCommand();
        assertEquals(testCommand.getOption("user"), null);
        assertEquals(testCommand.getOption("password"), null);
    }

    public void testrunCommandRemoveNonExistingEnvVariable() throws Exception{
        try{
            Vector operands = new Vector();
            operands.add("AS_ADMIN_INTERACTIVE");
            testCommand.setOperands(operands);
            testCommand.runCommand();
        }catch(CommandException ce){
            assertEquals(ce.getMessage(), "CLI149 Unable to remove environment variable, " +
                    "AS_ADMIN_INTERACTIVE.");
        }
    }

    public void testrunCommandInvalidPrefix() throws Exception{
        try{
            Vector operands = new Vector();
            operands.add("_ADMIN_INTERACTIVE");
            testCommand.setOperands(operands);
            testCommand.runCommand();
        }catch(CommandException ce){
            assertEquals(ce.getMessage(), "CLI163 Could not unset environment variable, _ADMIN_INTERACTIVE.");
        }
    }

    public UnsetCommandTest(String name){
        super(name);
    }

    UnsetCommand testCommand = null;

    protected void setUp() throws Exception{
        //Properties systemProperties = new java.util.Propertis();
        //systemProperties.put("com.sun.aas.configRoot",)
        //String configProperty = SystemPropertyConstants.CONFIG_ROOT_PROPERTY;
        //System.out.println(configProperty + " = " + System.getProperty(configProperty));
        final CLIDescriptorsReader cliDescriptorsReader = CLIDescriptorsReader.getInstance();
        ValidCommand validCommand = cliDescriptorsReader.getCommand(null);
        LocalStringsManagerFactory.setCommandLocalStringsManagerProperties(
            CLIDescriptorsReader.getInstance().getProperties());
        testCommand = new UnsetCommand();
        testCommand.setName("sampleCommand");
    }
  
  

    protected void tearDown() {
    }

    private void nyi(){
        fail("Not Yet Implemented");
    }

    public static Test suite(){
        TestSuite suite = new TestSuite(UnsetCommandTest.class);
        return suite;
    }

    public static void main(String args[]) throws Exception {
        final TestRunner runner= new TestRunner();
        final TestResult result = runner.doRun(UnsetCommandTest.suite(), false);
        System.exit(result.errorCount() + result.failureCount());
    }
}

