/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.framework;

import java.io.Writer;
import java.io.Reader;
import java.io.OutputStreamWriter;
import java.io.InputStreamReader;
import java.io.IOException;
import java.io.FileReader;
import java.io.FileNotFoundException;
import java.io.BufferedWriter;
import java.io.BufferedReader;


/**
 * More.java
 *
 * @author <a href="mailto:toby.h.ferguson@sun.com">Toby H Ferguson</a>
 * @version $Revision: 1.3 $
 *
 * This class provides a primitive more(1) functionality, paging
 * through the given file, with an optional pagelength.
 */

public class More 
{
  public More(int linesPerPage,
			  Reader src,
			  Writer dest,
			  Reader fromUser,
			  Writer toUser,
			  String promptChar,
			  String prompt) throws IOException {

	loopUntilQuit(new User(fromUser, toUser, promptChar, prompt),
				  new Pager(linesPerPage, src, dest));
  }

  private void loopUntilQuit(User user, Pager pager) throws IOException {
	do {
	  pager.nextPage();
	} while (pager.hasNext() && user.wantsToContinue());
  }
    

}





