/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.framework;

import java.util.HashMap;
import java.util.Vector;
import java.util.Arrays;
import junit.framework.*;
/**
 *
 * @author <a href="mailto:toby.h.ferguson@sun.com">Toby H Ferguson</a>
 * @version $Revision: 1.4 $
 */

public class CommandValidatorTest extends TestCase {
    public void testValidCommand3() throws Exception {
        final Vector vos = new Vector();
        vos.add(new ValidOption("vo", "foo", 0, "value"));
        final Vector ros = new Vector();
        ros.add(new ValidOption("ro", "fee", 1, "v"));
		final Vector dos = new Vector();
        final ValidCommand vc = new ValidCommand("name", "*", vos, ros, dos, "useage");
        cv.validateCommandAndOptions(vc, new HashMap(), new Vector());
    }
        
    public void testValidCommand2() throws Exception {
        final Vector vos = new Vector();
        vos.add(new ValidOption("vo", "foo", 0, "value"));
        final Vector ros = new Vector();
        ros.add(new ValidOption("ro", "fee", 1, "v"));
		final Vector dos = new Vector();
        final ValidCommand vc = new ValidCommand("name", "*", vos, ros, dos, "useage");
        cv.validateCommandAndOptions(vc, new HashMap(), new Vector());
    }
        
    public void testValidCommand1() throws Exception {
        final Vector vos = new Vector();
        vos.add(new ValidOption("vo", "String", 1, ""));
        final Vector ros = new Vector();
        ros.add(new ValidOption("ro", "Integer", 0, ""));
		final Vector dos = new Vector();
        final ValidCommand vc = new ValidCommand("name", "3", vos, ros, dos, "useage");
        cv.validateCommandAndOptions(vc, new HashMap(),
                                     new Vector(Arrays.asList(new String[] {"1", "2", "3"})));
    }
    
    public void testValidCommandWithSimpleConstructors() throws Exception {
        final ValidCommand vc = new ValidCommand();
        //cv.validateCommandAndOptions(vc, new HashMap(), new Vector());
    }

    public CommandValidatorTest(String name){
        super(name);
    }
    CommandValidator cv;
    
    protected void setUp() {
         cv = new CommandValidator();
    }

    protected void tearDown() {
    }

    private void nyi(){
        fail("Not Yet Implemented");
    }

    public static void main(String args[]){
        if (args.length == 0){
            junit.textui.TestRunner.run(CommandValidatorTest.class);
        } else {
            junit.textui.TestRunner.run(makeSuite(args));
        }
    }
    private static TestSuite makeSuite(String args[]){
        final TestSuite ts = new TestSuite();
        for (int i = 0; i < args.length; i++){
            ts.addTest(new CommandValidatorTest(args[i]));
        }
        return ts;
    }
}
