/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.framework;

import junit.framework.*;
/**
 *
 * @author <a href="mailto:toby.h.ferguson@sun.com">Toby H Ferguson</a>
 * @version $Revision: 1.4 $
 */

public class ValidPropertyTest extends TestCase {
    public void testValueMutation(){
        ValidProperty vp = new ValidProperty("name", "value");
        assertEquals("name", vp.getName());
        assertEquals("value", vp.getValue());
        vp.setValue("foo");
        assertEquals("foo", vp.getValue());
        assertEquals("name", vp.getName());
    }

    public void testNameMutation(){
        ValidProperty vp = new ValidProperty("name", "value");
        assertEquals("name", vp.getName());
        assertEquals("value", vp.getValue());
        vp.setName("foo");
        assertEquals("foo", vp.getName());
        assertEquals("value", vp.getValue());
    }
    public void testSimpleConstructor(){
        ValidProperty vp = new ValidProperty("name", "value");
        assertEquals("name", vp.getName());
        assertEquals("value", vp.getValue());
    }
    

    public void testEmptyConstructor() {
        ValidProperty vp = new ValidProperty();
        assertNull(vp.getName());
    }

    public ValidPropertyTest(String name){
        super(name);
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    private void nyi(){
        fail("Not Yet Implemented");
    }

    public static void main(String args[]){
        if (args.length == 0){
            junit.textui.TestRunner.run(ValidPropertyTest.class);
        } else {
            junit.textui.TestRunner.run(makeSuite(args));
        }
    }
    private static TestSuite makeSuite(String args[]){
        final TestSuite ts = new TestSuite();
        for (int i = 0; i < args.length; i++){
            ts.addTest(new ValidPropertyTest(args[i]));
        }
        return ts;
    }
}
