/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

import org.xml.sax.InputSource;
import java.util.Properties;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.SAXException;
import org.xml.sax.Attributes;
import java.io.IOException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXNotRecognizedException;
import javax.xml.parsers.SAXParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileOutputStream;

class MakeCatalog extends DefaultHandler
{
    final String prefix;

    MakeCatalog(){
        prefix = "";
    }
    
    MakeCatalog(final String prefix){
        this.prefix = (prefix != null ? prefix +"." : "");
    }
    

    public static void main(String [] args) throws Exception {
        if (args.length < 2 || 3 < args.length ){
            useage();
            System.exit(1);
        }

        final String prefix = (args.length == 2 ? null : args[0]);
        final String in = (args.length == 2 ? args[0] : args[1]);
        final String out = (args.length == 2 ? args[1] : args[2]);
        
        final MakeCatalog mc = new MakeCatalog(prefix);
        final InputSource is = new InputSource(new FileReader(new File(in)));
        is.setSystemId(in);
        mc.makeCatalog(is);
        mc.getProperties().save(new FileOutputStream(new File(out)), null);
        System.exit(0);
    }

    private static void useage(){
        System.err.println("Useage: MakeCatalog [prefix] in out");
    }
    
        
    private static final String NAMESPACES="http://xml.org/sax/features/namespaces";
    private static final String PREFIXES="http://xml.org/sax/features/namespace-prefixes";
    private static final File SCHEMA=new File("./message-catalog.rng");
        
    void makeCatalog(InputSource is) throws ParserConfigurationException, SAXNotRecognizedException, SAXException, IOException {
//         final SAXParserFactory spf = SAXParserFactory.newInstance();
        final SAXParserFactory spf = new com.sun.msv.verifier.jaxp.SAXParserFactoryImpl();

        spf.setNamespaceAware(true);
        spf.setValidating(false);
        spf.setFeature(NAMESPACES, true);
        spf.setFeature(PREFIXES, false);

        final SAXParser p = spf.newSAXParser();
        p.setProperty("http://www.sun.com/xml/msv/schema", SCHEMA);        
//         spf.newSAXParser().parse(is, this);
        p.parse(is, this);
    }
    
    Properties getProperties(){
        return properties;
    }

    Properties properties;

    public void startDocument() throws SAXException{
        properties = new Properties();
    }

    public void startElement(final String uri,
                         final String localName,
                         final String qName,
                         final Attributes attributes)
        throws SAXException{
        if (null == localName){
            throw new SAXException("localName is null");
        }
        
        if (localName.equals("messages")){ // do nothing
        } else if (localName.equals("message")) {
            startMessage(attributes);
        } else {
            throw new SAXException("Unknown element: "+uri+":"+localName);
        }
    }

    public void characters(char[] ch,
                       int start,
                       int length)
        throws SAXException{
        if (null != sb) {
            sb.append(ch, start, length);
        }
    }
    
    public void endElement(final String uri,
                           final String localName,
                           final String qName) throws SAXException {
        if (localName.equals("messages")){ // do nothing
        } else if (localName.equals("message")) {
            endMessage();
        } else {
            throw new SAXException("Unknown element: "+uri+":"+localName);
        }
    }


    private String key;
    private StringBuffer sb;
    
    private void startMessage(final Attributes attributes) throws SAXException {
        key = (prefix != null ? prefix : "") + attributes.getValue("", "id");
        if (null == key){
            throw new SAXException("message element had no id attribute");
        }
        sb = new StringBuffer();
    }

    private void endMessage() throws SAXException {
        if (null != sb){
            properties.setProperty(key, sb.toString().trim());
        }
        sb = null;
    }
}
