/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.base;


/**
	Attributes available within the MBean every AMX references.
	These Attributes names are needed when accessing MBeans directly
	via {@link StdAttributesAccess#getAttribute} or 
	{@link StdAttributesAccess#getAttributes}.
 */
public final class AMXAttributes
{
	/**
		Attribute of type ObjectName; the ObjectName of this MBean.
		@see Extra#getObjectName
	 */
	public static final String	ATTR_OBJECT_NAME		= "ObjectName";
	
	/**
		Attribute of type String which denotes the classname of the proxy
		(AMX) for this MBean.
		@see Extra#getInterfaceName
	 */
	public static final String	ATTR_INTERFACE_NAME		= "InterfaceName";
	
	/**
		Attribute of type ObjectName.
		@see Extra#getInterfaceName
	 */
	public static final String	ATTR_CONTAINER_OBJECT_NAME		= "ContainerObjectName";
	
	/**
		Attribute of type boolean.
		@see Extra#getMBeanInfoIsInvariant
	 */
	public static final String	ATTR_MBEAN_INFO_IS_INVARIANT= "MBeanInfoIsInvariant";
	
	/**
		Attribute of type String.
		@see AMX#getFullType
	 */
	public static final String	ATTR_FULL_TYPE		= "FullType";

	/**
		Attribute returned by getGroup().
		@see AMX#getGroup
	 */
	public static final String	ATTR_GROUP	= "Group";

	/**
		Attribute returned by getName().
		@see AMX#getName
	 */
	public static final String	ATTR_NAME	= "Name";
	
	/**
		Attribute of type String[]
		@see Extra#getAttributeNames
	 */
	public static final String	ATTR_ATTRIBUTE_NAMES		= "AttributeNames";
}
